/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.internal.DPIUtil;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalGalleryGroup
implements IGalleryGroup {
    private static final Comparator<IGalleryItem> LOCAL_ITEM_COMPARATOR = new Comparator<IGalleryItem>(){

        @Override
        public int compare(IGalleryItem item1, IGalleryItem item2) {
            File file1 = ((LocalGalleryItem)item1).getFile();
            File file2 = ((LocalGalleryItem)item2).getFile();
            return (int)(file1.lastModified() - file2.lastModified());
        }
    };
    private File dir;
    private String name;

    public LocalGalleryGroup(File dir, String name) {
        this.dir = dir;
        this.name = name;
    }

    @Override
    public String getSymbolicName() {
        return this.dir.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<IGalleryItem> getItems() {
        ArrayList<String> itemPaths = new ArrayList<String>();
        String[] itemNames = this.dir.list();
        int i = 0;
        while (i < itemNames.length) {
            File itemFile;
            if (!itemNames[i].contains("@2x") && (itemFile = new File(this.dir, itemNames[i])).isFile() && GalleryCore.isImageFile(itemFile.getName())) {
                itemPaths.add(itemFile.getAbsolutePath());
            }
            ++i;
        }
        ArrayList<IGalleryItem> items = new ArrayList<IGalleryItem>();
        boolean needZoom = DPIUtil.getDeviceZoom() > 100;
        for (String path : itemPaths) {
            path = needZoom ? this.get2xPath(path) : path;
            File itemFile = new File(path);
            items.add(new LocalGalleryItem(this, itemFile));
        }
        Collections.sort(items, LOCAL_ITEM_COMPARATOR);
        return items;
    }

    private String get2xPath(String path) {
        int dot = path.lastIndexOf(46);
        if (dot > -1) {
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            String xpath = String.valueOf(lead) + "@2x" + tail;
            if (new File(xpath).exists()) {
                path = xpath;
            }
        }
        return path;
    }

    public int hashCode() {
        return this.dir.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LocalGalleryGroup)) {
            return false;
        }
        return ((LocalGalleryGroup)obj).dir.equals(this.dir);
    }

    File getFile() {
        return this.dir;
    }
}

