/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.NullDecorator;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.part.EditPart;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicalEditPart
extends EditPart
implements IGraphicalEditPart {
    private IFigure figure = null;
    private boolean figureInitiated = false;
    private IDecorator decorator = null;

    @Override
    public IFigure getFigure() {
        if (this.figure == null) {
            this.figure = this.createFigure();
        }
        return this.figure;
    }

    protected boolean hasFigure() {
        return this.figure != null;
    }

    @Override
    public IFigure getContentPane() {
        return this.getFigure();
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        if (!this.figureInitiated) {
            this.initFigure(this.getFigure());
            this.figureInitiated = true;
        }
    }

    protected void initFigure(IFigure figure) {
        LayoutManager layout = this.createLayoutManager();
        if (layout != null) {
            this.getContentPane().setLayoutManager(layout);
        }
        this.getDecorator().activate(this, figure);
    }

    protected LayoutManager createLayoutManager() {
        return null;
    }

    protected abstract IFigure createFigure();

    @Override
    protected void addChildView(IPart child, int index) {
        this.getContentPane().add(((IGraphicalPart)child).getFigure(), index);
    }

    @Override
    protected void removeChildView(IPart child) {
        this.getContentPane().remove(((IGraphicalPart)child).getFigure());
    }

    @Override
    public IDecorator getDecorator() {
        if (this.decorator == null) {
            return NullDecorator.getInstance();
        }
        return this.decorator;
    }

    public void setDecorator(IDecorator decorator) {
        this.decorator = decorator;
    }

    @Override
    protected void onDeactivated() {
        super.onDeactivated();
        if (this.figure != null && this.figureInitiated) {
            this.getDecorator().deactivate(this, this.figure);
            this.figureInitiated = false;
        }
    }

    @Override
    protected void updateView() {
        super.updateView();
        if (this.getFigure() != null) {
            if (!this.figureInitiated) {
                this.initFigure(this.getFigure());
                this.figureInitiated = true;
            }
            this.getDecorator().decorate(this, this.getFigure());
        }
    }

    @Override
    protected void updateChildren() {
        super.updateChildren();
        if (this.getFigure() != null) {
            if (!this.figureInitiated) {
                this.initFigure(this.getFigure());
                this.figureInitiated = true;
            }
            this.getDecorator().decorateChildren(this, this.getFigure());
        }
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IFigure f;
        if (adapter == IFigure.class) {
            return adapter.cast(this.getFigure());
        }
        if (adapter == IUseTransparency.class && (f = this.getFigure()) instanceof IUseTransparency) {
            return adapter.cast(f);
        }
        if (adapter == IDecorator.class) {
            return adapter.cast(this.getDecorator());
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IPart findAt(Point position) {
        return this.findAt(position, null);
    }

    @Override
    public IPart findAt(Point position, IViewer.IPartSearchCondition condition) {
        IPart ret = this.findChildAt(position);
        if (ret != null) {
            return ret;
        }
        if (this.containsPoint(position) && (condition == null || condition.evaluate(this))) {
            return this;
        }
        return null;
    }

    protected IPart findChildAt(Point position) {
        List<IPart> children = this.getChildren();
        int i = children.size() - 1;
        while (i >= 0) {
            IPart child = children.get(i);
            IPart ret = this.findChildAt(child, position);
            if (ret != null) {
                return ret;
            }
            --i;
        }
        return null;
    }

    protected IPart findChildAt(IPart child, Point position) {
        if (child instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)child).findAt(position);
        }
        return null;
    }

    @Override
    public IFigure findTooltipAt(Point position) {
        if (this.containsPoint(position)) {
            return this.getFigure().getToolTip();
        }
        return null;
    }

    @Override
    public boolean containsPoint(Point position) {
        return this.getFigure().isShowing() && this.getFigure().containsPoint(position);
    }

    @Override
    public Cursor getCursor(Point pos) {
        return null;
    }

    public void updateToolTip() {
        IFigure fig = this.getFigure();
        if (fig != null) {
            fig.setToolTip(this.createToolTip());
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (!GraphicalEditPart.this.getStatus().isActive()) {
                        return;
                    }
                    IViewer viewer = GraphicalEditPart.this.getSite().getViewer();
                    if (viewer == null || viewer.getControl().isDisposed()) {
                        return;
                    }
                    viewer.updateToolTip();
                }
            });
        }
    }

    protected IFigure createToolTip() {
        return null;
    }

    public String getActionId() {
        return null;
    }
}

