/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.ISourceProvider2;
import org.xmind.gef.command.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCommand
extends Command
implements ISourceProvider2 {
    private List<Command> commands;
    private boolean executing = false;
    private boolean sourceCollectable = true;

    public CompoundCommand(List<? extends Command> commands) {
        this("", commands);
    }

    public CompoundCommand(Command ... commands) {
        this("", commands);
    }

    public CompoundCommand(String label, List<? extends Command> commands) {
        super(label);
        Assert.isNotNull(commands);
        for (Command command : commands) {
            Assert.isNotNull((Object)command);
        }
        this.commands = new ArrayList<Command>(commands);
    }

    public CompoundCommand(String label, Command ... commands) {
        super(label);
        Assert.isNotNull((Object)commands);
        Command[] commandArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            Command c = commandArray[n2];
            Assert.isNotNull((Object)c);
            ++n2;
        }
        List<Command> list = Arrays.asList(commands);
        this.commands = new ArrayList<Command>(list);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public int getType() {
        boolean hasModifyCommand = false;
        for (Command cmd : this.commands) {
            int type = cmd.getType();
            if (type == 3 && !hasModifyCommand) {
                hasModifyCommand = true;
            }
            if (type == 0 || type == 3) continue;
            return type;
        }
        if (hasModifyCommand) {
            return 3;
        }
        return super.getType();
    }

    @Override
    public boolean hasSource() {
        for (Command c : this.commands) {
            if (!(c instanceof ISourceProvider) || !((ISourceProvider)((Object)c)).hasSource()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getSource() {
        for (Command c : this.commands) {
            Object source;
            if (!(c instanceof ISourceProvider) || c instanceof ISourceProvider2 && !((ISourceProvider2)((Object)c)).isSourceCollectable() || (source = ((ISourceProvider)((Object)c)).getSource()) == null) continue;
            return source;
        }
        return null;
    }

    @Override
    public List<Object> getSources() {
        ArrayList<Object> sources = new ArrayList<Object>();
        for (Command c : this.commands) {
            if (!(c instanceof ISourceProvider) || c instanceof ISourceProvider2 && !((ISourceProvider2)((Object)c)).isSourceCollectable()) continue;
            List<Object> ss = ((ISourceProvider)((Object)c)).getSources();
            for (Object s : ss) {
                if (s == null || sources.contains(s)) continue;
                sources.add(s);
            }
        }
        return sources;
    }

    public void append(Command command) {
        Assert.isNotNull((Object)command);
        this.commands.add(command);
    }

    @Override
    public boolean canExecute() {
        for (Command cmd : this.commands) {
            if (!cmd.canExecute()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canRedo() {
        for (Command cmd : this.commands) {
            if (!cmd.canRedo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canUndo() {
        for (Command cmd : this.commands) {
            if (!cmd.canUndo()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void execute() {
        for (Command cmd : this.commands) {
            if (!cmd.canExecute()) continue;
            cmd.execute();
        }
        this.executing = true;
        super.execute();
        this.executing = false;
    }

    @Override
    public void redo() {
        if (!this.executing) {
            for (Command cmd : this.commands) {
                if (!cmd.canRedo()) continue;
                cmd.redo();
            }
        }
        super.redo();
    }

    @Override
    public void undo() {
        int i = this.commands.size() - 1;
        while (i >= 0) {
            Command cmd = this.commands.get(i);
            if (cmd.canUndo()) {
                cmd.undo();
            }
            --i;
        }
        super.undo();
    }

    @Override
    public void dispose() {
        if (this.commands != null) {
            for (Command cmd : this.commands) {
                cmd.dispose();
            }
            this.commands = null;
        }
        super.dispose();
    }

    @Override
    public boolean isSourceCollectable() {
        return this.sourceCollectable;
    }

    @Override
    public void setSourceCollectable(boolean collectable) {
        this.sourceCollectable = collectable;
    }
}

