/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.gefext;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.gefext.ITracker;

public class TrackerEnabledSelectTool
extends SelectTool {
    private ITracker tracker = null;

    protected boolean handleMouseDown(MouseEvent me) {
        ITracker tracker;
        if (this.tracker != null) {
            this.tracker.deactivate();
            this.tracker = null;
        }
        boolean ret = super.handleMouseDown(me);
        if (me.target instanceof IEditPart && (tracker = ((IEditPart)me.target).findTracker(me.cursorLocation)) != null) {
            this.tracker = tracker;
            this.tracker.setEditDomain(this.getDomain());
            this.tracker.activate();
            if (this.tracker.handleMouseDown(me, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        return ret;
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        if (this.tracker != null) {
            if (this.tracker.handleMouseDrag(me, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        return super.handleMouseDrag(me);
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.tracker != null) {
            boolean handledByTracker = this.tracker.handleMouseUp(me, (IViewer)this.getTargetViewer());
            this.tracker.deactivate();
            this.tracker = null;
            if (handledByTracker) {
                return true;
            }
        }
        return super.handleMouseUp(me);
    }

    protected boolean handleMouseEntered(MouseEvent me) {
        IPart part;
        if (this.tracker != null) {
            if (this.tracker.handleMouseEntered(me, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        if (this.getTargetViewer() != null && (part = me.target) != null && part.hasRole("selectable role")) {
            this.getTargetViewer().setPreselected((Object)part);
            if (part instanceof IEditPart) {
                ((IEditPart)part).showTargetFeedback(this.getSelectionRequest(me));
            }
        }
        return true;
    }

    private Request getSelectionRequest(MouseEvent me) {
        return new Request("select").setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer()).setPrimaryTarget(me.target).setParameter("position", (Object)me.cursorLocation);
    }

    protected boolean handleMouseExited(MouseEvent me) {
        IPart part;
        if (this.tracker != null) {
            if (this.tracker.handleMouseExited(me, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        if (this.getTargetViewer() != null && (part = this.getTargetViewer().getPreselectedPart()) != null && me.target == part) {
            this.getTargetViewer().setPreselected(null);
            if (part instanceof IEditPart) {
                ((IEditPart)part).hideTargetFeedback(this.getSelectionRequest(me));
            }
        }
        return true;
    }

    protected boolean handleMouseMove(MouseEvent me) {
        IPart part;
        if (this.getTargetViewer() != null && (part = this.getTargetViewer().getPreselectedPart()) != null && me.target == part && part instanceof IEditPart) {
            ((IEditPart)part).showTargetFeedback(this.getSelectionRequest(me));
        }
        return super.handleMouseMove(me);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        Cursor cursor;
        if (this.tracker != null && (cursor = this.tracker.getCurrentCursor(pos, host)) != null) {
            return cursor;
        }
        return super.getCurrentCursor(pos, host);
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        if (this.tracker != null) {
            if (this.tracker.handleKeyDown(ke, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        return super.handleKeyDown(ke);
    }

    protected boolean handleKeyUp(KeyEvent ke) {
        if (this.tracker != null) {
            if (this.tracker.handleKeyUp(ke, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        return super.handleKeyUp(ke);
    }

    protected boolean handleKeyTraversed(KeyEvent ke) {
        if (this.tracker != null) {
            if (this.tracker.handleKeyTraversed(ke, (IViewer)this.getTargetViewer())) {
                return true;
            }
            this.tracker.deactivate();
            this.tracker = null;
        }
        return super.handleKeyTraversed(ke);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        IPart target = me.target;
        if (target != null && target.hasRole("selectable role")) {
            Request openRequest = new Request("open").setDomain(this.getDomain()).setViewer((IViewer)this.getTargetViewer()).setPrimaryTarget(target).setParameter("position", (Object)me.cursorLocation);
            target.handleRequest(openRequest, "selectable role");
            if (openRequest.isHandled()) {
                return true;
            }
        }
        return super.handleMouseDoubleClick(me);
    }
}

