/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.xmind.verify.IValidity;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.internal.e4models.AbstractProDialogModelPart;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.E4PartWrapper;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.tabfolder.IPageClosedListener;

public class GanttDialogPart
extends AbstractProDialogModelPart
implements IPartListener,
IPageChangedListener,
IPageClosedListener,
IInputChangedListener,
ISelectionChangedListener {
    public static final String PART_ID = "org.xmind.ui.dialogPart.gantt";
    public static final String GANTT_EDIT_CONTEXT_ID = "org.xmind.ui.context.gantt.edit";
    public static final String TASK_TREE_EDIT_CONTEXT_ID = "org.xmind.ui.context.gantt.taskTreeEdit";
    private IGraphicalEditor sourceEditor;
    private IGraphicalEditorPage sourcePage = null;
    private Map<IGraphicalEditor, Collection<IGraphicalEditorPage>> pages = new HashMap<IGraphicalEditor, Collection<IGraphicalEditorPage>>();
    private Map<IGraphicalEditorPage, GanttViewer> viewers = new HashMap<IGraphicalEditorPage, GanttViewer>();
    private PageBook viewerStack = null;
    private Composite defaultPage = null;
    private ISelectionProvider selectionProvider;
    private IActionBars actionBars;

    protected void init() {
        super.init();
        IWorkbenchPage page = this.getActivatePage();
        if (page != null) {
            page.addPartListener((IPartListener)this);
        }
    }

    protected void doCreateProPartControl(Composite parent) {
        VerifyUI20141031.getUsageDataCollector().increase("ShowGanttDialogCount");
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 700;
        layoutData.heightHint = 380;
        composite.setLayoutData((Object)layoutData);
        this.viewerStack = new PageBook(composite, 0);
        this.viewerStack.setLayoutData((Object)new GridData(1808));
        this.defaultPage = this.createDefaultPage((Composite)this.viewerStack);
        IWorkbenchPage page = this.getActivatePage();
        if (page != null) {
            this.partActivated((IWorkbenchPart)page.getActiveEditor());
        }
    }

    protected boolean postConfiguration(IWorkbenchPart workbenchPart, MPart part) {
        super.postConfiguration(workbenchPart, part);
        IWorkbenchPartSite site = workbenchPart.getSite();
        IGraphicalEditor editor = this.getContributedEditor();
        if (site instanceof IViewSite && editor != null) {
            IActionBars targetActionBars;
            IActionBars sourceActionBars = editor.getEditorSite().getActionBars();
            this.actionBars = targetActionBars = ((IViewSite)site).getActionBars();
            if (sourceActionBars == null || targetActionBars == null) {
                return false;
            }
            IServiceLocator serviceLocator = targetActionBars.getServiceLocator();
            if (serviceLocator == null) {
                return false;
            }
            IEclipseContext eclipseContext = (IEclipseContext)serviceLocator.getService(IEclipseContext.class);
            eclipseContext.set(ECommandService.class, (Object)((ECommandService)serviceLocator.getService(ECommandService.class)));
            eclipseContext.set(EHandlerService.class, (Object)((EHandlerService)serviceLocator.getService(EHandlerService.class)));
            this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.UNDO.getId());
            this.retargetAction(sourceActionBars, targetActionBars, ActionFactory.REDO.getId());
            return true;
        }
        return false;
    }

    private void retargetAction(IActionBars sourceActionBars, IActionBars targetActionBars, String actionId) {
        IAction handler = sourceActionBars.getGlobalActionHandler(actionId);
        if (handler != null) {
            targetActionBars.setGlobalActionHandler(actionId, handler);
        }
    }

    protected void dispose() {
        super.dispose();
        this.setSourceEditor(null);
        IWorkbenchPage page = this.getActivatePage();
        if (page != null) {
            page.removePartListener((IPartListener)this);
        }
        Object[] objectArray = this.pages.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object editor = objectArray[n2];
            this.partClosed((IWorkbenchPart)((IGraphicalEditor)editor));
            ++n2;
        }
    }

    private void showContentPage() {
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            GanttViewer viewer;
            Composite pageToShow = this.defaultPage;
            if (this.sourcePage != null && (viewer = this.ensureGanttViewer(this.sourcePage)) != null && !viewer.getControl().isDisposed()) {
                pageToShow = viewer.getControl();
            }
            this.viewerStack.showPage((Control)pageToShow);
        }
    }

    private Composite createDefaultPage(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout());
        page.setLayoutData((Object)new GridData(1808));
        Label label = new Label(page, 16448);
        label.setText(GanttMessages.GanttView_DefaultText);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return page;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.getSelectionProvider().setSelection(selection);
    }

    public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
        IMindMap map;
        GanttViewer ganttViewer;
        if (this.viewerStack == null || this.viewerStack.isDisposed()) {
            return;
        }
        IGraphicalEditorPage page = (IGraphicalEditorPage)viewer.getProperties().get("editorPage");
        if (page != null && (ganttViewer = this.getViewer(page)) != null && (map = (IMindMap)page.getAdapter(IMindMap.class)) != null) {
            ganttViewer.setInput(map.getCentralTopic());
        }
    }

    public void pageClosed(Object pageObject) {
        if (pageObject instanceof IGraphicalEditorPage) {
            IGraphicalEditorPage page = (IGraphicalEditorPage)pageObject;
            this.unregisterSourcePage(page);
            GanttViewer viewer = this.getViewer(page);
            this.unregisterViewer(page, viewer);
            this.disposeGanttViewer(viewer);
        }
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                GanttDialogPart.this.setSourcePage(page);
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        this.setSourceEditor((IGraphicalEditor)part);
        MPart partModel = (MPart)this.getAdapter(MPart.class);
        Object wp = partModel.getTransientData().get("e4Wrapper");
        if (wp instanceof E4PartWrapper) {
            this.postConfiguration((IWorkbenchPart)wp, partModel);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Collection<IGraphicalEditorPage> oldPages = this.pages.remove(part);
        if (part == this.sourceEditor) {
            this.setSourceEditor(null);
        }
        if (oldPages != null) {
            Object[] objectArray = oldPages.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.pageClosed(page);
                ++n2;
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new SelectionProvider();
        }
        return this.selectionProvider;
    }

    public IGraphicalEditor getContributedEditor() {
        return this.sourceEditor;
    }

    private void setSourceEditor(IGraphicalEditor sourceEditor) {
        ISelectionProvider selectionProvider;
        if (this.sourceEditor == sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            selectionProvider = this.sourceEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
        this.sourceEditor = sourceEditor;
        if (this.sourceEditor != null) {
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            this.setSourcePage(this.sourceEditor.getActivePageInstance());
            selectionProvider = sourceEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.getSelectionProvider().setSelection(selectionProvider.getSelection());
            }
        } else {
            this.setSourcePage(null);
        }
    }

    private void setSourcePage(IGraphicalEditorPage page) {
        if (page == this.sourcePage) {
            return;
        }
        this.sourcePage = page;
        if (this.isVerifyed()) {
            this.showContentPage();
        }
    }

    private void registerSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list == null) {
            list = new HashSet<IGraphicalEditorPage>();
            this.pages.put(editor, list);
        }
        list.add(page);
    }

    private void unregisterSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list != null) {
            list.remove(page);
            if (list.isEmpty()) {
                this.pages.remove(editor);
            }
        }
    }

    private GanttViewer ensureGanttViewer(IGraphicalEditorPage page) {
        IMindMap map;
        GanttViewer viewer = this.getViewer(this.sourcePage);
        if (viewer == null && (map = (IMindMap)this.sourcePage.getAdapter(IMindMap.class)) != null) {
            viewer = this.createGanttViewer((Composite)this.viewerStack, map.getCentralTopic(), page);
            this.registerSourcePage(page);
            this.registerViewer(page, viewer);
        }
        return viewer;
    }

    private void registerViewer(IGraphicalEditorPage page, GanttViewer viewer) {
        this.viewers.put(page, viewer);
        viewer.getSelectionSynchronizer().addPrimary(page.getSelectionProvider());
        page.getViewer().addInputChangedListener((IInputChangedListener)this);
    }

    private void unregisterViewer(IGraphicalEditorPage page, GanttViewer viewer) {
        if (page != null) {
            page.getViewer().removeInputChangedListener((IInputChangedListener)this);
        }
        if (viewer != null) {
            viewer.getSelectionSynchronizer().remove(page.getSelectionProvider());
        }
        this.viewers.remove(page);
    }

    private GanttViewer getViewer(IGraphicalEditorPage page) {
        return this.viewers.get(page);
    }

    private GanttViewer createGanttViewer(Composite parent, Object input, IGraphicalEditorPage sourcePage) {
        GanttViewer viewer = new GanttViewer();
        viewer.setCommandStack(sourcePage.getEditDomain().getCommandStack());
        viewer.createControl(parent);
        viewer.setInput(input);
        return viewer;
    }

    private void disposeGanttViewer(GanttViewer viewer) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().dispose();
        }
    }

    private IWorkbenchPage getActivatePage() {
        IWorkbenchWindow window = (IWorkbenchWindow)this.getAdapter(IWorkbenchWindow.class);
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    protected String getFeatureKey() {
        return "Gantt";
    }

    public void notifyValidity(IValidity validity) {
        super.notifyValidity(validity);
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (GanttDialogPart.this.isVerifyed()) {
                        GanttDialogPart.this.showContentPage();
                    }
                }
            });
        }
    }

    public GanttViewer getCurrentViewer() {
        return this.getViewer(this.sourcePage);
    }

    public void activateGlobalActionHandlers() {
        IGlobalActionHandlerService actionService;
        if (this.sourceEditor != null && (actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class)) != null) {
            actionService.addActionBars(this.actionBars);
        }
    }

    public void deactivateGlobalActionHanlders() {
        IGlobalActionHandlerService actionService;
        if (this.sourceEditor != null && (actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class)) != null) {
            actionService.removeActionBars(this.actionBars);
        }
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> selectionChangedListeners = null;
        private ISelection selection;

        private SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
            }
            this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection == null ? StructuredSelection.EMPTY : this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (this.selection == selection) {
                return;
            }
            this.selection = selection;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            Object[] objectArray = this.selectionChangedListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ISelectionChangedListener)o).selectionChanged(event);
                ++n2;
            }
        }
    }
}

