/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.vector.pdf;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.xmind.ui.exports.vector.graphics.GraphicsToGraphics2DAdaptor;
import org.xmind.ui.internal.exports.vector.pdf.Messages;
import org.xmind.ui.internal.exports.vector.pdf.PDFMapConstants;
import org.xmind.ui.internal.figures.SheetFigure;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.viewers.ICompositeProvider;

public class PDFMapExporter {
    private static final int DEFAULT_MARGIN = 15;
    private IGraphicalEditorPage page;
    private IMindMap mindmap;
    private String targetPath;
    private IDialogSettings settings;
    private ICompositeProvider compositeProvider;
    private IGraphicalViewer exportViewer;

    public PDFMapExporter(IGraphicalEditorPage page, IMindMap mindmap, String targetPath, IDialogSettings settings) {
        this.page = page;
        this.mindmap = mindmap;
        this.targetPath = targetPath;
        this.settings = settings;
    }

    public void export(IProgressMonitor monitor, final Display display) throws InvocationTargetException, InterruptedException, IOException {
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.PDFMapExporter_PrepareDocument);
        this.compositeProvider = new GhostShellProvider(display);
        final IOException[] error = new IOException[1];
        monitor.worked(20);
        monitor.subTask(Messages.PDFMapExporter_SettingDocumentProperties);
        display.syncExec(new Runnable(){

            public void run() {
                PDFMapExporter.this.exportViewer = (IGraphicalViewer)new MindMapExportViewer(PDFMapExporter.this.compositeProvider, (Object)PDFMapExporter.this.mindmap, PDFMapExporter.this.page.getViewer().getProperties());
                Properties properties = PDFMapExporter.this.exportViewer.getProperties();
                boolean plusVisible = PDFMapExporter.this.getBoolean(PDFMapExporter.this.settings, "plusVisible", true);
                boolean minusVisible = PDFMapExporter.this.getBoolean(PDFMapExporter.this.settings, "minusVisible", true);
                properties.set("plusVisible", plusVisible);
                properties.set("minusVisible", minusVisible);
                if ("linux".equals(Platform.getOS())) {
                    properties.set("renderTextAsPath", false);
                } else {
                    properties.set("renderTextAsPath", true);
                }
            }
        });
        monitor.worked(40);
        monitor.subTask(Messages.PDFMapExporter_FinishExport);
        display.syncExec(new Runnable(){

            public void run() {
                try {
                    try {
                        FileOutputStream out = new FileOutputStream(PDFMapExporter.this.targetPath);
                        Rectangle bounds = PDFMapExporter.this.getFigureBounds();
                        PDFGraphics2D pdfGenerator = new PDFGraphics2D((OutputStream)out, new Dimension(bounds.width, bounds.height));
                        String orientation = PDFMapExporter.this.settings.get("Orientation");
                        Dimension size = PDFMapConstants.getSize(PDFMapExporter.this.settings.get("PageSize"), orientation);
                        pdfGenerator.setPageSize(size);
                        pdfGenerator.setMargin(PDFMapConstants.getMargins(PDFMapConstants.PageMargins.Small.name(), orientation));
                        pdfGenerator.setProducer(PDFMapExporter.this.getProducer());
                        pdfGenerator.startExport();
                        GraphicsToGraphics2DAdaptor adaptor = new GraphicsToGraphics2DAdaptor((Graphics2D)pdfGenerator, bounds, display);
                        PDFMapExporter.this.setTranslate(adaptor);
                        Layer bgFigure = PDFMapExporter.this.exportViewer.getLayer(GEF.LAYER_BACKGROUND);
                        Layer contentFigure = PDFMapExporter.this.exportViewer.getLayer(GEF.LAYER_CONTENTS);
                        adaptor.fillRectangle(bounds.width, bounds.height, bgFigure.getBackgroundColor());
                        contentFigure.paint((Graphics)adaptor);
                        pdfGenerator.endExport();
                        ((OutputStream)out).close();
                        adaptor.dispose();
                    }
                    catch (IOException e) {
                        error[0] = e;
                        PDFMapExporter.this.cleanUpSources(display);
                    }
                }
                finally {
                    PDFMapExporter.this.cleanUpSources(display);
                }
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
        monitor.done();
    }

    private void cleanUpSources(Display display) {
        if (this.exportViewer != null) {
            if (this.exportViewer.getControl() != null) {
                display.syncExec(new Runnable(){

                    public void run() {
                        PDFMapExporter.this.exportViewer.getControl().dispose();
                    }
                });
            }
            this.exportViewer = null;
        }
        if (this.compositeProvider instanceof GhostShellProvider) {
            display.syncExec(new Runnable(){

                public void run() {
                    ((GhostShellProvider)PDFMapExporter.this.compositeProvider).dispose();
                }
            });
            this.compositeProvider = null;
        }
    }

    private Rectangle getFigureBounds() {
        Rectangle extent = this.getSheetFigure().getFreeformExtent();
        return new Rectangle(0, 0, extent.width + 30, extent.height + 30);
    }

    private void setTranslate(GraphicsToGraphics2DAdaptor graphicsAdaptor) {
        Rectangle extent = this.getSheetFigure().getFreeformExtent();
        int translateX = 15 - extent.x;
        int translateY = 15 - extent.y;
        graphicsAdaptor.translate(translateX, translateY);
    }

    private SheetFigure getSheetFigure() {
        return (SheetFigure)this.exportViewer.findGraphicalPart((Object)this.mindmap.getSheet()).getContentPane();
    }

    private String getProducer() {
        String creatorName = "XMind";
        String creatorVersion = System.getProperty("org.xmind.product.buildid");
        if (creatorVersion != null) {
            return String.valueOf(creatorName) + " " + creatorVersion;
        }
        return creatorName;
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }
}

