/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.seawind.internal.core.SPath;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.resources.ColorUtils;

public class MoveToDialog
extends TitleAreaDialog {
    private ResourceManager resources;
    private List<? extends SPath> sources;
    private TreeViewer treeViewer;
    private String path;

    public MoveToDialog(Shell parentShell, List<? extends SPath> sources) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.sources = sources;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SeawindMessages.MoveToDialog_Menu_MoveTo);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)newShell);
    }

    public void create() {
        super.create();
        this.setTitle(SeawindMessages.MoveToDialog_Title_Select);
        this.setTitleImage(null);
        this.setMessage(SeawindMessages.MoveToDialog_Message_Choose_Cloud_Folder);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite2 = new Composite(parent, 0);
        composite2.setBackground(parent.getBackground());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite2.setLayout((Layout)layout);
        this.createContent(composite2);
        this.createSeparator(composite2);
        return composite;
    }

    private void createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 0;
        layout.marginTop = 20;
        layout.marginBottom = 66;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createContentSection(composite);
        if (this.treeViewer != null) {
            this.treeViewer.expandAll();
        }
    }

    private void createSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createContentSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new CloudFolderTreeContentProvider(this.sources));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CloudFolderTreeLabelProvider((Control)composite));
        this.treeViewer.setInput((Object)SeawindUIPlugin.getSeawindLibrary().getSeawindFolderManager());
        GridData gridData2 = new GridData(1808);
        gridData2.widthHint = 479;
        gridData2.heightHint = 252;
        this.treeViewer.getControl().setLayoutData((Object)gridData2);
        this.treeViewer.getControl().setBackground(composite.getBackground());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof SeawindFolder) {
                    MoveToDialog.this.path = ((SeawindFolder)obj).getPath();
                }
            }
        });
        SeawindFolder rootFolder = SeawindUIPlugin.getSeawindLibrary().getSeawindFolderManager().getRootSeawindFolder();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)rootFolder));
    }

    public String getPath() {
        return this.path;
    }

    private static class CloudFolderTreeContentProvider
    implements ITreeContentProvider {
        private List<String> excludes = new ArrayList<String>();

        public CloudFolderTreeContentProvider(List<? extends SPath> sources) {
            if (sources != null) {
                for (SPath sPath : sources) {
                    if (!(sPath instanceof SeawindFolder)) continue;
                    this.excludes.add(sPath.getPath());
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SeawindFolderManager) {
                return new Object[]{((SeawindFolderManager)inputElement).getRootSeawindFolder()};
            }
            if (inputElement instanceof SeawindFolder && !this.excludes.contains(((SeawindFolder)inputElement).getPath())) {
                return ((SeawindFolder)inputElement).getFolders().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof SeawindFolder) {
                ArrayList<SeawindFolder> children = new ArrayList<SeawindFolder>();
                Set folders = ((SeawindFolder)parentElement).getFolders();
                for (SeawindFolder folder : folders) {
                    if (this.excludes.contains(folder.getPath())) continue;
                    children.add(folder);
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof SeawindFolder) {
                return ((SeawindFolder)element).getOwnedParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof SeawindFolder) {
                ArrayList<SeawindFolder> children = new ArrayList<SeawindFolder>();
                Set folders = ((SeawindFolder)element).getFolders();
                for (SeawindFolder folder : folders) {
                    if (this.excludes.contains(folder.getPath())) continue;
                    children.add(folder);
                }
                return children.size() != 0;
            }
            return false;
        }
    }

    private static class CloudFolderTreeLabelProvider
    extends LabelProvider {
        private ResourceManager resources;

        public CloudFolderTreeLabelProvider(Control control) {
            this.resources = new LocalResourceManager(JFaceResources.getResources(), control);
        }

        public String getText(Object element) {
            if (element instanceof SeawindFolder) {
                if (((SeawindFolder)element).getOwnedParent() == null) {
                    return "XMind Cloud";
                }
                return ((SeawindFolder)element).getTitle();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof SeawindFolder) {
                return (Image)this.resources.create((DeviceResourceDescriptor)SeawindUIPlugin.getImageDescriptor("dialog_folder.png"));
            }
            return super.getImage(element);
        }
    }
}

