/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import java.util.ArrayList;
import java.util.List;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.XmindSharePlugin;
import net.xmind.share.dialog.GeneralUploaderPage;
import net.xmind.share.dialog.IUploaderPage;
import net.xmind.share.dialog.IUploaderPageContainer;
import net.xmind.share.dialog.InfoField;
import net.xmind.share.dialog.PrivacyUploaderPage;
import net.xmind.share.dialog.ThumbnailUploaderPage;
import net.xmind.signin.IAccountInfo;
import net.xmind.signin.XMindNet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class UploaderDialog
extends TitleAreaDialog
implements IUploaderPageContainer {
    private static final String SECTION_NAME = "net.xmind.share.UploadDialog";
    private Info info;
    private TabFolder tabFolder;
    private List<IUploaderPage> pages;
    private List<String> pageIds;
    private GeneralUploaderPage generalPage;

    public UploaderDialog(Shell parentShell) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(112);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings ds = XmindSharePlugin.getDefault().getDialogSettings();
        IDialogSettings section = ds.getSection(SECTION_NAME);
        if (section == null) {
            section = ds.addNewSection(SECTION_NAME);
        }
        return section;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = Messages.UploaderDialog_Upload_text;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        Label informLable = new Label(parent, 16448);
        informLable.setText(Messages.UploaderDialog_containUnupload_text);
        informLable.setVisible(false);
        if (this.getInfo().getBoolean("Trimmed")) {
            informLable.setVisible(true);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UploaderDialog_windowTitle);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                super.shellActivated(e);
                UploaderDialog.this.checkUserInfoValidity();
            }
        });
    }

    private void checkUserInfoValidity() {
        IAccountInfo accountInfo;
        String token;
        String userID = this.info.getString("UserID");
        if (this.isInvalidToken(userID, token = this.info.getString("Token"), accountInfo = XMindNet.getAccountInfo())) {
            this.setReturnCode(1);
            this.close();
        }
    }

    private boolean isInvalidToken(String userID, String token, IAccountInfo currentInfo) {
        if (userID == null || token == null) {
            return true;
        }
        if (currentInfo == null) {
            return true;
        }
        return !userID.equals(currentInfo.getUser()) || !token.equals(currentInfo.getAuthToken());
    }

    private void ensurePages() {
        if (this.pages != null) {
            return;
        }
        this.pages = new ArrayList<IUploaderPage>();
        this.pageIds = new ArrayList<String>();
        this.addPages();
    }

    protected void addPage(String pageId, IUploaderPage page) {
        if (this.pages == null) {
            return;
        }
        this.pages.add(page);
        this.pageIds.add(pageId);
        page.setContainer(this);
    }

    protected void addPages() {
        this.generalPage = new GeneralUploaderPage();
        this.addPage("org.xmind.ui.uploader.general", this.generalPage);
        this.addPage("org.xmind.ui.uploader.privacy", new PrivacyUploaderPage());
        this.addPage("org.xmind.ui.uploader.thumbnail", new ThumbnailUploaderPage());
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(container, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.ensurePages();
        int i = 0;
        while (i < this.pages.size()) {
            IUploaderPage page = this.pages.get(i);
            page.createControl((Composite)this.tabFolder);
            Control control = page.getControl();
            Assert.isNotNull((Object)control);
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(page.getTitle());
            item.setToolTipText(page.getDescription());
            item.setImage(page.getImage());
            item.setControl(control);
            ++i;
        }
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UploaderDialog.this.setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setTitle(Messages.UploaderDialog_title);
        this.setMessage(Messages.UploaderDialog_message);
        if (((Boolean)this.getInfo().getProperty("multiSheets")).booleanValue()) {
            this.setMessage(Messages.UploaderDialog_uploadOneSheet_message);
        }
        this.setFocus();
        return composite;
    }

    private void setFocus() {
        String title = (String)this.getInfo().getProperty("Title");
        if (title == null || title.trim().equals("")) {
            this.setMessage(Messages.UploaderDialog_NullTitle_warning, 2);
            InfoField titleField = this.generalPage.getTitleField();
            titleField.getTextWidget().setEditable(true);
            titleField.setFocus();
        } else {
            IUploaderPage page = this.getActivePage();
            if (page != null) {
                page.setFocus();
            }
        }
    }

    private IUploaderPage getActivePage() {
        int index;
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && (index = this.tabFolder.getSelectionIndex()) >= 0) {
            return this.pages.get(index);
        }
        return null;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionId;
        IDialogSettings global = XmindSharePlugin.getDefault().getDialogSettings();
        IDialogSettings ds = global.getSection(sectionId = this.getClass().getName());
        if (ds == null) {
            ds = global.addNewSection(sectionId);
        }
        return ds;
    }

    public void updateMessage() {
        IUploaderPage page = this.getActivePage();
        if (page != null) {
            String errorMessage = page.getErrorMessage();
            if (errorMessage != null) {
                this.setErrorMessage(errorMessage);
            } else {
                this.setMessage(page.getMessage());
            }
        }
    }

    public void showPage(String pageId) {
        if (pageId == null || this.pages == null || this.pageIds == null) {
            return;
        }
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        int index = this.pageIds.indexOf(pageId);
        if (index < 0) {
            return;
        }
        this.tabFolder.setSelection(index);
    }

    protected void okPressed() {
        String title;
        InfoField titleField = this.generalPage.getTitleField();
        if (titleField.getTextWidget().getEditable() && (title = titleField.getText()) != null && !title.trim().equals("")) {
            this.getInfo().setProperty("Title", title);
        }
        if ((title = (String)this.getInfo().getProperty("Title")) == null || title.trim().equals("")) {
            this.setErrorMessage(Messages.UploaderDialog_NullTitle_error);
            this.showPage("org.xmind.ui.uploader.general");
            titleField.getTextWidget().setEditable(true);
            titleField.getTextWidget().setFocus();
            return;
        }
        this.getDialogSettings().put("Share/Privacy", this.getInfo().getString("Share/Privacy", "1"));
        this.getDialogSettings().put("Share/Downloadable", this.getInfo().getString("Share/Downloadable", "1"));
        super.okPressed();
    }
}

