/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.xmind.gef.ui.editor.IGraphicalEditor;

public class GraphicalEditorDropPageChangeHelper {
    private static final int PAGE_CHANGE_DELAY = 1000;
    private IGraphicalEditor editor;
    private CTabFolder tabFolder;
    private DropTarget dropTarget;
    private DropTargetListener handler;
    private CTabItem currentItem = null;
    private PageChangeTask currentTask = null;

    public GraphicalEditorDropPageChangeHelper(IGraphicalEditor editor, CTabFolder tabFolder, int style, Transfer[] acceptableTransfers) {
        this.editor = editor;
        this.tabFolder = tabFolder;
        this.createDropTarget(style, acceptableTransfers);
    }

    private void createDropTarget(int style, Transfer[] acceptableTransfers) {
        this.dropTarget = new DropTarget((Control)this.tabFolder, style);
        if (acceptableTransfers != null) {
            this.dropTarget.setTransfer(acceptableTransfers);
        }
        this.handler = this.createHandler();
        this.dropTarget.addDropListener(this.handler);
        this.hookTabFolder();
    }

    private void hookTabFolder() {
        this.tabFolder.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc;
                if (GraphicalEditorDropPageChangeHelper.this.currentItem != null && (gc = e.gc) != null) {
                    gc.setAlpha(48);
                    gc.setBackground(e.display.getSystemColor(26));
                    Rectangle r = GraphicalEditorDropPageChangeHelper.this.currentItem.getBounds();
                    gc.fillRectangle(r);
                }
            }
        });
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GraphicalEditorDropPageChangeHelper.this.dispose();
            }
        });
    }

    private DropTargetListener createHandler() {
        return new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                CTabItem oldItem = GraphicalEditorDropPageChangeHelper.this.currentItem;
                CTabItem newItem = GraphicalEditorDropPageChangeHelper.this.findItem(event.x, event.y);
                if (newItem != oldItem) {
                    GraphicalEditorDropPageChangeHelper.this.cancelUndoneTask();
                    if (newItem != GraphicalEditorDropPageChangeHelper.this.tabFolder.getSelection()) {
                        GraphicalEditorDropPageChangeHelper.this.currentItem = newItem;
                        if (GraphicalEditorDropPageChangeHelper.this.currentItem != null) {
                            GraphicalEditorDropPageChangeHelper.this.startNewTask();
                        }
                        GraphicalEditorDropPageChangeHelper.this.redrawTabFolder();
                    } else {
                        GraphicalEditorDropPageChangeHelper.this.currentItem = null;
                        if (oldItem != null) {
                            GraphicalEditorDropPageChangeHelper.this.redrawTabFolder();
                        }
                    }
                }
                event.detail = 1;
            }

            public void dragLeave(DropTargetEvent event) {
                GraphicalEditorDropPageChangeHelper.this.cancelUndoneTask();
                boolean needRedraw = GraphicalEditorDropPageChangeHelper.this.currentItem != null;
                GraphicalEditorDropPageChangeHelper.this.currentItem = null;
                if (needRedraw) {
                    GraphicalEditorDropPageChangeHelper.this.redrawTabFolder();
                }
            }
        };
    }

    private void startNewTask() {
        this.currentTask = new PageChangeTask();
        this.tabFolder.getDisplay().timerExec(1000, (Runnable)this.currentTask);
    }

    private void redrawTabFolder() {
        this.tabFolder.redraw();
    }

    private void cancelUndoneTask() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
    }

    protected void changePage() {
        if (this.currentItem == null) {
            return;
        }
        int pageIndex = this.tabFolder.indexOf(this.currentItem);
        this.editor.setActivePage(pageIndex);
        this.currentItem = null;
        this.redrawTabFolder();
    }

    private CTabItem findItem(int x, int y) {
        Point location = this.tabFolder.toControl(x, y);
        return this.tabFolder.getItem(location);
    }

    protected void dispose() {
        this.cancelUndoneTask();
        if (this.dropTarget != null) {
            if (this.handler != null && !this.dropTarget.isDisposed()) {
                this.dropTarget.removeDropListener(this.handler);
            }
            this.dropTarget.dispose();
        }
        this.dropTarget = null;
        this.handler = null;
        this.tabFolder = null;
        this.editor = null;
    }

    private class PageChangeTask
    implements Runnable {
        private boolean canceled = false;

        private PageChangeTask() {
        }

        @Override
        public void run() {
            if (this.canceled) {
                return;
            }
            GraphicalEditorDropPageChangeHelper.this.changePage();
            GraphicalEditorDropPageChangeHelper.this.currentTask = null;
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

