/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.biggerplate;

import java.io.File;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.ui.internal.biggerplate.BiggerplateUploader;
import org.xmind.ui.internal.biggerplate.Info;
import org.xmind.ui.internal.biggerplate.jobs.CancelableJob;
import org.xmind.ui.internal.biggerplate.jobs.IJobClosedListener;

public class BiggerplateAPI {
    private static final String UPLOAD_URL = "https://api.biggerplate.com/maps";
    private static final String USER_INFO_URL = "https://api.biggerplate.com/users/me";
    private static final String DATA_RESULT_MAP_URL_KEY = "url";
    private static final String DATA_USERNAME_KEY = "UserName";

    public static void submitMap(final Info info, final CancelableJob job) {
        IDataStore data;
        final XMindNetRequest request = new XMindNetRequest();
        request.multipart();
        request.uri(UPLOAD_URL);
        request.addHeader("Authorization", info.getString("accessToken"));
        request.addParameter("title", (Object)info.getString("Title"));
        String description = info.getString("Description");
        if (description == null || description.equals("")) {
            description = info.getString("Title");
        }
        request.addParameter("description", (Object)description);
        BiggerplateUploader.validateUploadFile(((File)info.getProperty("File")).getAbsolutePath());
        request.addParameter("map", (Object)((File)info.getProperty("File")));
        job.addJobClosedListener(new IJobClosedListener(){

            public void jobClosed() {
                if (request != null && request.isRunning()) {
                    info.setBoolean("canceled", true);
                    request.abort();
                }
                job.removeJobClosedListener(this);
            }
        });
        request.post();
        if (request.getError() != null) {
            request.getError().printStackTrace();
        }
        if ((data = request.getData()) != null) {
            info.setProperty("resultUrl", data.getString(DATA_RESULT_MAP_URL_KEY));
        }
    }

    public static String getUsername(Info info) {
        IDataStore data;
        XMindNetRequest request = new XMindNetRequest();
        request.uri(USER_INFO_URL);
        request.addHeader("Authorization", info.getString("accessToken"));
        request.get();
        if (request.getError() != null) {
            request.getError().printStackTrace();
        }
        if ((data = request.getData()) != null) {
            return data.getString(DATA_USERNAME_KEY);
        }
        return "";
    }
}

