/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import java.util.Comparator;
import org.xmind.core.sharing.ISharedLibrary;
import org.xmind.core.sharing.ISharedMap;

public abstract class AbstractSharedMap
implements ISharedMap {
    public static final Comparator<ISharedMap> MAP_COMPARATOR = new Comparator<ISharedMap>(){

        @Override
        public int compare(ISharedMap o1, ISharedMap o2) {
            int d = o1.getResourceName().compareTo(o2.getResourceName());
            if (d == 0) {
                d = o1.getID().compareTo(o2.getID());
            }
            return d;
        }
    };
    public static final Comparator<ISharedMap> MAP_COMPARATOR_BY_MODIFIED_TIME = new Comparator<ISharedMap>(){

        @Override
        public int compare(ISharedMap o1, ISharedMap o2) {
            Long modifiedTime1 = o1.getResourceModifiedTime();
            Long modifiedTime2 = o2.getResourceModifiedTime();
            int d = modifiedTime2.compareTo(modifiedTime1);
            if (d == 0 && (d = o1.getResourceName().compareTo(o2.getResourceName())) == 0) {
                d = o1.getID().compareTo(o2.getID());
            }
            return d;
        }
    };
    private ISharedLibrary library;
    private String id;
    private String name;
    private byte[] thumbnailData;
    private boolean missing;
    private long modifiedTime = 0L;

    public AbstractSharedMap(ISharedLibrary library, String id) {
        this(library, id, null, null);
    }

    public AbstractSharedMap(ISharedLibrary library, String id, String name, byte[] thumbnailData) {
        this.library = library;
        this.id = id;
        this.name = name;
        this.thumbnailData = thumbnailData;
        this.missing = false;
    }

    public ISharedLibrary getSharedLibrary() {
        return this.library;
    }

    public String getID() {
        return this.id;
    }

    public String getResourceName() {
        return this.name == null ? "" : this.name;
    }

    public byte[] getThumbnailData() {
        return this.thumbnailData;
    }

    public void setResourceName(String name) {
        this.name = name;
    }

    public void setThumbnailData(byte[] thumbnailData) {
        this.thumbnailData = thumbnailData;
    }

    public long getResourceModifiedTime() {
        return this.modifiedTime;
    }

    public void setResourceModifiedTime(long time) {
        this.modifiedTime = time;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public int hashCode() {
        return (String.valueOf(this.getClass().getName()) + this.getID()).hashCode();
    }
}

