/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.IAdaptable;
import org.xmind.core.IBoundary;
import org.xmind.core.IRelationship;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSpliter {
    public static final SelectionSpliter instance = new SelectionSpliter();

    private SelectionSpliter() {
    }

    public boolean canSplit(IStructuredSelection ss) {
        if (ss == null || ss.isEmpty()) {
            return false;
        }
        Object firstElement = ss.getFirstElement();
        boolean isTopic = firstElement instanceof ITopic;
        if (!(isTopic || firstElement instanceof IBoundary || firstElement instanceof IRelationship)) {
            return false;
        }
        Class<?> clazz = firstElement.getClass();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != firstElement) {
                if (!clazz.equals(o.getClass())) {
                    return false;
                }
                if (isTopic) {
                    String type1 = ((ITopic)firstElement).getType();
                    String type2 = ((ITopic)o).getType();
                    if (("summary".equals(type1) || "summary".equals(type2)) && !type1.equals(type2)) {
                        return false;
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    public List<IAdaptable[]> split(IStructuredSelection ss) {
        if (this.canSplit(ss)) {
            Object o = ss.getFirstElement();
            if (o instanceof IBoundary) {
                return this.splitBoundaries(ss);
            }
            if (o instanceof IRelationship) {
                return this.splitRelationships(ss);
            }
            if (o instanceof ITopic) {
                ITopic t = (ITopic)o;
                if ("summary".equals(t.getType())) {
                    return this.splitSummaries(ss);
                }
                return this.splitTopics(ss);
            }
        }
        return Collections.emptyList();
    }

    private List<IAdaptable[]> splitBoundaries(IStructuredSelection ss) {
        ArrayList<IAdaptable[]> list = new ArrayList<IAdaptable[]>();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            IAdaptable[] array = new IAdaptable[]{(IAdaptable)o};
            list.add(array);
            ++n2;
        }
        return list;
    }

    private List<IAdaptable[]> splitSummaries(IStructuredSelection ss) {
        ArrayList<IAdaptable[]> list = new ArrayList<IAdaptable[]>();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ITopic) {
                ISummary s = MindMapUtils.findSummaryBySummaryTopic((ITopic)((ITopic)o));
                IAdaptable[] array = new IAdaptable[]{s};
                list.add(array);
            }
            ++n2;
        }
        return list;
    }

    private List<IAdaptable[]> splitRelationships(IStructuredSelection ss) {
        Object[] objs = ss.toArray();
        IAdaptable[] rs = new IAdaptable[objs.length];
        int i = 0;
        while (i < rs.length) {
            rs[i] = (IAdaptable)objs[i];
            ++i;
        }
        ArrayList<IAdaptable[]> list = new ArrayList<IAdaptable[]>();
        list.add(rs);
        return list;
    }

    private List<IAdaptable[]> splitTopics(IStructuredSelection ss) {
        List<ITopic> selections = this.getTopicSelections(ss);
        if (selections.size() > 0) {
            ArrayList<PresentationTopicHeap> topicHeapList = new ArrayList<PresentationTopicHeap>();
            for (ITopic selection : selections) {
                if (topicHeapList.size() == 0) {
                    topicHeapList.add(this.createHeap(selection));
                    continue;
                }
                this.addSelection(topicHeapList, selection);
            }
            ArrayList<IAdaptable[]> ts = new ArrayList<IAdaptable[]>();
            for (PresentationTopicHeap h : topicHeapList) {
                ts.add((IAdaptable[])h.getTopicHeap());
            }
            return ts;
        }
        return Collections.emptyList();
    }

    public List<ITopic> getTopicSelections(IStructuredSelection ss) {
        ArrayList<ITopic> selections = new ArrayList<ITopic>();
        for (Object o : ss) {
            if (!(o instanceof ITopic)) continue;
            selections.add((ITopic)o);
        }
        return selections;
    }

    private void addSelection(List<PresentationTopicHeap> topicHeapList, ITopic selection) {
        ArrayList<PresentationTopicHeap> temp = new ArrayList<PresentationTopicHeap>(topicHeapList);
        for (PresentationTopicHeap heap : temp) {
            List selectionParentList;
            int selectionLevel;
            ITopic head = heap.getParent();
            List headParentList = head.getPath().toTopicList();
            int headLevel = headParentList.indexOf(head);
            if (headLevel < (selectionLevel = (selectionParentList = selection.getPath().toTopicList()).indexOf(selection)) && selectionParentList.contains(head)) {
                heap.addTopic(selection);
                return;
            }
            if (headLevel > selectionLevel && headParentList.contains(selection)) {
                heap.setParent(selection);
                this.mergeHeap(topicHeapList, heap);
                return;
            }
            if (heap != temp.get(temp.size() - 1)) continue;
            topicHeapList.add(this.createHeap(selection));
            return;
        }
    }

    private PresentationTopicHeap createHeap(ITopic t) {
        PresentationTopicHeap heap = new PresentationTopicHeap();
        heap.setParent(t);
        return heap;
    }

    private void mergeHeap(List<PresentationTopicHeap> sources, PresentationTopicHeap target) {
        ArrayList<PresentationTopicHeap> temp = new ArrayList<PresentationTopicHeap>(sources);
        for (PresentationTopicHeap source : temp) {
            if (source == target) continue;
            ITopic targetHead = target.getParent();
            ITopic sourceHead = source.getParent();
            if (!sourceHead.getPath().toTopicList().contains(targetHead)) continue;
            target.addTopic(source.getTopicHeap());
            sources.remove(source);
        }
    }

    private class PresentationTopicHeap {
        private ITopic parent;
        private List<ITopic> topics = new ArrayList<ITopic>();

        public void setParent(ITopic parent) {
            this.parent = parent;
            if (this.topics.contains(parent)) {
                this.topics.remove(parent);
                this.topics.add(0, parent);
            } else {
                this.topics.add(0, parent);
            }
        }

        public ITopic getParent() {
            return this.parent;
        }

        public void addTopic(ITopic topic) {
            if (!this.topics.contains(topic)) {
                this.topics.add(topic);
            }
        }

        public void addTopic(ITopic[] topics) {
            ITopic[] iTopicArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                this.addTopic(topic);
                ++n2;
            }
        }

        public ITopic[] getTopicHeap() {
            return this.topics.toArray(new ITopic[this.topics.size()]);
        }
    }
}

