/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.ui.internal.presentation.HideCursorService;
import org.xmind.ui.internal.presentation.NavigationHistoryService;
import org.xmind.ui.internal.presentation.PresentationMenuService;
import org.xmind.ui.internal.tools.MindMapSelectTool;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IHighlightService;
import org.xmind.ui.mindmap.IImagePart;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.SWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationSelectTool
extends MindMapSelectTool
implements IZoomListener {
    protected boolean handleKeyDown(KeyEvent ke) {
        int keyCode = ke.keyCode;
        int stateMask = ke.getState();
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)32)) {
            this.navNext();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)8)) {
            this.navPrev();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)13)) {
            this.navSibling();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)9)) {
            this.navChild();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)0x1000001)) {
            this.navPrev();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)0, (int)0x1000002)) {
            this.navNext();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)SWT.MOD1, (int)61)) {
            this.zoomIn();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)SWT.MOD1, (int)45)) {
            this.zoomOut();
            return true;
        }
        if (SWTUtils.matchKey((int)stateMask, (int)keyCode, (int)SWT.MOD1, (int)48)) {
            this.actualSize();
            return true;
        }
        return super.handleKeyDown(ke);
    }

    private void zoomIn() {
        this.getDomain().handleRequest(new Request("zoom_in").setViewer((IViewer)this.getTargetViewer()));
    }

    private void zoomOut() {
        this.getDomain().handleRequest(new Request("zoom_out").setViewer((IViewer)this.getTargetViewer()));
    }

    private void actualSize() {
        this.getDomain().handleRequest(new Request("zoom").setViewer((IViewer)this.getTargetViewer()).setParameter("zoomScale", (Object)2.3));
    }

    private void navPrev() {
        NavigationHistoryService service = (NavigationHistoryService)this.getTargetViewer().getService(NavigationHistoryService.class);
        if (service != null && service.prev()) {
            return;
        }
        this.navTo("navigate_previous");
    }

    private void navNext() {
        NavigationHistoryService service = (NavigationHistoryService)this.getTargetViewer().getService(NavigationHistoryService.class);
        if (service != null && service.next()) {
            return;
        }
        this.navTo("navigate_next");
    }

    private void navSibling() {
        this.navTo("navigate_sibling");
    }

    private void navChild() {
        this.navTo("navigate_child");
    }

    private void navTo(String navType) {
        Request request = this.createTargetedRequest(navType, (IViewer)this.getTargetViewer(), false);
        this.handleNavRequest(request, false);
    }

    protected void select(List<? extends IPart> toSelect, IPart toFocus) {
        if (toSelect.isEmpty()) {
            IHighlightService service = (IHighlightService)this.getTargetViewer().getService(IHighlightService.class);
            if (service != null) {
                service.setHighlightArea(null);
            }
            return;
        }
        super.select(toSelect, toFocus);
    }

    protected void setPreSelected(IPart target) {
        if (this.isCursorHidden()) {
            return;
        }
        if (target instanceof IImagePart || target instanceof IMarkerPart) {
            target = target.getParent();
        }
        super.setPreSelected(target);
    }

    private boolean isCursorHidden() {
        HideCursorService service = (HideCursorService)this.getTargetViewer().getService(HideCursorService.class);
        return service != null && service.isCursorHidden();
    }

    protected boolean handleMouseMove(MouseEvent me) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && menuService.handleMouseMove(me)) {
            return true;
        }
        return super.handleMouseMove(me);
    }

    public boolean handleMouseDown(MouseEvent me) {
        PresentationMenuService menuService;
        boolean left = me.leftOrRight;
        if (left && (menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class)) != null && menuService.handleMouseDown(me)) {
            return true;
        }
        return super.handleMouseDown(me);
    }

    public boolean handleMouseUp(MouseEvent me) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && menuService.handleMouseUp(me)) {
            return true;
        }
        return super.handleMouseUp(me);
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && menuService.handleMouseDrag((MouseEvent)me)) {
            return true;
        }
        return super.handleMouseDrag(me);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && menuService.handleMouseDoubleClick(me)) {
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    public IFigure getToolTip(IPart source, Point position) {
        IFigure tooltip;
        position = this.getTargetViewer().getZoomManager().getScaled(position);
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && (tooltip = menuService.getToolTip(position)) != null) {
            return tooltip;
        }
        return super.getToolTip(source, position);
    }

    public Cursor getCurrentCursor(Point pos, IPart host) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null && menuService.getCurrentButton(pos) != null) {
            return Cursors.HAND;
        }
        return super.getCurrentCursor(pos, host);
    }

    public void setTargetViewer(IViewer viewer) {
        if (this.getTargetViewer() != null) {
            this.getTargetViewer().getZoomManager().removeZoomListener((IZoomListener)this);
        }
        super.setTargetViewer(viewer);
        if (this.getTargetViewer() != null) {
            this.getTargetViewer().getZoomManager().addZoomListener((IZoomListener)this);
            PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
            if (menuService != null) {
                menuService.scaleChanged((ZoomObject)this.getTargetViewer().getZoomManager(), 0.0, this.getTargetViewer().getZoomManager().getScale());
            }
            this.addAction(viewer, (IAction)new NavSiblingAction());
            this.addAction(viewer, (IAction)new NavChildAction());
        }
    }

    private void addAction(IViewer viewer, IAction action) {
        IActionRegistry actionReg = (IActionRegistry)viewer.getProperties().get("actions");
        if (actionReg != null) {
            actionReg.addAction(action);
        }
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        PresentationMenuService menuService = (PresentationMenuService)this.getTargetViewer().getService(PresentationMenuService.class);
        if (menuService != null) {
            menuService.scaleChanged(source, oldValue, newValue);
        }
    }

    protected void sendFoldedRequest(IBranchPart branch) {
        this.changeCachedFoldedState(branch, !branch.isFolded());
    }

    private void changeCachedFoldedState(IBranchPart branch, boolean newFolded) {
        MindMapUtils.setCache((IPart)branch, (String)"org.xmind.ui.cache.folded", (Object)newFolded);
        branch.treeUpdate(false);
    }

    protected void expand(List<IBranchPart> branches) {
        for (IBranchPart branch : branches) {
            this.changeCachedFoldedState(branch, false);
        }
    }

    private class NavChildAction
    extends Action {
        public NavChildAction() {
            this.setId("org.xmind.ui.presentation.action.navChild");
        }

        public void run() {
            PresentationSelectTool.this.navChild();
        }
    }

    private class NavSiblingAction
    extends Action {
        public NavSiblingAction() {
            this.setId("org.xmind.ui.presentation.action.navSibling");
        }

        public void run() {
            PresentationSelectTool.this.navSibling();
        }
    }
}

