/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmind.core.CoreException;
import org.xmind.core.IManifest;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.plain.Style;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.CloneHandler;
import org.xmind.core.util.ObjectRegistry;

public class StyleSheet
implements IStyleSheet,
ICoreEventSource {
    private final Map<String, Set<IStyle>> styleGroups;
    private final ObjectRegistry objectRegistry;
    private final ICoreEventSupport eventSupport;
    private final IManifest manifest;
    private IStyleSheet parentSheet;

    public StyleSheet(ObjectRegistry objectRegistry, ICoreEventSupport eventSupport, IManifest manifest) {
        this.objectRegistry = objectRegistry == null ? new ObjectRegistry() : objectRegistry;
        this.eventSupport = eventSupport == null ? new CoreEventSupport() : eventSupport;
        this.manifest = manifest;
        this.styleGroups = new HashMap<String, Set<IStyle>>();
        this.parentSheet = null;
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.eventSupport;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.eventSupport.registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSupport.class.equals(adapter)) {
            return adapter.cast(this.eventSupport);
        }
        if (IManifest.class.equals(adapter)) {
            return adapter.cast(this.manifest);
        }
        return null;
    }

    public IStyle findStyle(String styleId) {
        IStyle style = this.objectRegistry.get(styleId, IStyle.class);
        if (style != null) {
            return style;
        }
        if (this.parentSheet != null) {
            return this.parentSheet.findStyle(styleId);
        }
        return null;
    }

    public Set<IStyle> getAllStyles() {
        if (this.styleGroups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IStyle> allStyles = new HashSet<IStyle>();
        for (String groupName : this.styleGroups.keySet()) {
            allStyles.addAll((Collection<IStyle>)this.styleGroups.get(groupName));
        }
        return allStyles;
    }

    public Set<IStyle> getStyles(String groupName) {
        Set<IStyle> styles = this.styleGroups.get(groupName);
        if (styles != null) {
            return styles;
        }
        return Collections.emptySet();
    }

    public void addStyle(IStyle style, String groupName) {
        if (style == null || !(style instanceof Style) || style.getOwnedStyleSheet() != this || groupName == null) {
            throw new IllegalArgumentException();
        }
        Style s = (Style)style;
        Set<IStyle> styles = this.styleGroups.get(groupName);
        if (styles == null) {
            styles = new HashSet<IStyle>();
            this.styleGroups.put(groupName, styles);
        }
        if (!styles.add(s)) {
            return;
        }
        s.setGroupName(groupName);
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "styleAdd", (Object)style);
    }

    public String findOwnedGroup(IStyle style) {
        if (style == null || !(style instanceof Style) || style.getOwnedStyleSheet() != this) {
            return null;
        }
        return ((Style)style).getGroupName();
    }

    public void removeStyle(IStyle style) {
        if (style == null || !(style instanceof Style) || style.getOwnedStyleSheet() != this) {
            throw new IllegalArgumentException();
        }
        Style s = (Style)style;
        String groupName = s.getGroupName();
        if (groupName == null) {
            return;
        }
        Set<IStyle> styles = this.styleGroups.get(groupName);
        if (styles == null || styles.isEmpty()) {
            return;
        }
        if (!styles.remove(s)) {
            return;
        }
        s.setGroupName(null);
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "styleRemove", (Object)style);
    }

    public IStyleSheet getParentSheet() {
        return this.parentSheet;
    }

    public void setParentSheet(IStyleSheet parent) {
        this.parentSheet = parent;
    }

    public IStyle createStyle(String type) {
        return new Style(this, type, this.objectRegistry.createUniqueId());
    }

    public boolean isEmpty() {
        if (this.styleGroups.isEmpty()) {
            return true;
        }
        for (String groupName : this.styleGroups.keySet()) {
            if (this.styleGroups.get(groupName).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public IStyle importStyle(IStyle style) {
        try {
            return (IStyle)new CloneHandler().withStyleSheets(style.getOwnedStyleSheet(), (IStyleSheet)this).cloneObject((Object)style);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save(OutputStream out) throws IOException, CoreException {
        throw new UnsupportedOperationException();
    }
}

