/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.RevisionManager;
import org.xmind.core.plain.Workbook;

public class RevisionRepository
implements IRevisionRepository {
    private final Workbook ownerWorkbook;
    private final Map<String, IRevisionManager> managers;

    public RevisionRepository(Workbook ownerWorkbook) {
        this.ownerWorkbook = ownerWorkbook;
        this.managers = new HashMap<String, IRevisionManager>();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return false;
    }

    public IRevisionManager getRevisionManager(String resourceId, String contentType) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id is null");
        }
        IRevisionManager manager = this.managers.get(resourceId);
        if (manager == null) {
            manager = new RevisionManager(this.ownerWorkbook, resourceId, contentType);
            this.managers.put(resourceId, manager);
            ((RevisionManager)manager).onParented();
        }
        return manager;
    }

    public IRevisionManager getRegisteredRevisionManager(String resourceId) {
        return this.managers.get(resourceId);
    }

    public void setRevisionManager(String resourceId, IRevisionManager manager) {
        if (manager != null && manager.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        IRevisionManager oldManager = manager == null ? this.managers.remove(resourceId) : this.managers.put(resourceId, manager);
        if (oldManager != null && oldManager instanceof RevisionManager) {
            ((RevisionManager)oldManager).onOrphan();
        }
        if (manager != null && manager instanceof RevisionManager) {
            ((RevisionManager)manager).onParented();
        }
    }

    public Set<String> getRegisteredResourceIds() {
        return Collections.unmodifiableSet(this.managers.keySet());
    }
}

