/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmind.core.IComment;
import org.xmind.core.ICommentManager;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.plain.Comment;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.IObjectRegistryListener;

public class CommentManager
implements ICommentManager {
    private final Workbook ownerWorkbook;
    private final Map<String, Set<IComment>> comments;
    private final Set<IComment> allComments;

    public CommentManager(Workbook ownerWorkbook) {
        this.ownerWorkbook = ownerWorkbook;
        this.comments = new HashMap<String, Set<IComment>>();
        this.allComments = new HashSet<IComment>();
        ownerWorkbook.getObjectRegistry().addObjectRegistryListener(new IObjectRegistryListener(){

            @Override
            public void objectUnregistered(String objectId, IIdentifiable object) {
                CommentManager.this.removeComments(objectId, object, (Set)CommentManager.this.comments.get(objectId));
            }

            @Override
            public void objectRegistered(String objectId, IIdentifiable object) {
                CommentManager.this.addComments(objectId, object, (Set)CommentManager.this.comments.get(objectId));
            }
        });
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return false;
    }

    public IComment createComment(String author, long time, String objectId) {
        return new Comment(this.ownerWorkbook, author, time, objectId);
    }

    public void addComment(IComment comment) {
        if (comment == null || comment.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        String objectId = comment.getObjectId();
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Set<IComment> commentSet = this.comments.get(objectId);
        if (commentSet == null) {
            commentSet = new HashSet<IComment>();
            this.comments.put(objectId, commentSet);
        }
        commentSet.add(comment);
        Object obj = this.ownerWorkbook.getElementById(comment.getObjectId());
        if (obj == null || Workbook.isOrphanWorkbookComponent(obj)) {
            return;
        }
        if (this.allComments.add(comment) && comment instanceof Comment) {
            ((Comment)comment).onParented();
        }
        if (obj instanceof ICoreEventSource) {
            this.ownerWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentAdd", (Object)comment);
        }
    }

    public void removeComment(IComment comment) {
        Object obj;
        if (comment == null || comment.getOwnedWorkbook() != this.ownerWorkbook) {
            throw new IllegalArgumentException();
        }
        String objectId = comment.getObjectId();
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Set<IComment> commentSet = this.comments.get(objectId);
        if (commentSet != null) {
            commentSet.remove(comment);
        }
        if (this.allComments.remove(comment) && comment instanceof Comment) {
            ((Comment)comment).onOrphan();
        }
        if ((obj = this.ownerWorkbook.getElementById(objectId)) != null && !Workbook.isOrphanWorkbookComponent(obj) && obj instanceof ICoreEventSource) {
            this.ownerWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentRemove", (Object)comment);
        }
    }

    public Set<IComment> getComments(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Object obj = this.ownerWorkbook.getElementById(objectId);
        if (obj == null || Workbook.isOrphanWorkbookComponent(obj)) {
            return Collections.emptySet();
        }
        Set<IComment> commentSet = this.comments.get(objectId);
        if (commentSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(commentSet);
    }

    public boolean hasComments(String objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        Object obj = this.ownerWorkbook.getElementById(objectId);
        if (obj == null || Workbook.isOrphanWorkbookComponent(obj)) {
            return false;
        }
        Set<IComment> commentSet = this.comments.get(objectId);
        return commentSet != null && !commentSet.isEmpty();
    }

    public Set<IComment> getAllComments() {
        return Collections.unmodifiableSet(this.allComments);
    }

    public boolean isEmpty() {
        return this.allComments.isEmpty();
    }

    private void addComments(String objectId, Object obj, Set<IComment> commentSet) {
        if (commentSet == null || commentSet.isEmpty()) {
            return;
        }
        for (IComment comment : commentSet) {
            if (!this.allComments.add(comment)) continue;
            if (comment instanceof Comment) {
                ((Comment)comment).onParented();
            }
            if (!(obj instanceof ICoreEventSource)) continue;
            this.ownerWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentAdd", (Object)comment);
        }
    }

    private void removeComments(String objectId, Object obj, Set<IComment> commentSet) {
        if (commentSet == null || commentSet.isEmpty()) {
            return;
        }
        for (IComment comment : commentSet) {
            if (!this.allComments.remove(comment)) continue;
            if (comment instanceof Comment) {
                ((Comment)comment).onOrphan();
            }
            if (!(obj instanceof ICoreEventSource)) continue;
            this.ownerWorkbook.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)obj, "commentRemove", (Object)comment);
        }
    }
}

