/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodingUtils {
    private static final Map<String, String> ENTITIES = new HashMap<String, String>(5);
    private static final Pattern ESCAPER;

    static {
        ENTITIES.put("lt", "<");
        ENTITIES.put("gt", ">");
        ENTITIES.put("amp", "&");
        ENTITIES.put("apos", "'");
        ENTITIES.put("quot", "\"");
        ESCAPER = Pattern.compile("&([^;]+);");
    }

    private EncodingUtils() {
    }

    public static String unescape(String text) {
        StringBuffer buffer = new StringBuffer(text.length());
        Matcher matcher = ESCAPER.matcher(text);
        while (matcher.find()) {
            String unescaped;
            String entity = matcher.group(1);
            if (entity.length() > 1 && entity.charAt(0) == '#') {
                int charCode = entity.length() > 2 && entity.charAt(1) == 'x' ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1), 10);
                unescaped = Character.toString((char)charCode);
            } else {
                unescaped = ENTITIES.get(entity);
                if (unescaped == null) {
                    unescaped = "&" + entity + ";";
                }
            }
            matcher.appendReplacement(buffer, unescaped);
        }
        matcher.appendTail(buffer);
        return buffer.toString().replaceAll("\\s+", " ");
    }
}

