/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.tabfolder.MTabBar;
import org.xmind.ui.tabfolder.MTabBarItem;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.util.IStyleProvider;
import org.xmind.ui.util.StyleProvider;

public class MTabFolder
extends Composite {
    public static final String TAB_BAR = "tabBar";
    public static final String BODY = "body";
    private MTabBar tabBar;
    private Composite body;
    private MTabItem tooltipItem;
    private IStyleProvider styleProvider = new StyleProvider();
    private boolean usingDefaultStyles = true;
    private Listener itemEventHandler = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    MTabFolder.this.handleItemSelection(event);
                }
            }
        }
    };
    private Listener mouseMoveEventHandler = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 5: {
                    MTabFolder.this.handleItemMouseEntered(new Point(event.x, event.y));
                }
            }
        }
    };

    public MTabFolder(Composite parent) {
        this(parent, 0);
    }

    public MTabFolder(Composite parent, int tabBarStyle) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = false;
        super.setLayout((Layout)layout);
        this.tabBar = new MTabBar(this, tabBarStyle);
        this.tabBar.setLayoutData(new GridData(4, 4, true, false));
        this.tabBar.addListener(13, this.itemEventHandler);
        this.tabBar.addListener(5, this.mouseMoveEventHandler);
        this.initialItemTooltip();
        this.tabBar.setStyleProvider(this.getStyleProvider());
        this.body = new Composite((Composite)this, 0);
        StackLayout stackLayout = new StackLayout();
        stackLayout.marginWidth = 0;
        stackLayout.marginHeight = 0;
        this.body.setLayout((Layout)stackLayout);
        this.body.setLayoutData((Object)new GridData(4, 4, true, true));
        this.updateTabFolder();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    protected MTabBar getTabBar() {
        return this.tabBar;
    }

    public Composite getBody() {
        return this.body;
    }

    public MTabItem[] getItems() {
        this.checkWidget();
        MTabBarItem[] barItems = this.tabBar.getItems();
        MTabItem[] items = new MTabItem[barItems.length];
        System.arraycopy(barItems, 0, items, 0, barItems.length);
        return items;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.tabBar.getItemCount();
    }

    public MTabItem getItem(int index) {
        this.checkWidget();
        return (MTabItem)this.tabBar.getItem(index);
    }

    public MTabItem getItem(Point pt) {
        this.checkWidget();
        return (MTabItem)this.tabBar.getItem(pt);
    }

    protected void updateTabFolder() {
        IStyleProvider styles = this.getStyleProvider();
        Color background = styles.getColor((Object)this, TAB_BAR);
        if (background == null) {
            this.tabBar.setBackground(this.getDisplay().getSystemColor(37));
        } else {
            this.tabBar.setBackground(background);
        }
        Color bodyBackground = styles.getColor((Object)this, BODY);
        if (bodyBackground == null) {
            this.body.setBackground(this.getDisplay().getSystemColor(37));
        } else {
            this.body.setBackground(bodyBackground);
        }
        int tabBarPosition = styles.getPosition((Object)this, TAB_BAR, 128);
        GridLayout layout = (GridLayout)this.getLayout();
        GridData tabBarLayoutData = (GridData)this.tabBar.getLayoutData();
        if ((tabBarPosition & 0x480) != 0) {
            layout.numColumns = 1;
            tabBarLayoutData.grabExcessHorizontalSpace = true;
            tabBarLayoutData.grabExcessVerticalSpace = false;
        } else {
            layout.numColumns = 2;
            tabBarLayoutData.grabExcessHorizontalSpace = false;
            tabBarLayoutData.grabExcessVerticalSpace = true;
        }
        if ((tabBarPosition & 0x4080) != 0) {
            this.tabBar.moveAbove((Control)this.body);
        } else {
            this.tabBar.moveBelow((Control)this.body);
        }
        this.tabBar.setVertical((tabBarPosition & 0x480) == 0);
        this.tabBar.updateTabBar();
        this.layout(true, true);
        this.tabBar.redraw();
        this.body.redraw();
    }

    public MTabItem getSelection() {
        this.checkWidget();
        return (MTabItem)this.tabBar.getSelection();
    }

    public void setSelection(MTabItem item) {
        this.checkWidget();
        MTabItem selectedItem = this.getSelection();
        if (item == selectedItem || item != null && (item.isSeparator() || item.isPushButton())) {
            return;
        }
        this.tabBar.setSelection(item);
        if (item != null) {
            this.showItemControl(item);
        }
    }

    private void handleItemSelection(Event event) {
        MTabItem item = (MTabItem)event.item;
        if (!item.isSeparator() && !item.isPushButton()) {
            this.setSelection(item);
            this.showItemControl(item);
        }
        Event e = new Event();
        e.x = event.x;
        e.y = event.y;
        e.item = event.item;
        e.index = event.index;
        e.detail = event.detail;
        this.notifyListeners(13, e);
    }

    private void showItemControl(MTabItem item) {
        if (item.getControl() != null) {
            StackLayout stackLayout = (StackLayout)this.body.getLayout();
            stackLayout.topControl = item.getControl();
            this.body.layout(true);
            item.getControl().moveAbove(null);
        }
    }

    private void handleItemMouseEntered(Point location) {
        MTabItem item = this.getItem(location);
        if (item != this.tooltipItem) {
            String itemTooltipText;
            if (this.tabBar.getToolTipText() != null) {
                this.tabBar.setToolTipText(null);
            }
            if (item != null && (itemTooltipText = item.getTooltipText()) != null && !"".equals(itemTooltipText)) {
                this.tabBar.setToolTipText(itemTooltipText);
            }
            this.tooltipItem = item;
        }
    }

    private void initialItemTooltip() {
        final Display display = this.tabBar.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MTabFolder.this.tabBar != null && !MTabFolder.this.tabBar.isDisposed()) {
                    Point location = MTabFolder.this.tabBar.toControl(display.getCursorLocation());
                    MTabFolder.this.handleItemMouseEntered(location);
                }
            }
        });
    }

    public IStyleProvider getStyleProvider() {
        this.checkWidget();
        return this.styleProvider;
    }

    public void setStyleProvider(IStyleProvider styleProvider) {
        IStyleProvider oldStyleProvider;
        this.checkWidget();
        IStyleProvider iStyleProvider = oldStyleProvider = this.usingDefaultStyles ? null : this.styleProvider;
        if (styleProvider == oldStyleProvider) {
            return;
        }
        if (styleProvider != null) {
            this.styleProvider = styleProvider;
            this.usingDefaultStyles = false;
        } else {
            this.styleProvider = new StyleProvider();
            this.usingDefaultStyles = true;
        }
        this.reskin(0);
        this.pack(false);
        this.updateTabFolder();
        this.tabBar.setStyleProvider(this.getStyleProvider());
    }

    protected void createItem(MTabItem item) {
        if (item.isRadioButton() && item.isSelected()) {
            this.showItemControl(item);
        }
    }

    protected void destroyItem(MTabItem item) {
        if (item.isRadioButton()) {
            MTabItem selectedItem = this.getSelection();
            if (selectedItem != null) {
                this.showItemControl(selectedItem);
            } else {
                StackLayout stackLayout = (StackLayout)this.body.getLayout();
                stackLayout.topControl = null;
                this.body.layout(true);
            }
        }
    }

    protected void updateItem(MTabItem item) {
        if (item.isRadioButton() && item.isSelected()) {
            this.showItemControl(item);
        }
    }
}

