/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.Viewport;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.iconfinder.AbstractProPart;
import org.xmind.ui.internal.iconfinder.IconSessionManager;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.internal.iconfinder.IconfinderContainer;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderEvent;
import org.xmind.ui.internal.iconfinder.IconfinderListener;
import org.xmind.ui.internal.iconfinder.IconfinderViewer;
import org.xmind.ui.internal.iconfinder.ListDialog;
import org.xmind.ui.internal.iconfinder.LoadingDialog;
import org.xmind.ui.internal.iconfinder.Messages;
import org.xmind.ui.internal.iconfinder.model.Category;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.internal.iconfinder.model.Iconset;
import org.xmind.ui.internal.iconfinder.model.SearchIconSession;
import org.xmind.ui.internal.iconfinder.model.Style;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.viewers.SWTUtils;

public class IconfinderPart
extends AbstractProPart
implements IconfinderContainer {
    private static final int ICON_COUNT_STEP = 25;
    private boolean everSearched = false;
    private boolean loadingInfoForIcon = false;
    private boolean loadingForMore = false;
    private boolean searchForIcon = true;
    private int showCount = 1;
    private String categoryAndStyleSessionId = UUID.randomUUID().toString();
    private String searchIconSessionId = UUID.randomUUID().toString();
    private String searchContent;
    private String categoryIdentifier;
    private String styleIdentifier;
    private Text searchIconText;
    private Composite filterSection;
    private Composite pageForIconFilterSection;
    private Composite pageForIconsetFilterSection;
    private Label categoryNameLabel;
    private Label styleNameLabel;
    private Label iconsetLabelOnFilterSection;
    private Label iconCountLabelOnFilterSection;
    private Composite resultSection;
    private Composite defaultPageForResultSection;
    private Composite searchResultPageForResultSection;
    private Composite searchResultPageForNone;
    private Composite searchResultPageForMany;
    private Composite loadingInfoForIconComposite;
    private IconfinderViewer iconfinderViewer;
    private ToolItem backwardItem;
    private ToolItem forwardItem;
    private LocalResourceManager localResourceManager;
    private IconSessionManager iconSessionManager;
    private IconfinderListener iconfinderListener = new IconfinderListener(){

        @Override
        public void handlerIconfinderEvent(final IconfinderEvent event) {
            IconfinderViewer viewer = IconfinderPart.this.getViewer();
            if (viewer != null) {
                final Control control = viewer.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control.isDisposed()) {
                            return;
                        }
                        if (event.getType() == 1) {
                            IconfinderPart.this.updateItem((Icon)event.getSource());
                        } else if (event.getType() == 2) {
                            IconfinderPart.this.loadingInfoForIcon = false;
                            IconfinderPart.this.loadingForMore = false;
                            IconfinderPart.this.updateAll(event.getSource());
                        } else if (event.getType() == 16) {
                            IconfinderPart.this.updateAll(event.getSource());
                        }
                    }
                });
            }
        }
    };

    @Override
    protected void doCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 7;
        layout.marginRight = 7;
        layout.marginTop = 10;
        layout.marginBottom = 7;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.localResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        this.iconSessionManager = new IconSessionManager();
        this.createSearchSection(composite);
        this.createFilterSection(composite);
        this.createResultSection(composite);
        this.createBottomSection(composite);
        IconfinderCore.getInstance().addIconfinderListener(this.getSearchIconSessionId(), this.iconfinderListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconfinderCore.getInstance().removeIconfinderListener(IconfinderPart.this.getSearchIconSessionId(), IconfinderPart.this.iconfinderListener);
            }
        });
    }

    @Override
    protected void init() {
        super.init();
        VerifyUI20141031.getUsageDataCollector().increase("ShowIconfinderCount");
        IconfinderCore.getInstance().requestAllCategories(this.categoryAndStyleSessionId);
        IconfinderCore.getInstance().requestAllStyles(this.categoryAndStyleSessionId);
    }

    @Override
    protected void dispose() {
        super.dispose();
        IconfinderCore.getInstance().cancelJobs();
        FileUtils.delete((File)IconfinderCore.getIconfinderSessionDirectory());
    }

    private IconfinderViewer getViewer() {
        return this.iconfinderViewer;
    }

    private void updateItem(Icon element) {
        if (this.iconfinderViewer != null && element != null) {
            List input = (List)this.iconfinderViewer.getInput();
            for (Object rightIcon : input) {
                if (!(rightIcon instanceof Icon) || ((Icon)rightIcon).getIconId() != element.getIconId()) continue;
                this.iconfinderViewer.update(new Object[]{rightIcon});
                break;
            }
        }
    }

    private void createBottomSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        Label imageLabel = new Label(composite, 0);
        imageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        imageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/log-12.png")));
        Label label = new Label(composite, 0);
        label.setText(Messages.Iconfinder_SupportMessage_label);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
    }

    private void createResultSection(Composite parent) {
        this.resultSection = new Composite(parent, 0);
        StackLayout resultSectionStackLayout = new StackLayout();
        this.resultSection.setLayout((Layout)resultSectionStackLayout);
        this.resultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPageForResultSection = new Composite(this.resultSection, 0);
        this.defaultPageForResultSection.setLayout((Layout)new GridLayout());
        this.defaultPageForResultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Label logo = new Label(this.defaultPageForResultSection, 0);
        logo.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        logo.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/log-64.png")));
        Label descriptionLabel = new Label(this.defaultPageForResultSection, 0);
        descriptionLabel.setText(Messages.Iconfinder_ProvideIconsCount_label);
        descriptionLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        descriptionLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#AAAAAA"))));
        this.searchResultPageForResultSection = new Composite(this.resultSection, 0);
        this.searchResultPageForResultSection.setLayoutData((Object)new GridData(4, 4, true, true));
        StackLayout searchResultStackLayout = new StackLayout();
        this.searchResultPageForResultSection.setLayout((Layout)searchResultStackLayout);
        this.loadingInfoForIconComposite = new Composite(this.searchResultPageForResultSection, 0);
        this.loadingInfoForIconComposite.setLayout((Layout)new GridLayout());
        this.loadingInfoForIconComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label loadingLabel = new Label(this.loadingInfoForIconComposite, 0);
        loadingLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        loadingLabel.setText(Messages.Iconfinder_LoadingState_label);
        this.searchResultPageForMany = new Composite(this.searchResultPageForResultSection, 0);
        this.searchResultPageForMany.setLayout((Layout)new GridLayout());
        this.searchResultPageForMany.setLayoutData((Object)new GridData(4, 4, true, true));
        this.iconfinderViewer = new IconfinderViewer(this, this.searchResultPageForMany);
        this.iconfinderViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.iconfinderViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection selection = event.getSelection();
                IconfinderPart.this.handleIconOpenEvent(selection);
            }
        });
        ArrayList<Object> input = new ArrayList<Object>();
        List<Icon> searchedIcons = IconfinderCore.getIcons(null, this.showCount * 25, this.getSearchIconSessionId());
        if (!searchedIcons.isEmpty()) {
            input.add(searchedIcons);
            input.add(IconfinderViewer.MORE_ICON);
        }
        this.iconfinderViewer.setInput(input);
        this.searchResultPageForNone = new Composite(this.searchResultPageForResultSection, 0);
        this.searchResultPageForNone.setLayout((Layout)new GridLayout());
        this.searchResultPageForNone.setLayoutData((Object)new GridData(4, 4, true, true));
        Label unFoundLabel = new Label(this.searchResultPageForNone, 0);
        unFoundLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/unfound.png")));
        unFoundLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000008, true, true));
        Label unFoundDescriptionLabel = new Label(this.searchResultPageForNone, 0);
        unFoundDescriptionLabel.setText(Messages.Iconfinder_UnFound_label);
        unFoundDescriptionLabel.setLayoutData((Object)new GridData(0x1000000, 1, true, true));
        unFoundDescriptionLabel.setForeground((Color)this.localResourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)ColorUtils.toRGB((String)"#AAAAAA"))));
        searchResultStackLayout.topControl = this.loadingInfoForIcon ? this.loadingInfoForIconComposite : (searchedIcons.isEmpty() ? this.searchResultPageForNone : this.searchResultPageForMany);
        resultSectionStackLayout.topControl = this.everSearched ? this.searchResultPageForResultSection : this.defaultPageForResultSection;
    }

    void handleIconOpenEvent(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Icon) {
            Icon icon = (Icon)element;
            IconfinderCore.getInstance().downloadIconPreview(this.getSearchIconSessionId(), icon, true);
        }
    }

    void insertImage(ISelection selection) {
        IGraphicalEditorPage page;
        IEditorPart editor;
        ArrayList<Icon> icons = new ArrayList<Icon>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Icon) {
                    icons.add((Icon)o);
                }
                ++n2;
            }
        }
        IconfinderCore.blockDowloadIconImage(icons.toArray(new Icon[icons.size()]), null);
        ArrayList<String> paths = new ArrayList<String>(icons.size());
        for (Icon icon : icons) {
            File image;
            VerifyUI20141031.getUsageDataCollector().increase("Iconfinder/Icon/UseCount");
            int iconId = icon.getIconId();
            File iconPreviewFile = IconfinderCore.getIconPreviewFile(this.getSearchIconSessionId(), iconId);
            if (!iconPreviewFile.exists()) {
                IconfinderCore.getInstance().downloadIconPreview(this.getSearchIconSessionId(), icon, true);
            }
            if (!(image = IconfinderCore.getIconFile(iconId)).exists()) continue;
            paths.add(image.getAbsolutePath());
        }
        if (!paths.isEmpty() && (editor = this.getAdapter(IWorkbenchWindow.class).getActivePage().getActiveEditor()) instanceof IGraphicalEditor && (page = ((IGraphicalEditor)editor).getActivePageInstance()) != null) {
            page.getEditDomain().handleRequest(new Request("add_image").setViewer((IViewer)page.getViewer()).setParameter("paths", (Object)paths.toArray(new String[paths.size()])));
        }
    }

    private void createFilterSection(Composite parent) {
        this.filterSection = new Composite(parent, 0);
        this.filterSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        StackLayout filterSectionStackLayout = new StackLayout();
        this.filterSection.setLayout((Layout)filterSectionStackLayout);
        this.pageForIconFilterSection = this.createPageForIconFilterSection(this.filterSection);
        this.pageForIconsetFilterSection = this.createPageForIconsetFilterSection(this.filterSection);
        filterSectionStackLayout.topControl = this.searchForIcon ? this.pageForIconFilterSection : this.pageForIconsetFilterSection;
    }

    private Composite createPageForIconsetFilterSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.iconsetLabelOnFilterSection = new Label(composite, 0);
        this.iconsetLabelOnFilterSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.iconCountLabelOnFilterSection = new Label(composite, 0);
        this.iconCountLabelOnFilterSection.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        return composite;
    }

    private Composite createPageForIconFilterSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite categoryComposite = new Composite(composite, 0);
        GridLayout categoryLayout = new GridLayout(2, false);
        categoryLayout.marginHeight = 0;
        categoryLayout.marginLeft = 0;
        categoryLayout.marginRight = 10;
        categoryLayout.marginWidth = 0;
        categoryComposite.setLayout((Layout)categoryLayout);
        categoryComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label categoryLabel = new Label(categoryComposite, 0);
        categoryLabel.setText(Messages.Iconfinder_Categories_label);
        categoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite categoryCombo = new Composite(categoryComposite, 2048);
        GridLayout categoryComboLayout = new GridLayout(2, false);
        categoryComboLayout.marginHeight = 0;
        categoryComboLayout.marginWidth = 0;
        categoryCombo.setLayout((Layout)categoryComboLayout);
        categoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.categoryNameLabel = new Label(categoryCombo, 0);
        this.categoryNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.categoryNameLabel.setText("All");
        this.categoryIdentifier = "All";
        this.categoryNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderPart.this.showCategoriesDialog((Control)IconfinderPart.this.categoryNameLabel);
            }
        });
        final Label categoryImageLabel = new Label(categoryCombo, 0);
        categoryImageLabel.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/dropdown.png")));
        categoryImageLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        categoryImageLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderPart.this.showCategoriesDialog((Control)categoryImageLabel);
            }
        });
        Composite styleComposite = new Composite(composite, 0);
        GridLayout styleLayout = new GridLayout(2, false);
        styleLayout.marginHeight = 0;
        styleLayout.marginWidth = 0;
        styleLayout.marginLeft = 10;
        styleLayout.marginRight = 0;
        styleComposite.setLayout((Layout)styleLayout);
        styleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label styleLabel = new Label(styleComposite, 0);
        styleLabel.setText(Messages.Iconfinder_Styles_label);
        styleLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite styleCombo = new Composite(styleComposite, 2048);
        GridLayout styleComboLayout = new GridLayout(2, false);
        styleComboLayout.marginWidth = 0;
        styleComboLayout.marginHeight = 0;
        styleCombo.setLayout((Layout)styleComboLayout);
        styleCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.styleNameLabel = new Label(styleCombo, 0);
        this.styleNameLabel.setText("All");
        this.styleIdentifier = "All";
        this.styleNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.styleNameLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderPart.this.showStylesDialog((Control)IconfinderPart.this.styleNameLabel);
            }
        });
        final Label styleImageLable = new Label(styleCombo, 0);
        styleImageLable.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/dropdown.png")));
        styleImageLable.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        styleImageLable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                IconfinderPart.this.showStylesDialog((Control)styleImageLable);
            }
        });
        return composite;
    }

    private void createSearchSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createToolBarSection(composite);
        this.searchIconText = new Text(composite, 2436);
        this.searchIconText.setMessage(Messages.Iconfinder_SearchIconsText_message);
        GridData textGridData = new GridData(4, 0x1000000, true, false);
        this.searchIconText.setLayoutData((Object)textGridData);
        this.searchIconText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)13)) {
                    IconfinderPart.this.searchContent = IconfinderPart.this.searchIconText.getText();
                    IconfinderPart.this.newSearch(IconfinderPart.this.searchContent);
                }
            }
        });
        Button searchButton = new Button(composite, 8);
        GridData buttonGridData = new GridData(1, 0x1000000, false, true);
        searchButton.setLayoutData((Object)buttonGridData);
        searchButton.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/ic_search.png")));
        searchButton.addSelectionListener(new SelectionListener(){

            public synchronized void widgetSelected(SelectionEvent e) {
                IconfinderPart.this.searchContent = IconfinderPart.this.searchIconText.getText();
                SearchIconSession currentSession = IconfinderPart.this.iconSessionManager.getCurrentSession();
                if (currentSession != null && IconfinderPart.this.searchContent != null && IconfinderPart.this.searchContent.equals(currentSession.getKey()) && IconfinderPart.this.categoryIdentifier != null && IconfinderPart.this.categoryIdentifier.equals(currentSession.getCategory()) && IconfinderPart.this.styleIdentifier != null && IconfinderPart.this.styleIdentifier.equals(currentSession.getStyle())) {
                    return;
                }
                IconfinderPart.this.newSearch(IconfinderPart.this.searchContent);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void showCategoriesDialog(final Control base) {
        List<Category> categories = IconfinderCore.getCategories();
        if (categories.size() <= 1) {
            IconfinderCore.getInstance().requestAllCategories(this.categoryAndStyleSessionId);
            LoadingDialog loadingDialog = new LoadingDialog(base.getShell(), this.categoryAndStyleSessionId){

                @Override
                protected void handleIconfinderEvent(IconfinderEvent event) {
                    if (event.getType() == 4 && base != null && !base.isDisposed()) {
                        base.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.close();
                                IconfinderPart.this.doShowCategoriesDialog(base, IconfinderCore.getCategories());
                            }
                        });
                    }
                }
            };
            loadingDialog.open(this.getItemBoundsToDisplay(base));
            return;
        }
        this.doShowCategoriesDialog(base, categories);
    }

    private void doShowCategoriesDialog(Control base, List<Category> categories) {
        ListDialog<Category> dialog = new ListDialog<Category>(base.getShell(), categories){

            @Override
            protected void configItem(Hyperlink item, final Category category) {
                item.setText(category.getNme());
                item.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        IconfinderPart.this.setCategory(category);
                        this.close();
                    }
                });
            }
        };
        dialog.open(this.getItemBoundsToDisplay(base));
    }

    private void setCategory(Category category) {
        this.categoryNameLabel.setText(IconfinderPart.specialFormatForLabel(category.getNme()));
        this.categoryIdentifier = category.getIdentifier();
        this.searchContent = this.searchIconText.getText();
        this.newSearch(this.searchContent);
    }

    public void showStylesDialog(final Control base) {
        List<Style> styles = IconfinderCore.getStyles();
        if (styles.size() <= 1) {
            IconfinderCore.getInstance().requestAllStyles(this.categoryAndStyleSessionId);
            LoadingDialog loadingDialog = new LoadingDialog(base.getShell(), this.categoryAndStyleSessionId){

                @Override
                protected void handleIconfinderEvent(IconfinderEvent event) {
                    if (event.getType() == 8 && base != null && !base.isDisposed()) {
                        base.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.close();
                                IconfinderPart.this.doShowStylesDialog(base, IconfinderCore.getStyles());
                            }
                        });
                    }
                }
            };
            loadingDialog.open(this.getItemBoundsToDisplay(base));
            return;
        }
        this.doShowStylesDialog(base, styles);
    }

    private void doShowStylesDialog(Control base, List<Style> styles) {
        ListDialog<Style> dialog = new ListDialog<Style>(base.getShell(), styles){

            @Override
            protected void configItem(Hyperlink item, final Style style) {
                item.setText(style.getName());
                item.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        IconfinderPart.this.setStyle(style);
                        this.close();
                    }
                });
            }
        };
        dialog.open(this.getItemBoundsToDisplay(base));
    }

    private void setStyle(Style style) {
        this.styleNameLabel.setText(IconfinderPart.specialFormatForLabel(style.getName()));
        this.styleIdentifier = style.getIdentifier();
        this.searchContent = this.searchIconText.getText();
        this.newSearch(this.searchContent);
    }

    private Rectangle getItemBoundsToDisplay(Control item) {
        Rectangle bounds = item.getBounds();
        Point loc = item.getParent().toDisplay(bounds.x, bounds.y);
        bounds.x = loc.x;
        bounds.y = loc.y;
        return bounds;
    }

    public void newSearch(String queryContent) {
        this.resetShowCount();
        this.searchIconText.setText(queryContent);
        int length = this.searchIconText.getText().length();
        this.searchIconText.setSelection(length, length);
        IconfinderCore.getInstance().cancelJobs();
        if (queryContent == null || queryContent.equals("")) {
            this.everSearched = false;
            this.searchForIcon = true;
            this.loadingInfoForIcon = false;
        } else {
            this.everSearched = true;
            this.loadingInfoForIcon = true;
            boolean searchIconSet = queryContent.startsWith("iconset:");
            this.searchForIcon = !searchIconSet;
            this.generateNewSearchIconSession();
            this.iconSessionManager.addSession(new SearchIconSession(this.searchIconSessionId, queryContent, this.categoryIdentifier, this.styleIdentifier));
            IconfinderCore.getInstance().addIconfinderListener(this.getSearchIconSessionId(), this.iconfinderListener);
            if (searchIconSet) {
                VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Iconset"));
                this.iconfinderViewer.setIconsetEntrance(false);
                this.searchContent = queryContent;
                this.iconsetLabelOnFilterSection.setVisible(false);
                this.iconCountLabelOnFilterSection.setVisible(false);
                queryContent = queryContent.substring(8);
                IconfinderCore.getInstance().requestIconsByIconset(queryContent, 0, 0, this.getSearchIconSessionId(), false);
            } else {
                VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Icon"));
                this.iconfinderViewer.setIconsetEntrance(true);
                String category = "All".equals(this.categoryIdentifier) ? null : this.categoryIdentifier;
                String style = "All".equals(this.styleIdentifier) ? null : this.styleIdentifier;
                int existedCount = (this.showCount - 1) * 25;
                IconfinderCore.getInstance().requestIcons(queryContent, category, style, existedCount, this.getSearchIconSessionId(), false);
            }
        }
        this.updateAll(null);
    }

    @Override
    public void promoteToSearchIconset(String iconsetIdentifier) {
        this.iconfinderViewer.setIconsetEntrance(false);
        this.searchContent = "iconset:" + iconsetIdentifier;
        this.searchIconText.setText(this.searchContent);
        this.searchForIcon = false;
        this.everSearched = true;
        this.resetShowCount();
        IconfinderCore.getInstance().cancelJobs();
        File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(this.getSearchIconSessionId());
        File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(iconsetIdentifier) + ".json");
        if (iconsetDetailFile.exists()) {
            this.loadingInfoForIcon = false;
            this.iconSessionManager.addSession(new SearchIconSession(this.getSearchIconSessionId(), this.searchContent, true, this.categoryIdentifier, this.styleIdentifier));
            Iconset iconset = new Iconset(IconfinderCore.readObject(iconsetDetailFile));
            this.updateAll(iconset);
        } else {
            this.newSearch(this.searchContent);
        }
    }

    @Override
    public boolean isLoading() {
        return this.loadingForMore;
    }

    @Override
    public void moreSearch() {
        ++this.showCount;
        this.everSearched = true;
        this.loadingInfoForIcon = false;
        this.loadingForMore = true;
        this.iconfinderViewer.update(new Object[]{IconfinderViewer.MORE_ICON});
        int existedCount = (this.showCount - 1) * 25;
        if (this.searchForIcon) {
            VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Icon"));
            this.iconfinderViewer.setIconsetEntrance(true);
            String category = "All".equals(this.categoryIdentifier) ? null : this.categoryIdentifier;
            String style = "All".equals(this.styleIdentifier) ? null : this.styleIdentifier;
            IconfinderCore.getInstance().requestIcons(this.searchContent, category, style, existedCount, this.getSearchIconSessionId(), false);
        } else {
            VerifyUI20141031.getUsageDataCollector().increase(String.format("Iconfinder/SearchCount/%s", "Iconset"));
            this.iconfinderViewer.setIconsetEntrance(false);
            String searchContent = this.searchContent;
            searchContent = searchContent.substring(8);
            List<Icon> icons = IconfinderCore.getIcons(searchContent, existedCount, this.getSearchIconSessionId());
            int after = icons.get(icons.size() - 1).getIconId();
            IconfinderCore.getInstance().requestIconsByIconset(searchContent, after, existedCount, this.getSearchIconSessionId(), false);
        }
        SearchIconSession currentSession = this.iconSessionManager.getCurrentSession();
        if (this.iconSessionManager != null) {
            currentSession.setShowCount(this.showCount);
        }
    }

    private void resetShowCount() {
        this.showCount = 1;
    }

    private void generateNewSearchIconSession() {
        this.searchIconSessionId = UUID.randomUUID().toString();
    }

    @Override
    public String getSearchIconSessionId() {
        return this.searchIconSessionId;
    }

    private void updateAll(Object source) {
        this.updateSearchIcons(source, this.getSearchIconSessionId());
        this.updateBackForwardItem();
    }

    @Override
    protected int getRequiredFeatures() {
        return 3;
    }

    @Override
    protected String getFeatureKey() {
        return "Iconfinder";
    }

    @Override
    protected void setFocus() {
        if (this.searchIconText != null && !this.searchIconText.isDisposed()) {
            this.searchIconText.setFocus();
        }
    }

    private static String specialFormatForLabel(String origin) {
        char[] charArray = origin.toCharArray();
        char[] newCharArray = new char[charArray.length * 2];
        int i = 0;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            newCharArray[i++] = ch;
            if (ch == '&') {
                newCharArray[i++] = 38;
            }
            ++n2;
        }
        return new String(newCharArray);
    }

    private Composite createToolBarSection(Composite parent) {
        ToolBar backForwardBar = new ToolBar(parent, 0);
        backForwardBar.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.backwardItem = new ToolItem(backForwardBar, 0);
        this.backwardItem.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/ic_back.png")));
        this.backwardItem.setDisabledImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/ic_back_unavailable.png")));
        this.forwardItem = new ToolItem(backForwardBar, 0);
        this.forwardItem.setImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/ic_forward.png")));
        this.forwardItem.setDisabledImage((Image)this.localResourceManager.get((DeviceResourceDescriptor)IconfinderActivator.createImageDescriptor("/image/ic_forward_unavailable.png")));
        this.backwardItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchIconSession session = IconfinderPart.this.iconSessionManager.backward();
                IconfinderPart.this.restoreFromSession(session);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.forwardItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SearchIconSession session = IconfinderPart.this.iconSessionManager.forward();
                IconfinderPart.this.restoreFromSession(session);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.backwardItem.setEnabled(false);
        this.forwardItem.setEnabled(false);
        return backForwardBar;
    }

    private void updateSearchIcons(Object source, String searchIconSessionId) {
        boolean enabled;
        if (!this.searchForIcon) {
            if (source instanceof Iconset) {
                String iconsetName = ((Iconset)source).getName();
                this.iconsetLabelOnFilterSection.setText(NLS.bind((String)Messages.Iconfinder_Iconset_With_Name, (Object)iconsetName));
                int iconsCount = ((Iconset)source).getIconsCount();
                this.iconCountLabelOnFilterSection.setText(NLS.bind((String)Messages.Iconfinder_Icons_With_Count, (Object)iconsCount));
                this.iconsetLabelOnFilterSection.setVisible(true);
                this.iconCountLabelOnFilterSection.setVisible(true);
            }
            this.pageForIconsetFilterSection.layout(true);
        }
        StackLayout filterSectionStackLayout = (StackLayout)this.filterSection.getLayout();
        filterSectionStackLayout.topControl = this.searchForIcon ? this.pageForIconFilterSection : this.pageForIconsetFilterSection;
        this.filterSection.layout(true);
        StackLayout resultSectionStackLayout = (StackLayout)this.resultSection.getLayout();
        resultSectionStackLayout.topControl = this.everSearched ? this.searchResultPageForResultSection : this.defaultPageForResultSection;
        String iconsetIdentifier = null;
        if (!this.searchForIcon) {
            iconsetIdentifier = this.searchContent.substring(8);
        }
        List<Icon> icons = IconfinderCore.getIcons(iconsetIdentifier, 25 * this.showCount, searchIconSessionId);
        StackLayout resultPageLayout = (StackLayout)this.searchResultPageForResultSection.getLayout();
        resultPageLayout.topControl = this.loadingInfoForIcon ? this.loadingInfoForIconComposite : (icons.isEmpty() ? this.searchResultPageForNone : this.searchResultPageForMany);
        this.searchResultPageForResultSection.layout(true);
        int totalIconsSize = IconfinderCore.getTotalIconsSize(iconsetIdentifier, searchIconSessionId);
        boolean bl = enabled = totalIconsSize > icons.size();
        if (this.iconfinderViewer != null) {
            ArrayList<Object> input = new ArrayList<Object>();
            if (!icons.isEmpty()) {
                input.addAll(icons);
                if (enabled) {
                    input.add(IconfinderViewer.MORE_ICON);
                }
            }
            this.iconfinderViewer.setInput(input);
            Viewport viewport = this.iconfinderViewer.getViewport();
            this.iconfinderViewer.scrollToY(viewport.getClientArea().y - viewport.getClientArea().height);
        }
        this.searchResultPageForMany.layout(true);
        this.resultSection.layout(true);
    }

    private void updateBackForwardItem() {
        if (!this.iconSessionManager.hasPrevious()) {
            this.backwardItem.setEnabled(false);
        } else if (!this.backwardItem.isEnabled()) {
            this.backwardItem.setEnabled(true);
        }
        if (!this.iconSessionManager.hasNext()) {
            this.forwardItem.setEnabled(false);
        } else if (!this.forwardItem.isEnabled()) {
            this.forwardItem.setEnabled(true);
        }
    }

    private void restoreFromSession(SearchIconSession session) {
        this.searchIconSessionId = session.getId();
        this.searchContent = session.getKey();
        this.searchIconText.setText(this.searchContent);
        this.showCount = session.getShowCount();
        this.categoryIdentifier = session.getCategory();
        this.styleIdentifier = session.getStyle();
        this.categoryNameLabel.setText(IconfinderPart.specialFormatForLabel(IconfinderPart.getCategoryNameFromCategoryId(this.categoryIdentifier)));
        this.styleNameLabel.setText(IconfinderPart.specialFormatForLabel(IconfinderPart.getStyleNameFromStyleId(this.styleIdentifier)));
        this.iconfinderViewer.setIconsetEntrance(!session.isIconset());
        if (session.isIconset()) {
            File iconsetDetailsDir = IconfinderCore.getIconsetDetailsDirBasedOn(this.getSearchIconSessionId());
            File iconsetDetailFile = new File(iconsetDetailsDir, String.valueOf(this.searchContent.substring("iconset:".length())) + ".json");
            if (iconsetDetailFile.exists()) {
                this.loadingInfoForIcon = false;
                this.searchForIcon = false;
                Iconset iconset = new Iconset(IconfinderCore.readObject(iconsetDetailFile));
                this.updateAll(iconset);
            }
        } else {
            this.searchForIcon = true;
            this.updateAll(null);
        }
    }

    private static String getCategoryNameFromCategoryId(String categoryIdentifier) {
        List<Category> categories = IconfinderCore.getCategories();
        for (Category category : categories) {
            if (!categoryIdentifier.equals(category.getIdentifier())) continue;
            return category.getNme();
        }
        return "All";
    }

    private static String getStyleNameFromStyleId(String styleIdentifier) {
        List<Style> styles = IconfinderCore.getStyles();
        for (Style style : styles) {
            if (!styleIdentifier.equals(style.getIdentifier())) continue;
            return style.getName();
        }
        return "All";
    }
}

