/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.xmind.core.IFileEntry;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookComponent;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Property;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.ModifyStyleCommand;

public class ModifyStyleCommandBuilder
extends CommandBuilder {
    private static final String NULL = "$NULL$";
    private Request request;
    private IStyle sourceStyle;
    private Map<String, String> idCache = null;
    private Map<String, Properties> propertiesCache = new HashMap<String, Properties>();
    private List<IStyled> sources = new ArrayList<IStyled>();

    public ModifyStyleCommandBuilder(Request request) {
        this(request.getTargetViewer(), request.getTargetDomain().getCommandStack(), request);
    }

    public ModifyStyleCommandBuilder(IViewer viewer, CommandBuilder delegate, Request request) {
        super(viewer, delegate);
        this.init(request);
    }

    public ModifyStyleCommandBuilder(IViewer viewer, ICommandStack commandStack, Request request) {
        super(viewer, commandStack);
        this.init(request);
    }

    private void init(Request request) {
        this.request = request;
        Object resource = request.getParameter("resource");
        this.sourceStyle = resource instanceof IStyle ? (IStyle)resource : null;
    }

    public List<IStyled> getModifiedSources() {
        return this.sources;
    }

    public boolean isSourceModified(IStyled source) {
        return this.sources.contains(source);
    }

    public void modify(IStyled source) {
        String newStyleId;
        if (this.isSourceModified(source)) {
            return;
        }
        String sourceType = this.getStyleType(source);
        if (sourceType == null) {
            return;
        }
        String sourceStyleId = source.getStyleId();
        String oldStyleId = sourceStyleId;
        if (oldStyleId == null) {
            oldStyleId = NULL + sourceType;
        }
        if ((newStyleId = this.getCachedId(oldStyleId)) == null) {
            newStyleId = this.getNewStyleId(source, sourceStyleId, sourceType);
            if (newStyleId == null) {
                newStyleId = NULL + sourceType;
            }
            this.cacheId(oldStyleId, newStyleId);
        }
        if (oldStyleId.equals(newStyleId)) {
            return;
        }
        this.modifyStyle(source, newStyleId);
        this.sources.add(source);
    }

    public void removeStyle(IStyled source) {
        if (this.isSourceModified(source)) {
            return;
        }
        this.modifyStyle(source, null);
        this.sources.add(source);
    }

    private void modifyStyle(IStyled source, String newStyleId) {
        if (NULL.equals(newStyleId)) {
            newStyleId = null;
        }
        this.add((Command)new ModifyStyleCommand(source, newStyleId), true);
    }

    private void cacheId(String oldId, String newId) {
        if (this.idCache == null) {
            this.idCache = new HashMap<String, String>();
        }
        this.idCache.put(oldId, newId);
    }

    private String getCachedId(String oldId) {
        if (this.idCache != null) {
            return this.idCache.get(oldId);
        }
        return null;
    }

    private String getNewStyleId(IStyled source, String sourceStyleId, String sourceType) {
        IStyleSheet styleSheet = this.getStyleSheet(source);
        if (styleSheet == null) {
            return null;
        }
        IStyle oldStyle = sourceStyleId == null ? null : styleSheet.findStyle(sourceStyleId);
        Properties oldProperties = this.getProperties(oldStyle);
        if (oldProperties == null) {
            oldProperties = new Properties();
        } else {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)oldProperties);
            oldProperties = p;
        }
        this.putValues(source, oldProperties, sourceType);
        if (oldProperties.isEmpty()) {
            return null;
        }
        IStyle similarStyle = this.findSimilarStyle(oldProperties, styleSheet);
        if (similarStyle != null) {
            return similarStyle.getId();
        }
        IStyle newStyle = this.createStyle(styleSheet, source, oldProperties, sourceType);
        if (newStyle != null) {
            return newStyle.getId();
        }
        return null;
    }

    private void putValues(IStyled source, Properties oldProperties, String sourceType) {
        if (this.sourceStyle != null && this.sourceStyle.getType().equals(sourceType)) {
            Iterator sourceProperties = this.sourceStyle.properties();
            while (sourceProperties.hasNext()) {
                Property prop = (Property)sourceProperties.next();
                if (prop.value == null) {
                    oldProperties.remove(prop.key);
                    continue;
                }
                oldProperties.put(prop.key, prop.value);
            }
        }
        for (String name : this.request.getParameterNames()) {
            if (!name.startsWith("styleProperty.")) continue;
            String key = name.substring("styleProperty.".length());
            String value = (String)this.request.getParameter(name);
            if ((value = this.evaluate(source, key, value)) == null) {
                oldProperties.remove(key);
                continue;
            }
            oldProperties.put(key, value);
        }
    }

    private IStyle findSimilarStyle(Properties sourceProperties, IStyleSheet styleSheet) {
        Set styles = styleSheet.getStyles("normal-styles");
        for (IStyle style : styles) {
            Properties contents = this.getProperties(style);
            if (!contents.equals(sourceProperties)) continue;
            return style;
        }
        return null;
    }

    private IStyle createStyle(IStyleSheet styleSheet, IStyled source, Properties properties, String sourceType) {
        if (sourceType == null) {
            return null;
        }
        IStyle newStyle = styleSheet.createStyle(sourceType);
        for (Map.Entry<Object, Object> en : properties.entrySet()) {
            newStyle.setProperty((String)en.getKey(), (String)en.getValue());
        }
        styleSheet.addStyle(newStyle, "normal-styles");
        return newStyle;
    }

    private String getStyleType(IStyled source) {
        return source == null ? null : source.getStyleType();
    }

    private String evaluate(IStyled source, String key, String value) {
        if (value != null && "background".equals(key)) {
            String attachmentURL = this.getCachedId(value);
            if (attachmentURL == null && (attachmentURL = this.createAttachmentURL(source, value)) != null) {
                this.cacheId(value, attachmentURL);
            }
            if (attachmentURL != null) {
                value = attachmentURL;
            }
        }
        return value;
    }

    private String createAttachmentURL(IStyled source, String value) {
        IFileEntry entry;
        File file = new File(value);
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        IWorkbook workbook = this.getWorkbook(source);
        if (workbook == null) {
            return null;
        }
        try {
            entry = workbook.getManifest().createAttachmentFromFilePath(value);
        }
        catch (IOException iOException) {
            return null;
        }
        if (entry == null) {
            return null;
        }
        return HyperlinkUtils.toAttachmentURL((String)entry.getPath());
    }

    private Properties getProperties(IStyle style) {
        Properties properties;
        if (style == null) {
            return null;
        }
        String id = style.getId();
        if (this.propertiesCache == null) {
            this.propertiesCache = new HashMap<String, Properties>();
        }
        if ((properties = this.propertiesCache.get(id)) != null) {
            return properties;
        }
        properties = new Properties();
        this.propertiesCache.put(id, properties);
        Iterator it = style.properties();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            properties.put(p.key, p.value);
        }
        return properties;
    }

    private IWorkbook getWorkbook(IStyled styled) {
        if (styled instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)styled).getOwnedWorkbook();
        }
        return null;
    }

    private IStyleSheet getStyleSheet(IStyled styled) {
        if (styled instanceof IWorkbookComponent) {
            return ((IWorkbookComponent)styled).getOwnedWorkbook().getStyleSheet();
        }
        return null;
    }
}

