/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.mindmap.MindMapUI;

public class EncryptionDialog
extends TitleAreaDialog {
    private static final String DEFAULT_BUTTON_TRIGGER_EVENT_ID = "DEFAULT_BUTTON_TRIGGER_EVENT_ID";
    private int defaultButtonId = -1;
    private Map<Integer, Button> buttons;
    private Text oldPasswordInputBox;
    private Text newPasswordInputBox;
    private Text verifyNewPasswordInputBox;
    private Text hintPasswordInputBox;
    private Label oldPasswordVerificationLabel;
    private Label newPasswordVerificationLabel;
    private Label warningLabel;
    private Composite container;
    private Image doneIcon;
    private String password;
    private String hintMessage;
    private Listener defaultButtonListener;

    protected EncryptionDialog(Shell parentShell) {
        super(parentShell);
    }

    private Image getErrorIcon() {
        ImageDescriptor img;
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return null;
        }
        if ((this.doneIcon == null || this.doneIcon.isDisposed()) && (img = MindMapUI.getImages().get("icons/misc/warning.png")) != null) {
            this.doneIcon = img.createImage((Device)this.getContainer().getDisplay());
        }
        return this.doneIcon;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    public void create() {
        super.create();
        this.setTitle(this.hasPassword() ? MindMapMessages.EncrptionDialog_ChangePassword_title : MindMapMessages.EncryptionDialog_SetPassword_title);
        this.setTitleImage(null);
        this.setMessage(this.hasPassword() ? MindMapMessages.EncryptionDialog_ChangePassword_message : MindMapMessages.EncryptionDialog_SetPassword_message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.container = composite;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 20;
        gridLayout.marginHeight = 20;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createPasswordArea(composite);
        this.checkSetButton();
        return composite;
    }

    private Composite createPasswordArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = -1;
        gridData.heightHint = -1;
        area.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.horizontalSpacing = 3;
        area.setLayout((Layout)gridLayout);
        if (this.hasPassword()) {
            this.createOldPasswordInputBox(area);
        }
        this.createNewPasswordInputBox(area);
        this.createVerifyPasswordInputBox(area);
        this.createHintPasswordInputBox(area);
        this.createErrorMessage(area);
        Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                EncryptionDialog.this.checkSetButton();
            }
        };
        if (this.oldPasswordInputBox != null) {
            this.oldPasswordInputBox.addListener(24, verifyListener);
        }
        this.newPasswordInputBox.addListener(24, verifyListener);
        this.verifyNewPasswordInputBox.addListener(24, verifyListener);
        return area;
    }

    private void createErrorMessage(Composite parent) {
        new Label(parent, 0);
        this.warningLabel = new Label(parent, 0);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 200;
        gridData.heightHint = -1;
        this.warningLabel.setLayoutData((Object)gridData);
        this.warningLabel.setForeground(Display.getCurrent().getSystemColor(3));
        new Label(parent, 0);
    }

    private void createOldPasswordInputBox(Composite parent) {
        this.createInputLabel(parent, MindMapMessages.EncryptDialogPane_oldpassword_text);
        this.oldPasswordInputBox = this.createInput(parent, 0x400804, -1);
        this.hookText(this.oldPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.oldPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.oldPasswordInputBox, 14);
        this.oldPasswordVerificationLabel = new Label(parent, 0);
        this.oldPasswordVerificationLabel.setBackground(parent.getBackground());
        this.oldPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.oldPasswordVerificationLabel.setImage(this.getErrorIcon());
        this.oldPasswordVerificationLabel.setVisible(false);
    }

    private void createNewPasswordInputBox(Composite parent) {
        String text = this.oldPasswordInputBox == null ? MindMapMessages.EncryptDialogPane_password_text : MindMapMessages.EncryptDialogPane_newpassword_text;
        this.createInputLabel(parent, text);
        this.newPasswordInputBox = this.createInput(parent, 0x400804, -1);
        this.hookText(this.newPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.newPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.newPasswordInputBox, 14);
        new Label(parent, 0);
    }

    private void createVerifyPasswordInputBox(Composite parent) {
        this.createInputLabel(parent, MindMapMessages.EncryptDialogPane_confirm_text);
        this.verifyNewPasswordInputBox = this.createInput(parent, 0x400804, -1);
        this.hookText(this.verifyNewPasswordInputBox);
        this.addRefreshDefaultButtonListener((Control)this.verifyNewPasswordInputBox);
        this.addTriggerDefaultButtonListener((Control)this.verifyNewPasswordInputBox, 14);
        this.newPasswordVerificationLabel = new Label(parent, 0);
        this.newPasswordVerificationLabel.setBackground(parent.getBackground());
        this.newPasswordVerificationLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.newPasswordVerificationLabel.setImage(this.getErrorIcon());
        this.newPasswordVerificationLabel.setVisible(false);
    }

    private void createHintPasswordInputBox(Composite parent) {
        this.createInputLabel(parent, NLS.bind((String)MindMapMessages.EncryptionDialog_HintInput_label, (Object)" \n "));
        this.hintPasswordInputBox = this.createInput(parent, 2112, 50);
        new Label(parent, 0);
        this.hookText(this.hintPasswordInputBox);
    }

    private Label createInputLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setBackground(parent.getBackground());
        return label;
    }

    private Text createInput(Composite parent, int style, int height) {
        Text input = new Text(parent, style);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.minimumWidth = 200;
        gridData.widthHint = 200;
        gridData.heightHint = height;
        input.setLayoutData((Object)gridData);
        return input;
    }

    private Composite getContainer() {
        return this.container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MindMapMessages.EncryptionDialog_SetPassword_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, MindMapMessages.EncryptionDialog_ButtonBar_Set_button, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setSetButtonEnabled(false);
    }

    private void setSetButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private void checkSetButton() {
        if (this.oldPasswordInputBox == null) {
            this.setSetButtonEnabled(!"".equals(this.newPasswordInputBox.getText()) && !"".equals(this.verifyNewPasswordInputBox.getText()));
        } else {
            this.setSetButtonEnabled(!"".equals(this.oldPasswordInputBox.getText()));
        }
    }

    protected void addRefreshDefaultButtonListener(Control focusControl) {
        focusControl.addListener(15, this.getDefaultButtonListener());
        focusControl.addListener(16, this.getDefaultButtonListener());
    }

    protected void addTriggerDefaultButtonListener(Control control, int triggerEvent) {
        control.addListener(triggerEvent, this.getDefaultButtonListener());
        control.setData(DEFAULT_BUTTON_TRIGGER_EVENT_ID, (Object)triggerEvent);
    }

    private Listener getDefaultButtonListener() {
        if (this.defaultButtonListener == null) {
            this.defaultButtonListener = new Listener(){
                private Button savedDefaultButton = null;

                public void handleEvent(Event event) {
                    Object triggerEvent = event.widget.getData(EncryptionDialog.DEFAULT_BUTTON_TRIGGER_EVENT_ID);
                    if (triggerEvent instanceof Integer && event.type == (Integer)triggerEvent) {
                        EncryptionDialog.this.triggerDefaultButton();
                        return;
                    }
                    if (event.type == 15) {
                        this.changeDefaultButton();
                    } else if (event.type == 16) {
                        this.restoreDefaultButton();
                    }
                }

                private void restoreDefaultButton() {
                    if (EncryptionDialog.this.defaultButtonId >= 0) {
                        Shell shell = EncryptionDialog.this.container.getShell();
                        if (this.savedDefaultButton != null && this.savedDefaultButton.isDisposed()) {
                            this.savedDefaultButton = null;
                        }
                        shell.setDefaultButton(this.savedDefaultButton);
                    }
                }

                private void changeDefaultButton() {
                    if (EncryptionDialog.this.defaultButtonId >= 0) {
                        final Shell shell = EncryptionDialog.this.container.getShell();
                        this.savedDefaultButton = shell.getDefaultButton();
                        shell.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Button button = EncryptionDialog.this.getButton(EncryptionDialog.this.defaultButtonId);
                                if (button != null && !button.isDisposed()) {
                                    shell.setDefaultButton(button);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.defaultButtonListener;
    }

    protected Button getDefaultButton() {
        if (this.buttons != null && this.defaultButtonId >= 0) {
            return this.getButton(this.defaultButtonId);
        }
        return null;
    }

    protected void triggerDefaultButton() {
        this.triggerButton(this.defaultButtonId);
    }

    protected void triggerButton(int buttonId) {
        Button button;
        if (buttonId >= 0 && (button = this.getButton(buttonId)) != null && !button.isDisposed() && button.isEnabled()) {
            this.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        if (!this.verify()) {
            this.warningLabel.setText(this.verifyOldPassword() ? MindMapMessages.EncryptionDialog_Warning_NotMatch_label : MindMapMessages.EncryptionDialog_Warning_NotCorrect_label);
            return;
        }
        this.setPassword(this.newPasswordInputBox.getText());
        this.setHintMessage(this.hintPasswordInputBox.getText());
        super.okPressed();
    }

    private boolean verifyOldPassword() {
        boolean oldPasswordVerified = false;
        if (!this.hasPassword()) {
            oldPasswordVerified = !"".equals(this.newPasswordInputBox.getText());
        } else if (this.oldPasswordInputBox != null) {
            oldPasswordVerified = this.testsPassword(this.oldPasswordInputBox.getText());
            this.oldPasswordVerificationLabel.setVisible(!oldPasswordVerified);
        }
        this.newPasswordVerificationLabel.setVisible(oldPasswordVerified);
        return oldPasswordVerified;
    }

    private boolean verifyNewPassword() {
        boolean newPasswordVerified = (this.oldPasswordInputBox != null || !"".equals(this.newPasswordInputBox.getText())) && this.newPasswordInputBox.getText().equals(this.verifyNewPasswordInputBox.getText());
        this.newPasswordVerificationLabel.setVisible(!newPasswordVerified);
        return newPasswordVerified;
    }

    protected boolean verify() {
        return this.verifyOldPassword() && this.verifyNewPassword();
    }

    protected void setPassword(String newPassword) {
        if (this.verify()) {
            if ("".equals(newPassword)) {
                newPassword = null;
            }
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("SetPasswordCount");
            this.password = newPassword;
        }
    }

    protected String getPassword() {
        return this.password;
    }

    protected boolean hasPassword() {
        return false;
    }

    protected boolean testsPassword(String password) {
        return false;
    }

    protected void setHintMessage(String hintMessage) {
        if (this.verify()) {
            if ("".equals(hintMessage)) {
                hintMessage = null;
            }
            this.hintMessage = hintMessage;
            MindMapUIPlugin.getDefault().getUsageDataCollector().increase("SetPasswordHintCount");
        }
    }

    protected String getHintMessage() {
        return this.hintMessage;
    }

    private void hookText(final Text text) {
        text.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                text.selectAll();
            }
        });
    }
}

