/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorators;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.xmind.core.ITitled;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.IUseTransparency;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.decorators.TitleTextDecorator;
import org.xmind.ui.mindmap.IRelationshipPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.style.StyleUtils;

public class RelTitleTextDecorator
extends TitleTextDecorator {
    private static final RelTitleTextDecorator instance = new RelTitleTextDecorator();

    @Override
    public void activate(IGraphicalPart part, IFigure figure) {
        super.activate(part, figure);
    }

    @Override
    public void decorate(IGraphicalPart part, IFigure figure) {
        super.decorate(part, figure);
    }

    @Override
    protected boolean hasTitle(ITitled titled) {
        return super.hasTitle(titled) && !"".equals(titled.getTitleText());
    }

    @Override
    protected String getUntitledText(IGraphicalPart part, ITitled titled) {
        return MindMapMessages.TitleText_Relationship;
    }

    @Override
    protected void decorateTextFigure(IGraphicalPart ownerPart, IStyleSelector ss, ITextFigure figure) {
        super.decorateTextFigure(ownerPart, ss, figure);
        figure.setBackgroundColor(this.getFillColor(ownerPart, ss));
        if (figure instanceof IUseTransparency) {
            ((IUseTransparency)figure).setSubAlpha(this.getAlpha(ownerPart, ss));
        }
    }

    protected Color getFillColor(IGraphicalPart part, IStyleSelector ss) {
        ISheetPart sheet;
        IViewer viewer = part.getSite().getViewer();
        if (viewer != null && (sheet = (ISheetPart)viewer.getAdapter(ISheetPart.class)) != null) {
            IStyleSelector sss = StyleUtils.getStyleSelector(sheet);
            return StyleUtils.getColor(sheet, sss, "svg:fill", null, "#f0f0f0");
        }
        return ColorConstants.white;
    }

    protected int getAlpha(IGraphicalPart part, IStyleSelector ss) {
        return 240;
    }

    @Override
    protected IGraphicalPart getOwnerPart(IGraphicalPart part) {
        if (part.getParent() instanceof IRelationshipPart) {
            return (IRelationshipPart)part.getParent();
        }
        return super.getOwnerPart(part);
    }

    public static RelTitleTextDecorator getInstance() {
        return instance;
    }
}

