/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

public class TreeStructure
extends AbstractBranchStructure {
    private boolean leftwards;
    private ITransformer t = new HorizontalFlipper();

    protected TreeStructure(boolean leftwards) {
        this.leftwards = leftwards;
        this.t.setEnabled(leftwards);
    }

    public boolean isLeftwards() {
        return this.leftwards;
    }

    @Override
    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        int x = ref.x;
        Rectangle topicBounds = info.getCheckedClientArea();
        topicBounds = this.t.tr(topicBounds);
        int y = topicBounds.bottom();
        IFigure pmFigure = plusMinus.getFigure();
        Dimension size = pmFigure.getPreferredSize();
        Rectangle r = new Rectangle(x - size.width / 2, y, size.width, size.height);
        info.put(pmFigure, this.t.r(r));
    }

    @Override
    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        Dimension insSize;
        Rectangle r;
        int majorSpacing = this.getMajorSpacing(branch);
        int minorSpacing = this.getMinorSpacing(branch);
        Point ref = info.getReference();
        this.t.setOrigin(ref);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = this.t.tr(refBounds);
        int x = ref.x + majorSpacing;
        int y = refBounds.bottom() + majorSpacing;
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        int num = subBranches.size();
        int i = 0;
        while (i < num) {
            if (insertion != null && i == insertion.getIndex()) {
                r = insertion.createRectangle(x, y);
                info.add(this.t.rr(r));
                y += r.height + minorSpacing;
            }
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            ins = this.t.ti(ins);
            Dimension size = subBranchFigure.getPreferredSize();
            Rectangle r2 = new Rectangle(x + ins.left, y + ins.top, size.width, size.height);
            info.put(subBranchFigure, this.t.rr(r2));
            y += size.height + ins.getHeight() + minorSpacing;
            ++i;
        }
        if (insertion != null && num == insertion.getIndex() && (insSize = insertion.getSize()) != null) {
            r = new Rectangle(x, y, insSize.width, insSize.height);
            info.add(this.t.rr(r));
        }
    }

    @Override
    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (!branch.getSubBranches().isEmpty() && (this.isLeftwards() ? "navigate_left".equals(navReqType) : "navigate_right".equals(navReqType))) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    @Override
    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_up".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() - 1);
        }
        if ("navigate_down".equals(navReqType)) {
            return this.getSubTopicPart(branch, sourceChild.getBranchIndex() + 1);
        }
        if (!sequential && (this.isLeftwards() ? "navigate_right".equals(navReqType) : "navigate_left".equals(navReqType))) {
            return branch.getTopicPart();
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    @Override
    public int getSourceOrientation(IBranchPart branch) {
        return 4;
    }

    @Override
    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        return this.calcChildTargetOrientation();
    }

    private int calcChildTargetOrientation() {
        if (this.isLeftwards()) {
            return 16;
        }
        return 8;
    }

    @Override
    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        IFigure branchFigure = branch.getFigure();
        IReferencedFigure topicFigure = (IReferencedFigure)branch.getTopicPart().getFigure();
        Point ref = topicFigure.getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Rectangle branchBounds = this.t.tr(branchFigure.getBounds());
        Rectangle topicBounds = this.t.tr(topicFigure.getBounds());
        Rectangle childBounds = this.t.tr(key.getFigure().getBounds());
        int dx = childRef.x - ref.x;
        int dy = childRef.y - topicBounds.bottom();
        if (dy > 0 && childBounds.x >= ref.x) {
            if (childRef.x < branchBounds.right() + 100) {
                return Math.abs(dx) + Math.abs(dy);
            }
            int d = dx * dx + dy * dy;
            return d;
        }
        return super.calcChildDistance(branch, key);
    }

    @Override
    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        IPlusMinusPart plusMinus;
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        ITopicPart topic = branch.getTopicPart();
        if (topic == null) {
            return withDisabled ? 0 : -1;
        }
        IFigure topicFigure = topic.getFigure();
        Point ref = ((IReferencedFigure)topicFigure).getReference();
        this.t.setOrigin(ref);
        Point childRef = this.t.tp(this.getChildRef(branch, ref, key));
        Dimension insSize = this.calcInsSize(key.getFigure());
        int insHeight = insSize.height;
        int minorSpacing = this.getMinorSpacing(branch);
        Rectangle topicBounds = this.t.t(topicFigure.getBounds());
        int y = topicBounds.bottom();
        if (!branch.getSubBranches().isEmpty() && (plusMinus = branch.getPlusMinus()) != null) {
            y += plusMinus.getFigure().getSize().height;
        }
        int ret = this.calcInsIndex(branch, y, childRef, insHeight, minorSpacing, withDisabled);
        return ret;
    }

    private int calcInsIndex(IBranchPart branch, int startY, Point childRef, int insHeight, int spacing, boolean withDisabled) {
        int ret = 0;
        int sum = 0;
        List<IBranchPart> subBranches = branch.getSubBranches();
        int num = subBranches.size();
        for (IBranchPart subBranch : subBranches) {
            IFigure subFigure = subBranch.getFigure();
            int h = this.getBorderedSize((IBranchPart)branch, (IBranchPart)subBranch).height;
            int hint = startY + sum + (insHeight + h + spacing) / 2;
            if (childRef.y < hint) {
                return ret;
            }
            sum += h + spacing;
            if (!withDisabled && !subFigure.isEnabled()) continue;
            ++ret;
        }
        return withDisabled ? num : -1;
    }

    private Dimension calcInsSize(IReferencedFigure child) {
        return child.getSize().scale(0.8);
    }

    @Override
    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        int newIndex = this.calcInsIndex(branch, key, true);
        Dimension newSize = this.calcInsSize(key.getFigure());
        return new Insertion(branch, newIndex, newSize);
    }

    @Override
    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        if (this.leftwards) {
            return 8;
        }
        return 16;
    }

    @Override
    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        return 4;
    }

    @Override
    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 4) {
            return 1;
        }
        if (direction == 1) {
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    @Override
    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        int x = this.getMajorSpacing(branch) + key.getInvent().getSize().width / 2;
        return this.getFigureLocation(branch.getFigure()).getTranslated(this.isLeftwards() ? -x : x, branch.getFigure().getSize().height / 2 + this.getMajorSpacing(branch) + key.getFigure().getSize().height / 2);
    }
}

