/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IDecoratedFigure;
import org.xmind.gef.draw2d.decoration.IDecoration;
import org.xmind.gef.part.IPartListener;
import org.xmind.gef.part.IPartListener2;
import org.xmind.gef.part.PartEvent;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.IRangeListener;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.RangeEvent;

public class TimelineBranchHook
implements IBranchHook,
FigureListener,
IPartListener2,
IRangeListener {
    private IBranchPart branch;

    @Override
    public void hook(IBranchPart branch) {
        this.branch = branch;
        branch.getFigure().addFigureListener((FigureListener)this);
        branch.addPartListener((IPartListener)this);
        for (IBoundaryPart b : branch.getBoundaries()) {
            b.addRangeListener(this);
        }
        for (ISummaryPart s : branch.getSummaries()) {
            s.addRangeListener(this);
        }
    }

    @Override
    public void unhook(IBranchPart branch) {
        for (IBoundaryPart b : branch.getBoundaries()) {
            b.removeRangeListener(this);
        }
        for (ISummaryPart s : branch.getSummaries()) {
            s.removeRangeListener(this);
        }
        branch.removePartListener((IPartListener)this);
        branch.getFigure().removeFigureListener((FigureListener)this);
        this.updateSubBranches(branch);
    }

    private void updateSubBranches(IBranchPart branch) {
        for (IBranchPart subBranch : branch.getSubBranches()) {
            this.flushChildStructureType(subBranch);
            subBranch.treeUpdate(false);
        }
    }

    private void flushChildStructureType(IBranchPart subBranch) {
        subBranch.getBranchPolicy().flushStructureCache(subBranch, false, true);
    }

    @Override
    public void rangeChanged(RangeEvent event) {
        this.updateSubBranches(this.branch);
    }

    public void childAdding(PartEvent event) {
    }

    public void childAdded(PartEvent event) {
        if (event.child instanceof IBranchPart) {
            this.updateSubBranches(this.branch);
        } else if (event.child instanceof ISummaryPart || event.child instanceof IBoundaryPart) {
            this.updateSubBranches(this.branch);
            ((IBranchRangePart)event.child).addRangeListener(this);
        }
    }

    public void childRemoving(PartEvent event) {
    }

    public void childRemoved(PartEvent event) {
        if (event.child instanceof IBranchPart) {
            this.updateSubBranches(this.branch);
        } else if (event.child instanceof ISummaryPart || event.child instanceof IBoundaryPart) {
            this.updateSubBranches(this.branch);
            ((IBranchRangePart)event.child).removeRangeListener(this);
        }
    }

    public void figureMoved(IFigure source) {
        IDecoration decoration = ((IDecoratedFigure)this.branch.getFigure()).getDecoration();
        if (decoration != null) {
            decoration.invalidate();
        }
    }
}

