/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.xmind.core.Core;
import org.xmind.core.io.IOutputTarget;

public class DirectoryOutputTarget
implements IOutputTarget {
    private File dir;
    private Map<String, Long> timeTable = new HashMap<String, Long>();

    public DirectoryOutputTarget(String path) {
        this.dir = new File(path);
    }

    public DirectoryOutputTarget(File file) {
        this.dir = file;
    }

    public OutputStream getEntryStream(String entryName) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            return this.openEntryStream(entryName);
        }
        catch (IOException e) {
            Core.getLogger().log(e, "Failed to get entry output stream for file: " + new File(this.dir, entryName).getPath());
            return null;
        }
    }

    public OutputStream openEntryStream(String entryName) throws IOException {
        File file = new File(this.dir, entryName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new TimedFileOutputStream(entryName, file);
    }

    public boolean isEntryAvaialble(String entryName) {
        return this.isAvailable() && !new File(this.dir, entryName).isDirectory();
    }

    public boolean isAvailable() {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        return this.dir.exists() && this.dir.isDirectory();
    }

    public void setEntryTime(String entryName, long time) {
        this.timeTable.put(entryName, time);
        File f = new File(this.dir, entryName);
        if (f.exists()) {
            f.setLastModified(time);
        }
    }

    private class TimedFileOutputStream
    extends FileOutputStream {
        private String entryName;
        private File file;

        public TimedFileOutputStream(String entryName, File file) throws FileNotFoundException {
            super(file);
            this.entryName = entryName;
            this.file = file;
        }

        public void close() throws IOException {
            super.close();
            Long time = (Long)DirectoryOutputTarget.this.timeTable.remove(this.entryName);
            if (time != null) {
                this.file.setLastModified(time);
            }
        }
    }
}

