/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmind.core.IChecksumStream;
import org.xmind.core.io.InvalidChecksumException;

public class ChecksumVerifiedInputStream
extends FilterInputStream
implements IChecksumStream {
    private String expectedChecksum;

    public ChecksumVerifiedInputStream(InputStream in, String expectedChecksum) {
        super(in);
        this.expectedChecksum = expectedChecksum;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n < 0) {
            this.verifyChecksum();
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        int n = super.read(b);
        if (n < 0) {
            this.verifyChecksum();
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n < 0) {
            this.verifyChecksum();
        }
        return n;
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.verifyChecksum();
        }
    }

    private void verifyChecksum() throws InvalidChecksumException {
        if (!(this.in instanceof IChecksumStream)) {
            return;
        }
        String checksum = ((IChecksumStream)((Object)this.in)).getChecksum();
        if (checksum == this.expectedChecksum || checksum != null && checksum.equals(this.expectedChecksum)) {
            return;
        }
        throw new InvalidChecksumException(this.expectedChecksum, checksum);
    }

    public String getChecksum() {
        if (this.in instanceof IChecksumStream) {
            return ((IChecksumStream)((Object)this.in)).getChecksum();
        }
        return null;
    }
}

