/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xmind.core.CoreException;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.marker.IMarkerSheetBuilder;

public abstract class MarkerSheetBuilder
implements IMarkerSheetBuilder {
    public IMarkerSheet loadFromPath(String path, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        return this.loadFromFile(new File(path), resourceProvider);
    }

    public IMarkerSheet loadFromFile(File file, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        IMarkerSheet iMarkerSheet;
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            iMarkerSheet = this.loadFromStream(stream, resourceProvider);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return iMarkerSheet;
    }

    public IMarkerSheet loadFromURL(URL url, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        IMarkerSheet iMarkerSheet;
        InputStream stream = url.openStream();
        try {
            iMarkerSheet = this.loadFromStream(stream, resourceProvider);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return iMarkerSheet;
    }
}

