/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmind.core.util.IRefCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRefCounter
implements IRefCounter {
    private static final Set<String> NO_RESOURCE_IDS = Collections.emptySet();
    private Map<String, Integer> counts = null;

    @Override
    public Collection<String> getRefs() {
        if (this.counts == null) {
            return NO_RESOURCE_IDS;
        }
        return this.counts.keySet();
    }

    @Override
    public Collection<String> getCountedRefs() {
        if (this.counts == null) {
            return NO_RESOURCE_IDS;
        }
        HashSet<String> list = new HashSet<String>();
        for (Map.Entry<String, Integer> en : this.counts.entrySet()) {
            if (en.getValue() == null || en.getValue() <= 0) continue;
            list.add(en.getKey());
        }
        return list;
    }

    @Override
    public void increaseRef(String resourceId) {
        Integer c;
        Object resource = this.findResource(resourceId);
        if (resource == null) {
            return;
        }
        if (this.counts == null) {
            this.counts = new HashMap<String, Integer>();
        }
        c = (c = this.counts.get(resourceId)) == null ? Integer.valueOf(1) : Integer.valueOf(c + 1);
        this.counts.put(resourceId, c);
        this.postIncreaseRef(resourceId, resource);
    }

    @Override
    public void decreaseRef(String resourceId) {
        if (this.counts == null) {
            return;
        }
        Object resource = this.findResource(resourceId);
        if (resource == null) {
            return;
        }
        Integer c = this.counts.get(resourceId);
        if (c == null || c <= 0) {
            return;
        }
        this.counts.put(resourceId, c - 1);
        this.postDecreaseRef(resourceId, resource);
    }

    @Override
    public int getRefCount(String resourceId) {
        if (this.counts == null) {
            return 0;
        }
        Integer c = this.counts.get(resourceId);
        if (c == null) {
            return 0;
        }
        return c;
    }

    protected abstract Object findResource(String var1);

    protected abstract void postIncreaseRef(String var1, Object var2);

    protected abstract void postDecreaseRef(String var1, Object var2);
}

