/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class SlantedLiner
implements Liner,
DOMStorable {
    private double slantSize;

    public SlantedLiner() {
        this(20.0);
    }

    public SlantedLiner(double slantSize) {
        this.slantSize = slantSize;
    }

    @Override
    public Collection<Handle> createHandles(BezierPath path) {
        return null;
    }

    @Override
    public void lineout(ConnectionFigure figure) {
        int eoutcode;
        int soutcode;
        Rectangle2D.Double eb;
        Rectangle2D.Double sb;
        Point2D.Double ep;
        Point2D.Double sp;
        BezierPath path = ((LineConnectionFigure)figure).getBezierPath();
        Connector start = figure.getStartConnector();
        Connector end = figure.getEndConnector();
        if (start == null || end == null || path == null) {
            return;
        }
        if (figure.getStartFigure() == figure.getEndFigure()) {
            while (path.size() < 5) {
                path.add(1, new BezierPath.Node(0.0, 0.0));
            }
            while (path.size() > 5) {
                path.remove(1);
            }
            sp = start.findStart(figure);
            ep = end.findEnd(figure);
            sb = start.getBounds();
            eb = end.getBounds();
            soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = Geom.outcode(sb, eb);
            }
            if ((eoutcode = eb.outcode(ep)) == 0) {
                eoutcode = Geom.outcode(sb, eb);
            }
            ((BezierPath.Node)path.get(0)).moveTo(sp);
            ((BezierPath.Node)path.get(path.size() - 1)).moveTo(ep);
            switch (soutcode) {
                case 2: {
                    eoutcode = 1;
                    break;
                }
                case 4: {
                    eoutcode = 2;
                    break;
                }
                case 8: {
                    eoutcode = 4;
                    break;
                }
                case 1: {
                    eoutcode = 8;
                    break;
                }
                default: {
                    eoutcode = 2;
                    soutcode = 4;
                }
            }
            ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.slantSize, sp.y);
            if ((soutcode & 4) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.slantSize, sp.y);
            } else if ((soutcode & 1) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x - this.slantSize, sp.y);
            } else if ((soutcode & 8) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y + this.slantSize);
            } else {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y - this.slantSize);
            }
            if ((eoutcode & 4) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x + this.slantSize, ep.y);
            } else if ((eoutcode & 1) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x - this.slantSize, ep.y);
            } else if ((eoutcode & 8) != 0) {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x, ep.y + this.slantSize);
            } else {
                ((BezierPath.Node)path.get(3)).moveTo(ep.x, ep.y - this.slantSize);
            }
            switch (soutcode) {
                case 4: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).x[0], ((BezierPath.Node)path.get((int)3)).y[0]);
                    break;
                }
                case 2: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).y[0], ((BezierPath.Node)path.get((int)3)).x[0]);
                    break;
                }
                case 1: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).x[0], ((BezierPath.Node)path.get((int)3)).y[0]);
                    break;
                }
                default: {
                    ((BezierPath.Node)path.get(2)).moveTo(((BezierPath.Node)path.get((int)1)).y[0], ((BezierPath.Node)path.get((int)3)).x[0]);
                    break;
                }
            }
        } else {
            while (path.size() < 4) {
                path.add(1, new BezierPath.Node(0.0, 0.0));
            }
            while (path.size() > 4) {
                path.remove(1);
            }
            sp = start.findStart(figure);
            ep = end.findEnd(figure);
            sb = start.getBounds();
            eb = end.getBounds();
            soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = sp.x <= sb.x ? 1 : (sp.y <= sb.y ? 2 : (sp.x >= sb.x + sb.width ? 4 : (sp.y >= sb.y + sb.height ? 8 : Geom.outcode(sb, eb))));
            }
            if ((eoutcode = eb.outcode(ep)) == 0) {
                eoutcode = ep.x <= eb.x ? 1 : (ep.y <= eb.y ? 2 : (ep.x >= eb.x + eb.width ? 4 : (ep.y >= eb.y + eb.height ? 8 : Geom.outcode(sb, eb))));
            }
            ((BezierPath.Node)path.get(0)).moveTo(sp);
            ((BezierPath.Node)path.get(path.size() - 1)).moveTo(ep);
            if ((soutcode & 4) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x + this.slantSize, sp.y);
            } else if ((soutcode & 1) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x - this.slantSize, sp.y);
            } else if ((soutcode & 8) != 0) {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y + this.slantSize);
            } else {
                ((BezierPath.Node)path.get(1)).moveTo(sp.x, sp.y - this.slantSize);
            }
            if ((eoutcode & 4) != 0) {
                ((BezierPath.Node)path.get(2)).moveTo(ep.x + this.slantSize, ep.y);
            } else if ((eoutcode & 1) != 0) {
                ((BezierPath.Node)path.get(2)).moveTo(ep.x - this.slantSize, ep.y);
            } else if ((eoutcode & 8) != 0) {
                ((BezierPath.Node)path.get(2)).moveTo(ep.x, ep.y + this.slantSize);
            } else {
                ((BezierPath.Node)path.get(2)).moveTo(ep.x, ep.y - this.slantSize);
            }
        }
        for (BezierPath.Node node : path) {
            node.setMask(0);
        }
        path.invalidatePath();
    }

    @Override
    public void read(DOMInput in) {
        this.slantSize = in.getAttribute("slant", 20.0);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("slant", this.slantSize);
    }

    @Override
    public Liner clone() {
        try {
            return (Liner)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }
}

