/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.engine;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.engine.Subject;
import org.yccheok.jstock.trading.api.UserManager;

public class AjaxDWUsernameAvailabilityMonitor
extends Subject<AjaxDWUsernameAvailabilityMonitor, Pair<String, Boolean>> {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BlockingQueue<String> blockingQueue = new ArrayBlockingQueue<String>(128);
    private static final Log log = LogFactory.getLog(AjaxDWUsernameAvailabilityMonitor.class);

    public AjaxDWUsernameAvailabilityMonitor() {
        this.executor.submit(new SearchTask());
    }

    public synchronized void clearAndPut(String string) {
        if (this.executor.isShutdown()) {
            throw new RuntimeException("Executor is shutdown.");
        }
        this.blockingQueue.clear();
        try {
            this.blockingQueue.put(string);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    public void stop() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(100L, TimeUnit.DAYS);
        }
        catch (InterruptedException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private class SearchTask
    implements Runnable {
        private SearchTask() {
        }

        @Override
        public void run() {
            while (!AjaxDWUsernameAvailabilityMonitor.this.executor.isShutdown()) {
                try {
                    String string = (String)AjaxDWUsernameAvailabilityMonitor.this.blockingQueue.take();
                    if (string == null || string.isEmpty()) continue;
                    Boolean available = UserManager.checkUsernameAvailability(string);
                    Pair<String, Boolean> resultPair = new Pair<String, Boolean>(string, available);
                    AjaxDWUsernameAvailabilityMonitor.this.notify(AjaxDWUsernameAvailabilityMonitor.this, resultPair);
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                    break;
                }
            }
        }
    }
}

