/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.trading.api;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.Http;
import org.yccheok.jstock.trading.api.HttpRespond;
import org.yccheok.jstock.trading.api.SessionManager;

public final class DriveWealth {
    private static final Log log = LogFactory.getLog(DriveWealth.class);
    private static final Gson gson = new Gson();
    public static final boolean isProduction = true;
    public static final boolean isTesting = false;
    public static final Config config = new Config();
    public static final String jstockDriveWealthURL = "https://drivewealth.com/app-support/";
    public static final String helpURL = "http://help.drivewealth.com/";
    public static final String finraURL = "http://brokercheck.finra.org/Firm/Summary/165429";
    public static final String spicURL = "http://sipc.org/";
    public static final String tncURL = "https://drivewealth.com/terms-of-use";
    public static final String privacyURL = "https://drivewealth.com/privacy-policy";
    public static final String disclaimerURL = "https://drivewealth.com/disclosures-disclaimers?lang=en_US";
    static final List<String> accountFields = new ArrayList<String>(Arrays.asList("accountID", "accountNo", "userID", "currencyID", "accountType", "cash", "freeTradeBalance", "goodFaithViolations", "interestFree", "orders", "patternDayTrades", "positions", "status", "tradingType", "bodMoneyMarket", "bodEquityValue", "bodCashAvailForWith", "bodCashAvailForTrading", "rtCashAvailForTrading", "rtCashAvailForWith", "accountMgmtType", "longOnly"));
    static final List<String> userFields = new ArrayList<String>(Arrays.asList("emailAddress1", "firstName", "lastName", "username", "password", "languageID", "tranAmount", "referralCode", "wlpID", "utm_campaign", "utm_content", "utm_medium", "utm_source", "utm_term"));
    static final List<String> getSessionFields = new ArrayList<String>(Arrays.asList("appTypeID", "appVersion", "commissionRate", "heartbeatWhen", "ipAddress", "loginState", "languageID", "loginWhen", "osType", "osVersion", "referralCode", "scrRes", "sessionKey", "userID", "wlpID", "accounts", "instruments"));
    static final List<String> getInstrumentFields = new ArrayList<String>(Arrays.asList("name", "instrumentID", "currencyID", "description", "exchangeID", "orderSizeMax", "orderSizeMin", "orderSizeStep", "rateAsk", "rateBid", "symbol", "tags", "tradeStatus", "tradingHours", "urlImage", "urlInvestor", "fundamentalDataModel", "sector", "longOnly", "instrumentTypeID", "ratePrecision", "lastTrade"));
    static final List<String> settingFields = new ArrayList<String>(Arrays.asList("userID", "key", "value"));
    static final List<String> chartFields = new ArrayList<String>(Arrays.asList("instrumentID", "compression", "dateStart", "dateEnd", "tradingDay"));
    static final List<String> financialTxnFields = new ArrayList<String>(Arrays.asList("accountAmount", "accountBalance", "comment", "currencyID", "finTranID", "finTranTypeID", "orderID", "orderNo", "systemAmount", "tranAmount", "tranWhen", "wlpAmount", "execID", "dnb"));
    static final List<String> orderTxnFields = new ArrayList<String>(Arrays.asList("orderNo", "transactTime", "execType", "ordStatus", "ordType", "side", "symbol", "lastShares", "lastPx", "cumQty", "leavesQty"));
    static final List<String> openPosFields = new ArrayList<String>(Arrays.asList("costBasis", "initQty", "side", "openQty", "instrument", "price", "mtm", "mtmPL"));
    static final List<String> stockFields = new ArrayList<String>(Arrays.asList("instrument", "instrumentTypeDescr", "tradeStatusDescr", "tagDescr", "linkable10K"));
    static final List<String> stockInstrumentFields = new ArrayList<String>(Arrays.asList("currencyID", "instrumentID", "limitStatus", "instrumentTypeID", "marginCurrencyID", "name", "orderSizeMax", "orderSizeMin", "orderSizeStep", "symbol", "tradeStatus", "urlInvestor", "priorClose", "marketState", "minTic", "pipMultiplier", "rebateSpread"));
    static final List<String> listStatementFields = new ArrayList<String>(Arrays.asList("displayName", "fileKey"));
    static final List<String> getStatementFields = new ArrayList<String>(Arrays.asList("accountID", "url"));

    public static String disclosuresURL(String citizen, String country, String ownershipType, boolean taxOnly) {
        Locale jstockLocale = Locale.getDefault();
        String jstockLang = jstockLocale.getLanguage();
        String jstockCountry = jstockLocale.getCountry();
        String lang = "en_US";
        if (jstockLang.equals("zh") && !jstockCountry.equals("TW")) {
            lang = "zh_CN";
        }
        String url = DriveWealth.config.baseURL + "disclosures/?lang=" + lang + "&citizenship=" + citizen + "&country=" + country + "&accountType=" + ownershipType;
        if (taxOnly) {
            url = url + "&showOnlyTaxDoc=True";
        }
        return url;
    }

    public static String fundsInURL() {
        String url = DriveWealth.config.baseURL + "funding?lang=en_US&sessionKey=" + SessionManager.getInstance().getSessionKey() + "&userID=" + SessionManager.getInstance().getUser().userID;
        return url;
    }

    private DriveWealth() {
    }

    public static Map<String, Object> getAccount(String userID, String accountID) {
        HttpRespond respond = Http.get("users/" + userID + "/accounts/" + accountID, DriveWealth.getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)gson.fromJson(body, HashMap.class);
        return result;
    }

    public static Map<String, Object> createUser(Map<String, String> args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String k : userFields) {
            if (k.equals("tranAmount") || !args.containsKey(k)) continue;
            String v = args.get(k);
            params.put(k, v);
        }
        HttpRespond respond = Http.post("signups/live", params, null);
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        Map result = (Map)gson.fromJson(body, HashMap.class);
        if (statusCode != 200) {
            ApiError error = ApiError.getError(result);
            log.error((Object)("Create User error, code: " + error.code + ", message: " + error.message));
            return null;
        }
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("password", result.get("password").toString());
        userMap.put("userID", result.get("userID").toString());
        userMap.put("username", result.get("username").toString());
        return userMap;
    }

    public static Map<String, Object> getInstrument(String instrumentID) {
        HttpRespond respond = Http.get("instruments/" + instrumentID + "?options=F", DriveWealth.getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)gson.fromJson(body, HashMap.class);
        return result;
    }

    public static List<String[]> getCharts(ChartCompression chartCompression, Map<String, Object> args) {
        int compression = chartCompression.getValue();
        String instrumentID = args.get("instrumentID").toString();
        String url = "bars?instrumentID=" + instrumentID + "&compression=" + compression;
        if (args.containsKey("dateStart") && args.containsKey("dateEnd")) {
            String dateStart = args.get("dateStart").toString();
            String dateEnd = args.get("dateEnd").toString();
            url = url + "&dateStart=" + dateStart + "&dateEnd=" + dateEnd;
        } else if (args.containsKey("tradingDays")) {
            url = url + "&tradingDays=" + args.get("tradingDays").toString();
        }
        log.info((Object)("\n url: " + url));
        HttpRespond respond = Http.get(url, DriveWealth.getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)gson.fromJson(body, HashMap.class);
        ArrayList<String[]> data = new ArrayList<String[]>();
        if (result.get("instrumentID").toString().equals(instrumentID) && (Integer)result.get("compression") == compression) {
            String line = result.get("data").toString();
            log.info((Object)("data: " + line));
            String[] items = line.split("\\|");
            for (int i = 0; i < items.length; ++i) {
                String[] ohlc = items[i].split(",");
                data.add(ohlc);
            }
        }
        return data;
    }

    public static List<Map<String, Object>> transactionReport(ReportName reportName, Map<String, String> args) {
        Map result;
        List<String> txnFields;
        String AccountNumber = args.get("AccountNumber");
        String DateStart = "";
        String DateEnd = "";
        String symbol = "";
        switch (reportName) {
            case FIN_TRANS: {
                DateStart = "&DateStart=" + args.get("DateStart");
                DateEnd = "&DateEnd=" + args.get("DateEnd");
                txnFields = financialTxnFields;
                break;
            }
            case ORDER_TRANS: {
                DateStart = "&DateStart=" + args.get("DateStart");
                DateEnd = "&DateEnd=" + args.get("DateEnd");
                if (args.containsKey("symbol")) {
                    symbol = "&symbol=" + args.get("symbol");
                }
                txnFields = orderTxnFields;
                break;
            }
            case POSITION_RESTING_ORDER: {
                txnFields = openPosFields;
                break;
            }
            default: {
                log.warn((Object)("Unsupported reportType: " + reportName.value));
                return null;
            }
        }
        String url = "DriveWealth?ReportFormat=JSON&wlpID=DW&LanguageID=en_US&ReportName=" + reportName.value + "&sessionKey=" + DriveWealth.getSessionKey() + "&AccountNumber=" + AccountNumber + DateStart + DateEnd + symbol;
        log.info((Object)("URL: " + url));
        HashMap<String, Object> params = new HashMap<String, Object>();
        HttpRespond respond = Http.post(url, params, DriveWealth.getSessionKey(), "reportServer");
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            log.error((Object)("Transaction Report Error, code: " + statusCode));
            return null;
        }
        try {
            result = (Map)gson.fromJson(body, HashMap.class);
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        String accountNo = result.get("accountNo").toString();
        String accountID = result.get("accountID").toString();
        String dateRange = null;
        String accountType = null;
        if (result.containsKey("accountType")) {
            accountType = result.get("accountType").toString();
        }
        if (result.containsKey("dateRange")) {
            dateRange = result.get("dateRange").toString();
        }
        log.info((Object)("accountNo: " + accountNo + ", accountID: " + accountID + ", accountType: " + accountType + ", dateRange: " + dateRange));
        ArrayList resultTxn = reportName == ReportName.POSITION_RESTING_ORDER ? (ArrayList)result.get("positions") : (ArrayList)result.get("transaction");
        ArrayList<Map<String, Object>> txns = new ArrayList<Map<String, Object>>();
        int cnt = 0;
        for (Map a : resultTxn) {
            log.info((Object)("txn :" + cnt++));
            HashMap txn = new HashMap();
            for (String k : txnFields) {
                if (!a.containsKey(k)) continue;
                Object v = a.get(k);
                txn.put(k, v);
                log.info((Object)("key: " + k + ", value: " + v));
            }
            txns.add(txn);
        }
        return txns;
    }

    public static List<Map<String, Object>> stocksReport(Map<String, String> args) {
        ArrayList result;
        String url = "DriveWealth?ReportFormat=JSON&wlpID=DW&LanguageID=en_US&ReportName=" + ReportName.INSTRUMENT.value + "&sessionKey=" + DriveWealth.getSessionKey() + "&AccountNumber=" + args.get("AccountNumber") + "&DateStart=" + args.get("DateStart") + "&DateEnd=" + args.get("DateEnd") + "&TradeStatus=-1&InstrumentType=-1";
        log.info((Object)("URL: " + url));
        HashMap<String, Object> params = new HashMap<String, Object>();
        HttpRespond respond = Http.post(url, params, DriveWealth.getSessionKey(), "reportServer");
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            log.error((Object)("Stocks Report Error, code: " + statusCode));
            return null;
        }
        try {
            result = (ArrayList)((HashMap)gson.fromJson(body, HashMap.class)).get("instruments");
        }
        catch (JsonSyntaxException ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
        ArrayList<Map<String, Object>> stocks = new ArrayList<Map<String, Object>>();
        int cnt = 0;
        for (Map a : result) {
            log.info((Object)("Stock :" + cnt++));
            HashMap stock = new HashMap();
            for (String k : stockFields) {
                if (!a.containsKey(k)) continue;
                Object v = a.get(k);
                stock.put(k, v);
                log.info((Object)("key: " + k + ", value: " + v));
            }
            Map ins = (Map)stock.get("instrument");
            HashMap instrument = new HashMap();
            for (String k : stockInstrumentFields) {
                if (!ins.containsKey(k)) continue;
                Object v = ins.get(k);
                instrument.put(k, v);
                log.info((Object)("key: " + k + ", value: " + v));
            }
            stock.put("instrument", instrument);
            stocks.add(stock);
        }
        return stocks;
    }

    public static List<Map<String, Object>> listStatements(String type, Map<String, String> args) {
        switch (type) {
            case "trade": {
                type = "01";
                break;
            }
            case "statement": {
                type = "02";
                break;
            }
            case "doc": {
                type = "03";
                break;
            }
            default: {
                log.warn((Object)("Unknown listStatements - type: " + type));
                return null;
            }
        }
        String url = "statements?accountID=" + args.get("accountID") + "&startDate=" + args.get("startDate") + "&endDate=" + args.get("endDate") + "&type=" + type;
        log.info((Object)("URL: " + url));
        HttpRespond respond = Http.get(url, DriveWealth.getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        List result = (List)gson.fromJson(body, ArrayList.class);
        ArrayList<Map<String, Object>> statements = new ArrayList<Map<String, Object>>();
        for (Map a : result) {
            HashMap statement = new HashMap();
            for (String k : listStatementFields) {
                if (!a.containsKey(k)) continue;
                Object v = a.get(k);
                statement.put(k, v);
                log.info((Object)("key: " + k + ", value: " + v));
            }
            statements.add(statement);
        }
        return statements;
    }

    public static Map<String, Object> getStatement(String accountID, String fileKey) {
        String url = "statements/" + accountID + "/" + fileKey;
        log.info((Object)("URL: " + url));
        HttpRespond respond = Http.get(url, DriveWealth.getSessionKey());
        if (respond == null) {
            return null;
        }
        int statusCode = respond.statusCode;
        String body = respond.body;
        if (statusCode != 200) {
            return null;
        }
        Map result = (Map)gson.fromJson(body, HashMap.class);
        HashMap<String, Object> statement = new HashMap<String, Object>();
        for (String k : getStatementFields) {
            if (!result.containsKey(k)) continue;
            Object v = result.get(k);
            statement.put(k, v);
            log.info((Object)("key: " + k + ", value: " + v));
        }
        return statement;
    }

    public static String getSessionKey() {
        return SessionManager.getInstance().getSessionKey();
    }

    public static enum ReportName {
        FIN_TRANS("FinTrans"),
        ORDER_TRANS("OrderTrans"),
        POSITION_RESTING_ORDER("PositionRestingOrder"),
        INSTRUMENT("Instrument"),
        REFERRAL_SUMMARY_PERFORMANCE("ReferralSummaryPerformance");

        public final String value;

        private ReportName(String value) {
            this.value = value;
        }
    }

    public static enum ChartCompression {
        DAILY(0),
        ONE_MINUTE(1),
        FIVE_MINUTE(4),
        THIRTY_MINUTE(8),
        ONE_HOUR(9),
        WEEKLY(10);

        private final int value;

        private ChartCompression(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class Config {
        public final String apiURL;
        public final String reportURL;
        public final String baseURL;
        public final String referralCode;

        public Config() {
            this.apiURL = "https://api.drivewealth.net/v1/";
            this.reportURL = "https://reports.drivewealth.net/";
            this.baseURL = "https://apps.drivewealth.com/";
            this.referralCode = "E5B59B";
        }
    }
}

