/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.nachocalendar.table.DateFieldTableEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.StockTableModel;
import org.yccheok.jstock.gui.table.DateRendererDecoratorEx;
import org.yccheok.jstock.internationalization.GUIBundle;

public class JTableUtilities {
    private static final Log log = LogFactory.getLog(JTableUtilities.class);
    private static final Map<Locale, Map<String, List<String>>> string2KeyMap = new HashMap<Locale, Map<String, List<String>>>();

    private JTableUtilities() {
    }

    public static void makeTableColumnWidthFit(JTable jTable, int col, int margin) {
        JTableUtilities.makeTableColumnWidthFit(jTable, col, margin, false);
    }

    public static void makeTableColumnWidthFit(JTable jTable, int col, int margin, boolean locking) {
        TableColumnModel columnModel = jTable.getColumnModel();
        int maxwidth = 0;
        for (int row = 0; row < jTable.getRowCount(); ++row) {
            TableCellRenderer rend = jTable.getCellRenderer(row, col);
            Object value = jTable.getValueAt(row, col);
            Component comp = rend.getTableCellRendererComponent(jTable, value, false, false, row, col);
            maxwidth = Math.max(comp.getPreferredSize().width + margin, maxwidth);
        }
        TableColumn column = columnModel.getColumn(col);
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        Object headerValue = column.getHeaderValue();
        Component headerComp = headerRenderer.getTableCellRendererComponent(jTable, headerValue, false, false, 0, col);
        maxwidth = Math.max(maxwidth, headerComp.getPreferredSize().width + margin);
        column.setPreferredWidth(maxwidth);
        if (locking) {
            column.setMinWidth(maxwidth);
            column.setMaxWidth(maxwidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJTableOptions(JTable jTable, GUIOptions.JTableOptions jTableOptions) {
        if (jTableOptions.getColumnSize() <= 0) {
            return;
        }
        Locale locale = jTableOptions.getLocale();
        boolean first_column_hacking_required = false;
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            String name = jTable.getColumnName(i);
            List<String> keys = JTableUtilities.getKeys(name, Locale.getDefault());
            Locale oldLocale = Locale.getDefault();
            Locale.setDefault(locale);
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", locale);
                Locale.setDefault(oldLocale);
                boolean found = false;
                for (String key : keys) {
                    String translated_name = bundle.getString(key);
                    if (!jTableOptions.contains(translated_name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (i > 0) {
                    JTableUtilities.removeTableColumn(jTable, name);
                    --i;
                    continue;
                }
                first_column_hacking_required = true;
                continue;
            }
            finally {
                Locale.setDefault(oldLocale);
            }
        }
        int optionsCount = jTableOptions.getColumnSize();
        int tableCount = jTable.getColumnCount();
        int target = first_column_hacking_required ? 1 : 0;
        for (int i = 0; i < optionsCount; ++i) {
            String name = jTableOptions.getColumnName(i);
            List<String> keys = JTableUtilities.getKeys(name, locale);
            assert (keys != null);
            int index = -1;
            for (int j = 0; j < tableCount; ++j) {
                boolean found = false;
                String translated_name = null;
                for (String key : keys) {
                    translated_name = GUIBundle.getString(key);
                    if (!jTable.getColumnName(j).equals(translated_name)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                jTable.getColumn(translated_name).setPreferredWidth(jTableOptions.getColumnWidth(i));
                index = j;
                break;
            }
            if (index < 0) continue;
            jTable.moveColumn(index, target++);
        }
    }

    public static void removeTableColumn(JTable jTable, Object identifier) {
        TableColumn tableColumn = null;
        try {
            tableColumn = jTable.getColumn(identifier);
        }
        catch (IllegalArgumentException ex) {
            log.error(null, (Throwable)ex);
        }
        if (tableColumn != null) {
            jTable.removeColumn(tableColumn);
        }
    }

    public static void insertTableColumnFromModel(JTable jTable, Object value, int clickedColumnIndex) {
        boolean isVisible = true;
        try {
            TableColumn tableColumn = jTable.getColumn(value);
        }
        catch (IllegalArgumentException exp) {
            isVisible = false;
        }
        if (isVisible) {
            return;
        }
        TableModel tableModel = jTable.getModel();
        int modelIndex = JTableUtilities.getModelColumnIndex(jTable, value);
        Class<?> c = tableModel.getColumnClass(modelIndex);
        TableColumn tableColumn = new TableColumn(modelIndex, 0, jTable.getDefaultRenderer(c), jTable.getDefaultEditor(c));
        jTable.addColumn(tableColumn);
        JTableUtilities.makeTableColumnWidthFit(jTable, jTable.getColumnCount() - 1, 5);
        if (clickedColumnIndex < 0) {
            jTable.moveColumn(jTable.getColumnCount() - 1, jTable.getColumnCount() - 1);
        } else {
            jTable.moveColumn(jTable.getColumnCount() - 1, Math.min(jTable.getColumnCount() - 1, clickedColumnIndex + 1));
        }
    }

    public static int getModelColumnIndex(JTable jTable, Object value) {
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof StockTableModel) {
            return ((StockTableModel)tableModel).findColumn(value.toString());
        }
        try {
            TableColumn tableColumn = jTable.getColumn(value);
            return tableColumn.getModelIndex();
        }
        catch (IllegalArgumentException exp) {
            int columnCount = tableModel.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                String s = tableModel.getColumnName(col);
                if (!s.equals(value)) continue;
                return col;
            }
            return -1;
        }
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    public static void setDateEditorAndRendererForRow(JTable table, int row) {
        TableColumn column = table.getColumnModel().getColumn(row);
        column.setCellEditor((TableCellEditor)new DateFieldTableEditor());
        DateFormat format = DateFormat.getDateInstance(3);
        column.setCellRenderer((TableCellRenderer)((Object)new DateRendererDecoratorEx(column.getCellRenderer(), format)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getKeys(String string, Locale locale) {
        if (string2KeyMap.containsKey(locale)) {
            Map<String, List<String>> string2Key = string2KeyMap.get(locale);
            List<String> result = string2Key.get(string);
            if (result == null) {
                return Collections.EMPTY_LIST;
            }
            return result;
        }
        HashMap<String, ArrayList<String>> string2Key = new HashMap<String, ArrayList<String>>();
        Locale oldLocale = Locale.getDefault();
        Locale.setDefault(locale);
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.yccheok.jstock.data.gui", locale);
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                String str = bundle.getString(key);
                ArrayList<String> list = (ArrayList<String>)string2Key.get(str);
                if (list == null) {
                    list = new ArrayList<String>();
                    string2Key.put(str, list);
                }
                list.add(key);
            }
            string2KeyMap.put(locale, string2Key);
        }
        finally {
            Locale.setDefault(oldLocale);
        }
        List result = (List)string2Key.get(string);
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }
}

