/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.IEXDividendServer;
import org.yccheok.jstock.engine.IEXStockHistoryServer;
import org.yccheok.jstock.engine.IEXStockServer;
import org.yccheok.jstock.engine.Period;
import org.yccheok.jstock.engine.StockHistoryNotFoundException;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;

public class IEXStockServerFactory
implements StockServerFactory {
    private final IEXStockServer iexStockServer = new IEXStockServer();
    private final IEXDividendServer iexDividendServer = new IEXDividendServer();
    private static final String TAG = IEXStockServerFactory.class.getSimpleName();
    private static final Log log = LogFactory.getLog(IEXStockServerFactory.class);

    @Override
    public char getId() {
        return 'e';
    }

    private IEXStockServerFactory() {
    }

    public static StockServerFactory newInstance() {
        return new IEXStockServerFactory();
    }

    @Override
    public StockServer getStockServer() {
        return this.iexStockServer;
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code) {
        try {
            return new IEXStockHistoryServer(code);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Duration duration) {
        try {
            return new IEXStockHistoryServer(code, duration);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public StockHistoryServer getStockHistoryServer(Code code, Period period) {
        try {
            return new IEXStockHistoryServer(code, period);
        }
        catch (StockHistoryNotFoundException exp) {
            log.error(null, (Throwable)exp);
            return null;
        }
    }

    @Override
    public DividendServer getDividendServer() {
        return this.iexDividendServer;
    }
}

