/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.analysis;

import com.tictactec.ta.lib.Core;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.AbstractOperator;
import org.yccheok.jstock.analysis.Utils;
import org.yccheok.jstock.charting.TechnicalAnalysis;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryServer;

public class StockHistoryOperator
extends AbstractOperator {
    private Date startDate;
    private Date endDate;
    private Object value;
    private Function function;
    private Type type;
    private static final Log log = LogFactory.getLog(StockHistoryOperator.class);

    public StockHistoryOperator() {
        this.setStartDate(new Date());
        this.setEndDate(new Date());
        this.value = null;
        this.function = Function.Max;
        this.type = Type.OpenPrice;
    }

    @Override
    protected Object calculate() {
        return this.value;
    }

    private double average(List<Double> values) {
        int size = values.size();
        assert (size >= 0);
        double sum = 0.0;
        for (Double v : values) {
            sum += v.doubleValue();
        }
        return sum / (double)size;
    }

    public int getRequiredHistorySize(int day) {
        if (this.function == Function.EMA) {
            Core core = new Core();
            int lookback = core.emaLookback(day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.RSI) {
            Core core = new Core();
            int lookback = core.rsiLookback(day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MFI) {
            Core core = new Core();
            int lookback = core.mfiLookback(day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACD) {
            Core core = new Core();
            int lookback = core.macdFixLookback(day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACDSignal) {
            Core core = new Core();
            int lookback = core.macdFixLookback(day);
            return lookback + 1 << 2;
        }
        if (this.function == Function.MACDHist) {
            Core core = new Core();
            int lookback = core.macdFixLookback(day);
            return lookback + 1 << 2;
        }
        return day;
    }

    public void calculate(StockHistoryServer stockHistoryServer) {
        boolean valid = true;
        if (this.startDate != null && this.endDate != null) {
            if (this.startDate.after(this.endDate)) {
                valid = false;
                log.error((Object)("startDate " + this.startDate + " should not after endDate " + this.endDate));
            }
        } else {
            log.error((Object)"startDate or endDate cannot be null");
            valid = false;
        }
        if (!valid) {
            Object oldValue = this.value;
            this.value = null;
            if (!Utils.equals(oldValue, this.value)) {
                this.firePropertyChange("value", oldValue, this.value);
            }
            return;
        }
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        ArrayList<Stock> tmpStocks = new ArrayList<Stock>();
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<Double> highs = new ArrayList<Double>();
        ArrayList<Double> lows = new ArrayList<Double>();
        ArrayList<Double> closes = new ArrayList<Double>();
        ArrayList<Long> volumes = new ArrayList<Long>();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(this.startDate);
        endCalendar.setTime(this.endDate);
        org.yccheok.jstock.engine.Utils.resetCalendarTime(startCalendar);
        org.yccheok.jstock.engine.Utils.resetCalendarTime(endCalendar);
        int day = 0;
        while (true) {
            long startTimestamp;
            Stock stock;
            if ((stock = stockHistoryServer.getStock(startTimestamp = startCalendar.getTimeInMillis())) != null) {
                tmpStocks.add(stock);
                ++day;
            }
            if (startCalendar.get(1) == endCalendar.get(1) && startCalendar.get(2) == endCalendar.get(2) && startCalendar.get(5) == endCalendar.get(5)) break;
            startCalendar.add(5, 1);
        }
        if (day == 0) {
            Object oldValue = this.value;
            this.value = null;
            if (!Utils.equals(oldValue, this.value)) {
                this.firePropertyChange("value", oldValue, this.value);
            }
            return;
        }
        startCalendar.setTime(this.startDate);
        org.yccheok.jstock.engine.Utils.resetCalendarTime(startCalendar);
        int remainingHistorySize = Math.max(0, this.getRequiredHistorySize(day) - day);
        long oldestHistoryTimestamp = stockHistoryServer.getTimestamp(0);
        Calendar oldestHistoryCalendar = Calendar.getInstance();
        oldestHistoryCalendar.setTimeInMillis(oldestHistoryTimestamp);
        while (remainingHistorySize > 0) {
            startCalendar.add(5, -1);
            if (startCalendar.before(oldestHistoryCalendar)) break;
            long startTimestamp = startCalendar.getTimeInMillis();
            Stock stock = stockHistoryServer.getStock(startTimestamp);
            if (stock == null) continue;
            stocks.add(stock);
            --remainingHistorySize;
        }
        Collections.reverse(stocks);
        stocks.addAll(tmpStocks);
        if (this.function == Function.MFI) {
            for (Stock stock : stocks) {
                values.add(TechnicalAnalysis.getTypicalPrice(stock));
                highs.add(stock.getHighPrice());
                lows.add(stock.getLowPrice());
                closes.add(stock.getLastPrice());
                volumes.add(stock.getVolume());
            }
        } else {
            switch (this.type) {
                case PrevPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getPrevPrice());
                    }
                    break;
                }
                case OpenPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getOpenPrice());
                    }
                    break;
                }
                case HighPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getHighPrice());
                    }
                    break;
                }
                case LowPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getLowPrice());
                    }
                    break;
                }
                case LastPrice: {
                    for (Stock stock : stocks) {
                        values.add(stock.getLastPrice());
                    }
                    break;
                }
                case TypicalPrice: {
                    for (Stock stock : stocks) {
                        values.add(TechnicalAnalysis.getTypicalPrice(stock));
                    }
                    break;
                }
                case Volume: {
                    for (Stock stock : stocks) {
                        values.add(new Double(stock.getVolume()));
                    }
                    break;
                }
                case MarketCapital: {
                    values.add(new Double(stockHistoryServer.getMarketCapital()));
                    break;
                }
                case SharesIssued: {
                    values.add(new Double(stockHistoryServer.getSharesIssued()));
                    break;
                }
                default: {
                    if ($assertionsDisabled) break;
                    throw new AssertionError();
                }
            }
        }
        int dataSize = values.size();
        if (dataSize == 0) {
            Object oldValue = this.value;
            this.value = null;
            if (!Utils.equals(oldValue, this.value)) {
                this.firePropertyChange("value", oldValue, this.value);
            }
            return;
        }
        Double v = this.function == Function.Min ? Double.MAX_VALUE : 0.0;
        double tmp_v = v;
        switch (this.function) {
            case Max: {
                for (Double _value : values) {
                    tmp_v = Math.max(tmp_v, _value);
                }
                v = tmp_v;
                break;
            }
            case Min: {
                for (Double _value : values) {
                    tmp_v = Math.min(tmp_v, _value);
                }
                v = tmp_v;
                break;
            }
            case Average: {
                v = this.average(values);
                break;
            }
            case MeanDeviation: {
                double average = 0.0;
                for (Double _value : values) {
                    average += _value.doubleValue();
                }
                average /= (double)dataSize;
                for (Double _value : values) {
                    tmp_v += Math.abs(_value - average);
                }
                v = tmp_v /= (double)dataSize;
                break;
            }
            case RSI: {
                v = TechnicalAnalysis.createRSI(values, day);
                break;
            }
            case EMA: {
                v = TechnicalAnalysis.createEMA(values, day);
                break;
            }
            case MFI: {
                v = TechnicalAnalysis.createMFI(highs, lows, closes, volumes, day);
                break;
            }
            case MACD: {
                v = TechnicalAnalysis.createMACDFix(values, (int)day).outMACD;
                break;
            }
            case MACDSignal: {
                v = TechnicalAnalysis.createMACDFix(values, (int)day).outMACDSignal;
                break;
            }
            case MACDHist: {
                v = TechnicalAnalysis.createMACDFix(values, (int)day).outMACDHist;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Object oldValue = this.value;
        this.value = v;
        if (!Utils.equals(oldValue, this.value)) {
            this.firePropertyChange("value", oldValue, this.value);
        }
    }

    public void setFunction(Function function) {
        Function oldFunction = this.function;
        this.function = function;
        if (!Utils.equals((Object)oldFunction, (Object)this.function)) {
            this.firePropertyChange("attribute", (Object)((Object)oldFunction) + " " + (Object)((Object)this.type), (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public int getNumOfInputConnector() {
        return 0;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        if (this.startDate != null && this.endDate != null && this.startDate.after(endDate)) {
            log.error((Object)("endDate " + endDate + " should not before startDate " + this.startDate));
            return;
        }
        this.endDate = endDate;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        if (!Utils.equals((Object)oldType, (Object)this.type)) {
            this.firePropertyChange("attribute", (Object)((Object)this.function) + " " + (Object)((Object)oldType), (Object)((Object)this.function) + " " + (Object)((Object)this.type));
        }
    }

    @Override
    public Class getInputClass(int index) {
        return null;
    }

    @Override
    public Class getOutputClass(int index) {
        return Double.class;
    }

    public static enum Type {
        PrevPrice,
        OpenPrice,
        HighPrice,
        LowPrice,
        LastPrice,
        TypicalPrice,
        Volume,
        MarketCapital,
        SharesIssued;

    }

    public static enum Function {
        Max,
        Min,
        Average,
        MeanDeviation,
        RSI,
        EMA,
        MFI,
        MACD,
        MACDSignal,
        MACDHist;

    }
}

