/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap hashMap = new HashMap();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName type) {
        this();
        this.dictionaryType = type;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    public void toPdf(PdfWriter writer, OutputStream os2) throws IOException {
        os2.write(60);
        os2.write(60);
        int type = 0;
        Iterator i = this.hashMap.keySet().iterator();
        while (i.hasNext()) {
            PdfName key = (PdfName)i.next();
            PdfObject value = (PdfObject)this.hashMap.get(key);
            key.toPdf(writer, os2);
            type = value.type();
            if (type != 5 && type != 6 && type != 4 && type != 3) {
                os2.write(32);
            }
            value.toPdf(writer, os2);
        }
        os2.write(62);
        os2.write(62);
    }

    public void put(PdfName key, PdfObject value) {
        if (value == null || value.isNull()) {
            this.hashMap.remove(key);
        } else {
            this.hashMap.put(key, value);
        }
    }

    public void putEx(PdfName key, PdfObject value) {
        if (value == null) {
            return;
        }
        this.put(key, value);
    }

    public void remove(PdfName key) {
        this.hashMap.remove(key);
    }

    public PdfObject get(PdfName key) {
        return (PdfObject)this.hashMap.get(key);
    }

    public boolean isDictionaryType(PdfName type) {
        return type.equals(this.dictionaryType);
    }

    public boolean isFont() {
        return FONT.equals(this.dictionaryType);
    }

    public boolean isPage() {
        return PAGE.equals(this.dictionaryType);
    }

    public boolean isPages() {
        return PAGES.equals(this.dictionaryType);
    }

    public boolean isCatalog() {
        return CATALOG.equals(this.dictionaryType);
    }

    public boolean isOutlineTree() {
        return OUTLINES.equals(this.dictionaryType);
    }

    public void merge(PdfDictionary other) {
        this.hashMap.putAll(other.hashMap);
    }

    public void mergeDifferent(PdfDictionary other) {
        Iterator i = other.hashMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (this.hashMap.containsKey(key)) continue;
            this.hashMap.put(key, other.hashMap.get(key));
        }
    }

    public Set getKeys() {
        return this.hashMap.keySet();
    }

    public void putAll(PdfDictionary dic) {
        this.hashMap.putAll(dic.hashMap);
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName key) {
        return this.hashMap.containsKey(key);
    }

    public String toString() {
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }
}

