/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.extension;

import java.util.Set;
import java.util.UUID;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.extension.ExtensionModule;
import org.apache.guacamole.extension.ProviderFactory;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.GuacamoleCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderFacade
implements AuthenticationProvider {
    private Logger logger = LoggerFactory.getLogger(AuthenticationProviderFacade.class);
    private final AuthenticationProvider authProvider;
    private final Set<String> tolerateFailures;
    private final String facadeIdentifier = UUID.randomUUID().toString();

    public AuthenticationProviderFacade(Class<? extends AuthenticationProvider> authProviderClass, Set<String> tolerateFailures) {
        this.tolerateFailures = tolerateFailures;
        this.authProvider = (AuthenticationProvider)ProviderFactory.newInstance((String)"authentication provider", authProviderClass);
    }

    public String getIdentifier() {
        if (this.authProvider == null) {
            this.logger.warn("The authentication system could not be loaded. Please check for errors earlier in the logs.");
            return this.facadeIdentifier;
        }
        return this.authProvider.getIdentifier();
    }

    public Object getResource() throws GuacamoleException {
        if (this.authProvider == null) {
            this.logger.warn("The authentication system could not be loaded. Please check for errors earlier in the logs.");
            return null;
        }
        return this.authProvider.getResource();
    }

    private boolean isFailureTolerated() {
        return this.tolerateFailures.contains(this.getIdentifier());
    }

    private void warnAuthProviderSkipped(Throwable e) {
        this.logger.warn("The \"{}\" authentication provider has been skipped due to an internal error. If this is unexpected or you are the developer of this authentication provider, you may wish to enable debug-level logging: {}", (Object)this.getIdentifier(), (Object)e.getMessage());
        this.logger.debug("Authentication provider skipped due to an internal failure.", e);
    }

    private void warnAuthAborted() {
        String identifier = this.getIdentifier();
        this.logger.warn("The \"{}\" authentication provider has encountered an internal error which will halt the authentication process. If this is unexpected or you are the developer of this authentication provider, you may wish to enable debug-level logging. If this is expected and you wish to ignore such failures in the future, please set \"{}: {}\" within your guacamole.properties.", new Object[]{identifier, ExtensionModule.SKIP_IF_UNAVAILABLE.getName(), identifier});
    }

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        if (this.authProvider == null) {
            this.logger.warn("Authentication attempt ignored because the relevant authentication provider could not be loaded. Please check for errors earlier in the logs.");
            return null;
        }
        try {
            return this.authProvider.authenticateUser(credentials);
        }
        catch (GuacamoleCredentialsException e) {
            throw e;
        }
        catch (GuacamoleException e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
        catch (RuntimeException e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
        catch (Error e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
    }

    public AuthenticatedUser updateAuthenticatedUser(AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (this.authProvider == null) {
            this.logger.warn("Reauthentication attempt ignored because the relevant authentication provider could not be loaded. Please check for errors earlier in the logs.");
            return null;
        }
        return this.authProvider.updateAuthenticatedUser(authenticatedUser, credentials);
    }

    public UserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (this.authProvider == null) {
            this.logger.warn("User data retrieval attempt ignored because the relevant authentication provider could not be loaded. Please check for errors earlier in the logs.");
            return null;
        }
        try {
            return this.authProvider.getUserContext(authenticatedUser);
        }
        catch (GuacamoleCredentialsException e) {
            throw e;
        }
        catch (GuacamoleException e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
        catch (RuntimeException e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
        catch (Error e) {
            if (this.isFailureTolerated()) {
                this.warnAuthProviderSkipped((Throwable)e);
                return null;
            }
            this.warnAuthAborted();
            throw e;
        }
    }

    public UserContext updateUserContext(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (this.authProvider == null) {
            this.logger.warn("User data refresh attempt ignored because the relevant authentication provider could not be loaded. Please check for errors earlier in the logs.");
            return null;
        }
        return this.authProvider.updateUserContext(context, authenticatedUser, credentials);
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (this.authProvider == null) {
            return context;
        }
        return this.authProvider.decorate(context, authenticatedUser, credentials);
    }

    public UserContext redecorate(UserContext decorated, UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (this.authProvider == null) {
            return context;
        }
        return this.authProvider.redecorate(decorated, context, authenticatedUser, credentials);
    }

    public void shutdown() {
        if (this.authProvider != null) {
            this.authProvider.shutdown();
        }
    }
}

