/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.FileRegion;
import org.apache.mina.core.polling.AbstractPollingIoProcessor;
import org.apache.mina.core.session.SessionState;
import org.apache.mina.transport.socket.nio.NioSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioProcessor
extends AbstractPollingIoProcessor<NioSession> {
    private Selector selector;

    public NioProcessor(Executor executor) {
        super(executor);
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new RuntimeIoException("Failed to open a selector.", iOException);
        }
    }

    @Override
    protected void doDispose() throws Exception {
        this.selector.close();
    }

    @Override
    protected int select(long l) throws Exception {
        return this.selector.select(l);
    }

    protected int select() throws Exception {
        return this.selector.select();
    }

    @Override
    protected boolean isSelectorEmpty() {
        return this.selector.keys().isEmpty();
    }

    @Override
    protected void wakeup() {
        this.wakeupCalled.getAndSet(true);
        this.selector.wakeup();
    }

    @Override
    protected Iterator<NioSession> allSessions() {
        return new IoSessionIterator<NioSession>(this.selector.keys());
    }

    @Override
    protected Iterator<NioSession> selectedSessions() {
        return new IoSessionIterator<NioSession>(this.selector.selectedKeys());
    }

    @Override
    protected void init(NioSession nioSession) throws Exception {
        SelectableChannel selectableChannel = (SelectableChannel)((Object)nioSession.getChannel());
        selectableChannel.configureBlocking(false);
        nioSession.setSelectionKey(selectableChannel.register(this.selector, 1, nioSession));
    }

    @Override
    protected void destroy(NioSession nioSession) throws Exception {
        ByteChannel byteChannel = nioSession.getChannel();
        SelectionKey selectionKey = nioSession.getSelectionKey();
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        byteChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerNewSelector() throws IOException {
        Selector selector = this.selector;
        synchronized (selector) {
            Set<SelectionKey> set = this.selector.keys();
            Selector selector2 = Selector.open();
            for (SelectionKey selectionKey : set) {
                SelectableChannel selectableChannel = selectionKey.channel();
                NioSession nioSession = (NioSession)selectionKey.attachment();
                SelectionKey selectionKey2 = selectableChannel.register(selector2, selectionKey.interestOps(), nioSession);
                nioSession.setSelectionKey(selectionKey2);
            }
            this.selector.close();
            this.selector = selector2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isBrokenConnection() throws IOException {
        boolean bl = false;
        Selector selector = this.selector;
        synchronized (selector) {
            Set<SelectionKey> set = this.selector.keys();
            for (SelectionKey selectionKey : set) {
                SelectableChannel selectableChannel = selectionKey.channel();
                if ((!(selectableChannel instanceof DatagramChannel) || !((DatagramChannel)selectableChannel).isConnected()) && (!(selectableChannel instanceof SocketChannel) || !((SocketChannel)selectableChannel).isConnected())) continue;
                selectionKey.cancel();
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected SessionState getState(NioSession nioSession) {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        if (selectionKey == null) {
            return SessionState.OPENING;
        }
        if (selectionKey.isValid()) {
            return SessionState.OPENED;
        }
        return SessionState.CLOSING;
    }

    @Override
    protected boolean isReadable(NioSession nioSession) {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        return selectionKey.isValid() && selectionKey.isReadable();
    }

    @Override
    protected boolean isWritable(NioSession nioSession) {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        return selectionKey.isValid() && selectionKey.isWritable();
    }

    protected boolean isInterestedInRead(NioSession nioSession) {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        return selectionKey.isValid() && (selectionKey.interestOps() & 1) != 0;
    }

    protected boolean isInterestedInWrite(NioSession nioSession) {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        return selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0;
    }

    @Override
    protected void setInterestedInRead(NioSession nioSession, boolean bl) throws Exception {
        int n;
        SelectionKey selectionKey = nioSession.getSelectionKey();
        int n2 = n = selectionKey.interestOps();
        n2 = bl ? (n2 |= 1) : (n2 &= 0xFFFFFFFE);
        if (n != n2) {
            selectionKey.interestOps(n2);
        }
    }

    @Override
    protected void setInterestedInWrite(NioSession nioSession, boolean bl) throws Exception {
        SelectionKey selectionKey = nioSession.getSelectionKey();
        if (selectionKey == null) {
            return;
        }
        int n = selectionKey.interestOps();
        n = bl ? (n |= 4) : (n &= 0xFFFFFFFB);
        selectionKey.interestOps(n);
    }

    @Override
    protected int read(NioSession nioSession, IoBuffer ioBuffer) throws Exception {
        ByteChannel byteChannel = nioSession.getChannel();
        return nioSession.getChannel().read(ioBuffer.buf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int write(NioSession nioSession, IoBuffer ioBuffer, int n) throws Exception {
        if (ioBuffer.remaining() <= n) {
            return nioSession.getChannel().write(ioBuffer.buf());
        }
        int n2 = ioBuffer.limit();
        ioBuffer.limit(ioBuffer.position() + n);
        try {
            int n3 = nioSession.getChannel().write(ioBuffer.buf());
            return n3;
        }
        finally {
            ioBuffer.limit(n2);
        }
    }

    @Override
    protected int transferFile(NioSession nioSession, FileRegion fileRegion, int n) throws Exception {
        try {
            return (int)fileRegion.getFileChannel().transferTo(fileRegion.getPosition(), n, nioSession.getChannel());
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string != null && string.contains("temporarily unavailable")) {
                return 0;
            }
            throw iOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IoSessionIterator<NioSession>
    implements Iterator<NioSession> {
        private final Iterator<SelectionKey> iterator;

        private IoSessionIterator(Set<SelectionKey> set) {
            this.iterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public NioSession next() {
            SelectionKey selectionKey = this.iterator.next();
            Object object = selectionKey.attachment();
            return (NioSession)object;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

