/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy.utils;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtilities {
    public static String getDirectiveValue(HashMap<String, String> hashMap, String string, boolean bl) throws AuthenticationException {
        String string2 = hashMap.get(string);
        if (string2 == null) {
            if (bl) {
                throw new AuthenticationException("\"" + string + "\" mandatory directive is missing");
            }
            return "";
        }
        return string2;
    }

    public static String copyDirective(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, String string) {
        String string2 = hashMap.get(string);
        if (string2 != null) {
            hashMap2.put(string, string2);
        }
        return string2;
    }

    public static HashMap<String, String> parseDirectives(byte[] byArray) throws SaslException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(10);
        int n = StringUtilities.skipLws(byArray, 0);
        while (n < byArray.length) {
            byte by = byArray[n];
            if (bl) {
                if (by == 44) {
                    if (byteArrayOutputStream.size() != 0) {
                        throw new SaslException("Directive key contains a ',':" + byteArrayOutputStream);
                    }
                    n = StringUtilities.skipLws(byArray, n + 1);
                    continue;
                }
                if (by == 61) {
                    if (byteArrayOutputStream.size() == 0) {
                        throw new SaslException("Empty directive key");
                    }
                    bl = false;
                    if ((n = StringUtilities.skipLws(byArray, n + 1)) < byArray.length) {
                        if (byArray[n] != 34) continue;
                        bl2 = true;
                        ++n;
                        continue;
                    }
                    throw new SaslException("Valueless directive found: " + byteArrayOutputStream.toString());
                }
                if (StringUtilities.isLws(by)) {
                    if ((n = StringUtilities.skipLws(byArray, n + 1)) < byArray.length) {
                        if (byArray[n] == 61) continue;
                        throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                    }
                    throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                }
                byteArrayOutputStream.write(by);
                ++n;
                continue;
            }
            if (bl2) {
                if (by == 92) {
                    if (++n < byArray.length) {
                        byteArrayOutputStream2.write(byArray[n]);
                        ++n;
                        continue;
                    }
                    throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
                }
                if (by == 34) {
                    ++n;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                byteArrayOutputStream2.write(by);
                ++n;
                continue;
            }
            if (StringUtilities.isLws(by) || by == 44) {
                StringUtilities.extractDirective(hashMap, byteArrayOutputStream.toString(), byteArrayOutputStream2.toString());
                byteArrayOutputStream.reset();
                byteArrayOutputStream2.reset();
                bl = true;
                bl3 = false;
                bl2 = false;
                n = StringUtilities.skipLws(byArray, n + 1);
                continue;
            }
            if (bl3) {
                throw new SaslException("Expecting comma or linear whitespace after quoted string: \"" + byteArrayOutputStream2.toString() + "\"");
            }
            byteArrayOutputStream2.write(by);
            ++n;
        }
        if (bl2) {
            throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
        }
        if (byteArrayOutputStream.size() > 0) {
            StringUtilities.extractDirective(hashMap, byteArrayOutputStream.toString(), byteArrayOutputStream2.toString());
        }
        return hashMap;
    }

    private static void extractDirective(HashMap<String, String> hashMap, String string, String string2) throws SaslException {
        if (hashMap.get(string) != null) {
            throw new SaslException("Peer sent more than one " + string + " directive");
        }
        hashMap.put(string, string2);
    }

    public static boolean isLws(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static int skipLws(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length; ++n2) {
            if (StringUtilities.isLws(byArray[n2])) continue;
            return n2;
        }
        return n2;
    }

    public static String stringTo8859_1(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return "";
        }
        return new String(string.getBytes("UTF8"), "8859_1");
    }

    public static String getSingleValuedHeader(Map<String, List<String>> map, String string) {
        List<String> list = map.get(string);
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("Header with key [\"" + string + "\"] isn't single valued !");
        }
        return list.get(0);
    }

    public static void addValueToHeader(Map<String, List<String>> map, String string, String string2, boolean bl) {
        List<String> list = map.get(string);
        if (list == null) {
            list = new ArrayList<String>(1);
            map.put(string, list);
        }
        if (bl && list.size() == 1) {
            list.set(0, string2);
        } else {
            list.add(string2);
        }
    }
}

