/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class MintScrollButton
extends BaseScrollButton {
    protected static Icon upArrowIcon = null;
    protected static Icon downArrowIcon = null;
    protected static Icon leftArrowIcon = null;
    protected static Icon rightArrowIcon = null;

    public MintScrollButton(int n, int n2) {
        super(n, n2);
    }

    public Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = new LazyImageIcon("mint/icons/UpArrow.gif");
        }
        return upArrowIcon;
    }

    public Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = new LazyImageIcon("mint/icons/DownArrow.gif");
        }
        return downArrowIcon;
    }

    public Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = new LazyImageIcon("mint/icons/LeftArrow.gif");
        }
        return leftArrowIcon;
    }

    public Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = new LazyImageIcon("mint/icons/RightArrow.gif");
        }
        return rightArrowIcon;
    }

    public void paint(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.getModel().isRollover();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color[] colorArray = MintLookAndFeel.getTheme().getThumbColors();
        Color color = colorArray[0];
        Color color2 = colorArray[colorArray.length - 1];
        if (bl) {
            color = ColorHelper.darker(color, 10.0);
            color2 = ColorHelper.darker(color2, 10.0);
        } else if (bl2) {
            object = MintLookAndFeel.getTheme().getRolloverColors();
            color = object[0];
            color2 = object[((Color[])object).length - 1];
        } else if (!JTattooUtilities.isActive(this)) {
            color = MintLookAndFeel.getTheme().getButtonColorLight();
            color2 = MintLookAndFeel.getTheme().getButtonColorDark();
        }
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, n, n2, color2));
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.white);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.drawLine(1, 1, 1, n2 - 3);
        graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        graphics.drawLine(2, n2 - 2, n - 3, n2 - 2);
        graphics2D.setPaint(null);
        object = graphics2D.getComposite();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setColor(color2);
        graphics.drawLine(3, 2, n - 4, 2);
        graphics.drawLine(2, 3, 2, n2 - 4);
        color2 = ColorHelper.darker(color2, 30.0);
        graphics.setColor(color2);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 3);
        graphics.drawLine(3, n2 - 1, n - 3, n2 - 1);
        alphaComposite = AlphaComposite.getInstance(3, 0.2f);
        graphics2D.setComposite(alphaComposite);
        graphics.drawLine(1, n2 - 2, 2, n2 - 1);
        graphics.drawLine(n - 1, n2 - 2, n - 2, n2 - 1);
        graphics2D.setComposite((Composite)object);
        if (this.getDirection() == 1) {
            int n3 = n / 2 - this.getUpArrowIcon().getIconWidth() / 2;
            int n4 = n2 / 2 - this.getUpArrowIcon().getIconHeight() / 2;
            this.getUpArrowIcon().paintIcon(this, graphics, n3, n4);
        } else if (this.getDirection() == 5) {
            int n5 = n / 2 - this.getDownArrowIcon().getIconWidth() / 2;
            int n6 = n2 / 2 - this.getDownArrowIcon().getIconHeight() / 2 + 1;
            this.getDownArrowIcon().paintIcon(this, graphics, n5, n6);
        } else if (this.getDirection() == 7) {
            int n7 = n / 2 - this.getLeftArrowIcon().getIconWidth() / 2;
            int n8 = n2 / 2 - this.getLeftArrowIcon().getIconHeight() / 2;
            this.getLeftArrowIcon().paintIcon(this, graphics, n7, n8);
        } else {
            int n9 = n / 2 - this.getRightArrowIcon().getIconWidth() / 2 + 1;
            int n10 = n2 / 2 - this.getRightArrowIcon().getIconHeight() / 2;
            this.getRightArrowIcon().paintIcon(this, graphics, n9, n10);
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }
}

