/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.swing.Swinger;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Browser {
    private static final Logger logger = Logger.getLogger(Browser.class.getName());

    private Browser() {
    }

    public static void openBrowser(String mailOrUrl) {
        assert (mailOrUrl != null);
        if (mailOrUrl.length() <= 0 || !Desktop.isDesktopSupported()) {
            return;
        }
        try {
            URI uri = new URI(mailOrUrl);
            if (!mailOrUrl.startsWith("mailto")) {
                Desktop.getDesktop().browse(uri);
            } else {
                Desktop.getDesktop().mail(uri);
            }
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Opening browser failed", e);
            Swinger.showErrorDialog("errorOpeningBrowser", e);
        }
    }

    public static void showHomepage() {
        Browser.openBrowser(AppPrefs.getProperty("weburl", "http://wordrider.net/freerapid"));
    }

    public static void openBrowser(URL url) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            return;
        }
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Opening browser failed", e);
            Swinger.showErrorDialog("errorOpeningBrowser", e);
        }
    }
}

