/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.portecle.FPortecle;
import net.sf.portecle.StringUtil;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.microsoft.MicrosoftObjectIdentifiers;
import org.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle.asn1.misc.NetscapeCertType;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilities;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class X509Ext {
    private static final Logger LOG = Logger.getLogger(X509Ext.class.getCanonicalName());
    private final String m_sName;
    private final ASN1ObjectIdentifier m_Oid;
    private final byte[] m_bValue;
    private final boolean m_bCritical;
    private static final int[] KEY_USAGES = new int[]{128, 64, 32, 16, 8, 4, 2, 1, 32768};
    private static final int[] NETSCAPE_CERT_TYPES = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    public X509Ext(String string, byte[] byArray, boolean bl) {
        this.m_Oid = new ASN1ObjectIdentifier(string);
        this.m_bValue = (byte[])byArray.clone();
        this.m_bCritical = bl;
        this.m_sName = X509Ext.getRes(this.m_Oid.getId(), "UnrecognisedExtension");
    }

    public String getOid() {
        return this.m_Oid.getId();
    }

    public byte[] getValue() {
        return (byte[])this.m_bValue.clone();
    }

    public boolean isCriticalExtension() {
        return this.m_bCritical;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getStringValue() throws IOException, ParseException {
        byte[] byArray = ((ASN1OctetString)ASN1Primitive.fromByteArray(this.m_bValue)).getOctets();
        if (this.m_Oid.equals(X509ObjectIdentifiers.commonName)) {
            return this.getCommonNameStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.subjectKeyIdentifier)) {
            return this.getSubjectKeyIdentifierStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.keyUsage)) {
            return this.getKeyUsageStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.privateKeyUsagePeriod)) {
            return this.getPrivateKeyUsagePeriod(byArray);
        }
        if (this.m_Oid.equals(Extension.issuerAlternativeName) || this.m_Oid.equals(Extension.subjectAlternativeName)) {
            return this.getAlternativeName(byArray);
        }
        if (this.m_Oid.equals(Extension.basicConstraints)) {
            return this.getBasicConstraintsStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.cRLNumber)) {
            return this.getCrlNumberStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.reasonCode)) {
            return this.getReasonCodeStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.instructionCode)) {
            return this.getHoldInstructionCodeStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.invalidityDate)) {
            return this.getInvalidityDateStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.deltaCRLIndicator)) {
            return this.getDeltaCrlIndicatorStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.certificateIssuer)) {
            return this.getCertificateIssuerStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.policyMappings)) {
            return this.getPolicyMappingsStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.authorityKeyIdentifier)) {
            return this.getAuthorityKeyIdentifierStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.policyConstraints)) {
            return this.getPolicyConstraintsStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.extendedKeyUsage)) {
            return this.getExtendedKeyUsageStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.inhibitAnyPolicy)) {
            return this.getInhibitAnyPolicyStringValue(byArray);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.entrustVersionExtension)) {
            return this.getEntrustVersionExtensionStringValue(byArray);
        }
        if (this.m_Oid.equals(PKCSObjectIdentifiers.pkcs_9_at_smimeCapabilities)) {
            return this.getSmimeCapabilitiesStringValue(byArray);
        }
        if (this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftCaVersion)) {
            return this.getMicrosoftCAVersionStringValue(byArray);
        }
        if (this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftPrevCaCertHash)) {
            return this.getMicrosoftPreviousCACertificateHashStringValue(byArray);
        }
        if (this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftCertTemplateV2)) {
            return this.getMicrosoftCertificateTemplateV2StringValue(byArray);
        }
        if (this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftAppPolicies)) {
            return this.getUnknownOidStringValue(byArray);
        }
        if (this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftCrlNextPublish)) {
            return this.getMicrosoftCrlNextPublish(byArray);
        }
        if (this.m_Oid.equals(Extension.authorityInfoAccess) || this.m_Oid.equals(Extension.subjectInfoAccess)) {
            return this.getInformationAccessStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.logoType)) {
            return this.getLogotypeStringValue(byArray);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.novellSecurityAttribs)) {
            return this.getNovellSecurityAttributesStringValue(byArray);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.netscapeCertType)) {
            return this.getNetscapeCertificateTypeStringValue(byArray);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.netscapeSSLServerName) || this.m_Oid.equals(MiscObjectIdentifiers.netscapeCertComment) || this.m_Oid.equals(MiscObjectIdentifiers.verisignDnbDunsNumber) || this.m_Oid.equals(MicrosoftObjectIdentifiers.microsoftCertTemplateV1)) {
            return this.getASN1ObjectString(byArray);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.netscapeCApolicyURL)) {
            return this.getNetscapeExtensionURLValue(byArray, LinkClass.BROWSER);
        }
        if (this.m_Oid.equals(MiscObjectIdentifiers.netscapeBaseURL) || this.m_Oid.equals(MiscObjectIdentifiers.netscapeRenewalURL) || this.m_Oid.equals(MiscObjectIdentifiers.netscapeRevocationURL) || this.m_Oid.equals(MiscObjectIdentifiers.netscapeCARevocationURL)) {
            return this.getNetscapeExtensionURLValue(byArray, LinkClass.CRL);
        }
        if (this.m_Oid.equals(Extension.cRLDistributionPoints)) {
            return this.getCrlDistributionPointsStringValue(byArray);
        }
        if (this.m_Oid.equals(Extension.certificatePolicies)) {
            return this.getCertificatePoliciesStringValue(byArray);
        }
        return this.getUnknownOidStringValue(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnknownOidStringValue(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        int n = 16;
        try {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<pre>");
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byte[] byArray2 = new byte[n];
            while ((n2 = byteArrayInputStream.read(byArray2)) != -1) {
                stringBuilder.append(X509Ext.escapeHtml(this.getHexClearDump(byArray2, n2)));
            }
            stringBuilder.append("</pre>");
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Could not close internal input stream", iOException);
                }
            }
        }
    }

    private String getCommonNameStringValue(byte[] byArray) throws IOException {
        return X509Ext.stringify(ASN1Primitive.fromByteArray(byArray));
    }

    private String getSubjectKeyIdentifierStringValue(byte[] byArray) {
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(byArray);
        byte[] byArray2 = subjectKeyIdentifier.getKeyIdentifier();
        return X509Ext.convertToHexString(byArray2);
    }

    private String getKeyUsageStringValue(byte[] byArray) throws IOException {
        int n = ((DERBitString)ASN1Primitive.fromByteArray(byArray)).intValue();
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : KEY_USAGES) {
            if ((n & n2) != n2) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br><br>");
            }
            stringBuilder.append(FPortecle.RB.getString("KeyUsage." + n2));
        }
        return stringBuilder.toString();
    }

    private String getPrivateKeyUsagePeriod(byte[] byArray) throws ParseException {
        PrivateKeyUsagePeriod privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        ASN1GeneralizedTime aSN1GeneralizedTime = privateKeyUsagePeriod.getNotBefore();
        if (aSN1GeneralizedTime != null) {
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("PrivateKeyUsagePeriodNotBefore"), this.formatGeneralizedTime(aSN1GeneralizedTime)));
        }
        if ((aSN1GeneralizedTime = privateKeyUsagePeriod.getNotAfter()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br><br>");
            }
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("PrivateKeyUsagePeriodNotAfter"), this.formatGeneralizedTime(aSN1GeneralizedTime)));
        }
        return stringBuilder.toString();
    }

    private String getAlternativeName(byte[] byArray) throws IOException {
        return this.getGeneralNamesString(GeneralNames.getInstance(byArray), LinkClass.BROWSER);
    }

    private String getBasicConstraintsStringValue(byte[] byArray) {
        BasicConstraints basicConstraints = BasicConstraints.getInstance(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FPortecle.RB.getString(basicConstraints.isCA() ? "SubjectIsCa" : "SubjectIsNotCa"));
        stringBuilder.append("<br><br>");
        BigInteger bigInteger = basicConstraints.getPathLenConstraint();
        if (bigInteger != null) {
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("PathLengthConstraint"), bigInteger));
        }
        return stringBuilder.toString();
    }

    private String getCrlNumberStringValue(byte[] byArray) throws IOException {
        return NumberFormat.getInstance().format(((ASN1Integer)ASN1Primitive.fromByteArray(byArray)).getValue());
    }

    private String getReasonCodeStringValue(byte[] byArray) throws IOException {
        int n = CRLReason.getInstance(ASN1Primitive.fromByteArray(byArray)).getValue().intValue();
        String string = X509Ext.getRes("CrlReason." + n, "UnrecognisedCrlReasonString");
        return MessageFormat.format(string, n);
    }

    private String getHoldInstructionCodeStringValue(byte[] byArray) throws IOException {
        String string = ASN1Primitive.fromByteArray(byArray).toString();
        String string2 = X509Ext.getRes(string, "UnrecognisedHoldInstructionCode");
        return MessageFormat.format(string2, X509Ext.escapeHtml(string));
    }

    private String getInvalidityDateStringValue(byte[] byArray) throws IOException, ParseException {
        ASN1GeneralizedTime aSN1GeneralizedTime = (ASN1GeneralizedTime)ASN1Primitive.fromByteArray(byArray);
        return this.formatGeneralizedTime(aSN1GeneralizedTime);
    }

    private String getDeltaCrlIndicatorStringValue(byte[] byArray) throws IOException {
        ASN1Integer aSN1Integer = (ASN1Integer)ASN1Primitive.fromByteArray(byArray);
        return X509Ext.convertToHexString(aSN1Integer);
    }

    private String getCertificateIssuerStringValue(byte[] byArray) throws IOException {
        return this.getGeneralNamesString(GeneralNames.getInstance(ASN1Primitive.fromByteArray(byArray)), LinkClass.BROWSER);
    }

    private String getPolicyMappingsStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder("<ul>");
        int n = aSN1Sequence.size();
        for (int i = 0; i < n; ++i) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(i);
            int n2 = aSN1Sequence2.size();
            stringBuilder.append("<li>");
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("PolicyMapping"), i + 1));
            if (n2 > 0) {
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                stringBuilder.append("<ul><li>");
                stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("IssuerDomainPolicy"), aSN1ObjectIdentifier.getId()));
                stringBuilder.append("</li></ul>");
            }
            if (n2 > 1) {
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(1);
                stringBuilder.append("<ul><li>");
                stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("SubjectDomainPolicy"), aSN1ObjectIdentifier.getId()));
                stringBuilder.append("</li></ul>");
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private String getAuthorityKeyIdentifierStringValue(byte[] byArray) throws IOException {
        BigInteger bigInteger;
        GeneralNames generalNames;
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = authorityKeyIdentifier.getKeyIdentifier();
        if (byArray2 != null) {
            stringBuilder.append(FPortecle.RB.getString("KeyIdentifier"));
            stringBuilder.append(": ");
            stringBuilder.append(X509Ext.convertToHexString(byArray2));
            stringBuilder.append("<br>");
        }
        if ((generalNames = authorityKeyIdentifier.getAuthorityCertIssuer()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append("<ul><li>");
            stringBuilder.append(FPortecle.RB.getString("CertificateIssuer"));
            stringBuilder.append(": ");
            stringBuilder.append(this.getGeneralNamesString(generalNames, LinkClass.BROWSER));
            stringBuilder.append("</li></ul>");
        }
        if ((bigInteger = authorityKeyIdentifier.getAuthorityCertSerialNumber()) != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("CertificateSerialNumber"), bigInteger));
        }
        return stringBuilder.toString();
    }

    private String getPolicyConstraintsStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        int n = aSN1Sequence.size();
        block4: for (int i = 0; i < n; ++i) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(i);
            ASN1Integer aSN1Integer = new ASN1Integer(((DEROctetString)dERTaggedObject.getObject()).getOctets());
            int n2 = aSN1Integer.getValue().intValue();
            switch (dERTaggedObject.getTagNo()) {
                case 0: {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("<br><br>");
                    }
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("RequireExplicitPolicy"), n2));
                    continue block4;
                }
                case 1: {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("<br><br>");
                    }
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("InhibitPolicyMapping"), n2));
                }
            }
        }
        return stringBuilder.toString();
    }

    private String getExtendedKeyUsageStringValue(byte[] byArray) {
        KeyPurposeId[] keyPurposeIdArray;
        StringBuilder stringBuilder = new StringBuilder();
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance(byArray);
        for (KeyPurposeId keyPurposeId : keyPurposeIdArray = extendedKeyUsage.getUsages()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br><br>");
            }
            String string = keyPurposeId.getId();
            String string2 = X509Ext.getRes(string, "UnrecognisedExtKeyUsageString");
            stringBuilder.append(MessageFormat.format(string2, string));
        }
        return stringBuilder.toString();
    }

    private String getInhibitAnyPolicyStringValue(byte[] byArray) throws IOException {
        ASN1Integer aSN1Integer = (ASN1Integer)ASN1Primitive.fromByteArray(byArray);
        int n = aSN1Integer.getValue().intValue();
        return MessageFormat.format(FPortecle.RB.getString("InhibitAnyPolicy"), n);
    }

    private String getEntrustVersionExtensionStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        return X509Ext.escapeHtml(((DERGeneralString)aSN1Sequence.getObjectAt(0)).getString());
    }

    private String getMicrosoftCertificateTemplateV2StringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FPortecle.RB.getString("MsftCertTemplateId"));
        stringBuilder.append(": ");
        stringBuilder.append(((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId());
        stringBuilder.append("<br><br>");
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.getObjectAt(1);
        stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("MsftCertTemplateMajorVer"), aSN1Integer.getValue()));
        aSN1Integer = (ASN1Integer)aSN1Sequence.getObjectAt(2);
        if (aSN1Integer != null) {
            stringBuilder.append("<br><br>");
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("MsftCertTemplateMinorVer"), aSN1Integer.getValue()));
        }
        return stringBuilder.toString();
    }

    private String getMicrosoftCAVersionStringValue(byte[] byArray) throws IOException {
        int n = ((ASN1Integer)ASN1Primitive.fromByteArray(byArray)).getValue().intValue();
        String string = String.valueOf(n & 0xFFFF);
        String string2 = String.valueOf(n >> 16);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("MsftCaVersionCert"), string));
        stringBuilder.append("<br><br>");
        stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("MsftCaVersionKey"), string2));
        return stringBuilder.toString();
    }

    private String getMicrosoftPreviousCACertificateHashStringValue(byte[] byArray) throws IOException {
        DEROctetString dEROctetString = (DEROctetString)ASN1Primitive.fromByteArray(byArray);
        byte[] byArray2 = dEROctetString.getOctets();
        return X509Ext.convertToHexString(byArray2);
    }

    private String getMicrosoftCrlNextPublish(byte[] byArray) throws IOException {
        DERUTCTime dERUTCTime = (DERUTCTime)ASN1Primitive.fromByteArray(byArray);
        String string = dERUTCTime.getAdjustedTime();
        try {
            string = DateFormat.getDateTimeInstance(2, 1).format(dERUTCTime.getAdjustedDate());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return X509Ext.escapeHtml(string);
    }

    private String getSmimeCapabilitiesStringValue(byte[] byArray) throws IOException {
        SMIMECapabilities sMIMECapabilities = SMIMECapabilities.getInstance(ASN1Primitive.fromByteArray(byArray));
        String string = FPortecle.RB.getString("SmimeParameters");
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e : sMIMECapabilities.getCapabilities(null)) {
            SMIMECapability sMIMECapability = (SMIMECapability)e;
            String string2 = sMIMECapability.getCapabilityID().getId();
            String string3 = X509Ext.getRes(string2, "UnrecognisedSmimeCapability");
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br>");
            }
            stringBuilder.append("<ul><li>");
            stringBuilder.append(MessageFormat.format(string3, string2));
            ASN1Encodable aSN1Encodable = sMIMECapability.getParameters();
            if (aSN1Encodable != null) {
                stringBuilder.append("<ul><li>");
                stringBuilder.append(string);
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.stringify(aSN1Encodable));
                stringBuilder.append("</li></ul>");
            }
            stringBuilder.append("</li></ul>");
        }
        return stringBuilder.toString();
    }

    private String getInformationAccessStringValue(byte[] byArray) throws IOException {
        AccessDescription[] accessDescriptionArray;
        AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (AccessDescription accessDescription : accessDescriptionArray = authorityInformationAccess.getAccessDescriptions()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br>");
            }
            String string = accessDescription.getAccessMethod().toString();
            String string2 = X509Ext.getRes(string, "UnrecognisedAccessMethod");
            LinkClass linkClass = LinkClass.BROWSER;
            if (string.equals(AccessDescription.id_ad_ocsp.getId())) {
                linkClass = LinkClass.OCSP;
            } else if (string.equals(AccessDescription.id_ad_caIssuers.getId())) {
                linkClass = LinkClass.CERTIFICATE;
            }
            stringBuilder.append("<ul><li>");
            stringBuilder.append(MessageFormat.format(string2, string));
            stringBuilder.append(": <ul><li>");
            stringBuilder.append(this.getGeneralNameString(accessDescription.getAccessLocation(), linkClass));
            stringBuilder.append("</li></ul></li></ul>");
        }
        return stringBuilder.toString();
    }

    private String getLogotypeStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        int n = aSN1Sequence.size();
        block10: for (int i = 0; i < n; ++i) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(i);
            switch (dERTaggedObject.getTagNo()) {
                case 0: {
                    stringBuilder.append(FPortecle.RB.getString("CommunityLogos"));
                    stringBuilder.append("<br>");
                    stringBuilder.append(X509Ext.stringify(dERTaggedObject.getObject()));
                    continue block10;
                }
                case 1: {
                    stringBuilder.append("<ul><li>");
                    stringBuilder.append(FPortecle.RB.getString("IssuerLogo"));
                    DERTaggedObject dERTaggedObject2 = (DERTaggedObject)dERTaggedObject.getObject();
                    switch (dERTaggedObject2.getTagNo()) {
                        case 0: {
                            stringBuilder.append("<ul><li>");
                            stringBuilder.append("Data");
                            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)dERTaggedObject2.getObject();
                            if (aSN1Sequence2.size() > 0) {
                                String string;
                                Object object;
                                stringBuilder.append("<ul><li>");
                                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.getObjectAt(0);
                                stringBuilder.append("Image");
                                ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Sequence3.getObjectAt(0);
                                stringBuilder.append("<ul><li>");
                                stringBuilder.append("Details");
                                stringBuilder.append("<ul>");
                                String string2 = ((ASN1String)((Object)aSN1Sequence4.getObjectAt(0))).getString();
                                stringBuilder.append("<li>Media type: ").append(X509Ext.escapeHtml(string2)).append("</li>");
                                ASN1Sequence aSN1Sequence5 = (ASN1Sequence)aSN1Sequence4.getObjectAt(1);
                                int n2 = aSN1Sequence5.size();
                                for (int j = 0; j < n2; ++j) {
                                    ASN1Sequence aSN1Sequence6 = (ASN1Sequence)aSN1Sequence5.getObjectAt(j);
                                    object = (ASN1Sequence)aSN1Sequence6.getObjectAt(0);
                                    string = ((ASN1Sequence)object).getObjectAt(0).toString();
                                    String string3 = X509Ext.getRes(string, "UnrecognisedHashAlgorithm");
                                    stringBuilder.append("<li>Hash (");
                                    stringBuilder.append(MessageFormat.format(string3, string));
                                    stringBuilder.append("): ");
                                    byte[] byArray2 = ((DEROctetString)aSN1Sequence6.getObjectAt(1)).getOctets();
                                    stringBuilder.append(X509Ext.convertToHexString(byArray2));
                                    stringBuilder.append("</li>");
                                }
                                ASN1Sequence aSN1Sequence7 = (ASN1Sequence)aSN1Sequence4.getObjectAt(2);
                                int n3 = aSN1Sequence7.size();
                                for (n2 = 0; n2 < n3; ++n2) {
                                    object = ((ASN1String)((Object)aSN1Sequence7.getObjectAt(n2))).getString();
                                    string = X509Ext.escapeHtml(object);
                                    stringBuilder.append("<li>URI: ");
                                    stringBuilder.append(X509Ext.getLink((String)object, string, LinkClass.BROWSER));
                                    stringBuilder.append("<br>");
                                    stringBuilder.append("<img src=\"").append(string).append("\" alt=\"").append(string).append("\">");
                                    stringBuilder.append("</li>");
                                }
                                if (aSN1Sequence3.size() > 1) {
                                    stringBuilder.append("<li>Image info: ");
                                    stringBuilder.append(X509Ext.stringify(aSN1Sequence3.getObjectAt(1)));
                                    stringBuilder.append("</li>");
                                }
                                stringBuilder.append("</ul></li>");
                                if (aSN1Sequence2.size() > 1) {
                                    stringBuilder.append("<li>Audio: ");
                                    stringBuilder.append(X509Ext.stringify(aSN1Sequence2.getObjectAt(1)));
                                    stringBuilder.append("</li>");
                                }
                                stringBuilder.append("</ul>");
                            }
                            stringBuilder.append("</li></ul></li></ul>");
                            continue block10;
                        }
                        case 1: {
                            stringBuilder.append("Reference: ");
                            stringBuilder.append(X509Ext.stringify(dERTaggedObject2.getObject()));
                            continue block10;
                        }
                    }
                    stringBuilder.append(X509Ext.stringify(dERTaggedObject2));
                    continue block10;
                }
                case 2: {
                    stringBuilder.append(FPortecle.RB.getString("SubjectLogo"));
                    stringBuilder.append("<br>");
                    stringBuilder.append(X509Ext.stringify(dERTaggedObject.getObject()));
                    continue block10;
                }
                case 3: {
                    stringBuilder.append(FPortecle.RB.getString("OtherLogos"));
                    stringBuilder.append("<br>");
                    stringBuilder.append(X509Ext.stringify(dERTaggedObject.getObject()));
                    continue block10;
                }
                default: {
                    stringBuilder.append(X509Ext.stringify(dERTaggedObject));
                }
            }
        }
        return stringBuilder.toString();
    }

    private String getNovellSecurityAttributesStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((ASN1String)((Object)aSN1Sequence.getObjectAt(2))).getString();
        stringBuilder.append(X509Ext.escapeHtml(string));
        stringBuilder.append("<br>");
        byte[] byArray2 = ((DEROctetString)aSN1Sequence.getObjectAt(0)).getOctets();
        stringBuilder.append("Major version: ").append(Byte.toString(byArray2[0]));
        stringBuilder.append(", minor version: ").append(Byte.toString(byArray2[1]));
        stringBuilder.append("<br>");
        boolean bl = ((ASN1Boolean)aSN1Sequence.getObjectAt(1)).isTrue();
        stringBuilder.append("Nonverified Subscriber Information: ").append(bl);
        stringBuilder.append("<br>");
        String string2 = ((ASN1String)((Object)aSN1Sequence.getObjectAt(3))).getString();
        stringBuilder.append("URI: ");
        stringBuilder.append(X509Ext.getLink(string2, X509Ext.escapeHtml(string2), LinkClass.BROWSER));
        stringBuilder.append("<ul>");
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(4);
        stringBuilder.append("<li>GLB extensions:<ul>");
        ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1TaggedObject)aSN1Sequence2.getObjectAt(0)).getObject();
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellKeyQuality"));
        stringBuilder.append("<ul>").append(this.getNovellQualityAttr(aSN1Sequence3)).append("</ul></li>");
        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)((ASN1TaggedObject)aSN1Sequence2.getObjectAt(1)).getObject();
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellCryptoProcessQuality"));
        stringBuilder.append("<ul>").append(this.getNovellQualityAttr(aSN1Sequence4)).append("</ul></li>");
        ASN1Sequence aSN1Sequence5 = (ASN1Sequence)((ASN1TaggedObject)aSN1Sequence2.getObjectAt(2)).getObject();
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellCertClass"));
        stringBuilder.append(": ");
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence5.getObjectAt(0)).getValue();
        String string3 = X509Ext.getRes("NovellCertClass." + bigInteger, "UnregocnisedNovellCertClass");
        stringBuilder.append(MessageFormat.format(string3, bigInteger));
        stringBuilder.append("</li>");
        boolean bl2 = true;
        if (aSN1Sequence5.size() > 1) {
            bl2 = ((ASN1Boolean)aSN1Sequence5.getObjectAt(1)).isTrue();
        }
        stringBuilder.append("<li>");
        stringBuilder.append(FPortecle.RB.getString("NovellCertClassValid." + bl2));
        stringBuilder.append("</li></ul>");
        stringBuilder.append(FPortecle.RB.getString("NovellEnterpriseID"));
        stringBuilder.append(' ').append(FPortecle.RB.getString("DecodeNotImplemented"));
        return stringBuilder.toString();
    }

    private CharSequence getNovellQualityAttr(ASN1Sequence aSN1Sequence) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = ((ASN1Boolean)aSN1Sequence.getObjectAt(0)).isTrue();
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellQualityEnforce"));
        stringBuilder.append(' ').append(bl).append("</li>");
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        int n = aSN1Sequence2.size();
        if (n > 0) {
            stringBuilder.append("<li>");
            stringBuilder.append(FPortecle.RB.getString("NovellCompusecQuality"));
            stringBuilder.append("<ul>");
            for (int i = 0; i < n; ++i) {
                object = (ASN1Sequence)aSN1Sequence2.getObjectAt(i);
                ASN1Integer aSN1Integer = (ASN1Integer)((ASN1Sequence)object).getObjectAt(0);
                long l = aSN1Integer.getValue().longValue();
                String string = X509Ext.getRes("NovellCompusecQuality." + l, "UnrecognisedNovellCompusecQuality");
                string = MessageFormat.format(string, aSN1Integer.getValue());
                stringBuilder.append("<li>").append(string);
                aSN1Integer = (ASN1Integer)((ASN1Sequence)object).getObjectAt(1);
                String string2 = l == 1L ? X509Ext.getRes("TCSECRating." + aSN1Integer.getValue(), "UnrecognisedTCSECRating") : FPortecle.RB.getString("UnrecognisedNovellQualityRating");
                string2 = MessageFormat.format(string2, aSN1Integer.getValue());
                stringBuilder.append("<ul><li>").append(FPortecle.RB.getString("NovellQualityRating"));
                stringBuilder.append(' ').append(string2).append("</li></ul>");
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul></li>");
        }
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellCryptoQuality"));
        stringBuilder.append(' ').append(FPortecle.RB.getString("DecodeNotImplemented"));
        stringBuilder.append("</li>");
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(3)).getValue();
        object = X509Ext.getRes("NovellKeyStorageQuality." + bigInteger, "UnrecognisedNovellKeyStorageQuality");
        stringBuilder.append("<li>").append(FPortecle.RB.getString("NovellKeyStorageQuality"));
        stringBuilder.append(": ").append(MessageFormat.format((String)object, bigInteger));
        stringBuilder.append("</li>");
        return stringBuilder;
    }

    private String getNetscapeCertificateTypeStringValue(byte[] byArray) throws IOException {
        int n = new NetscapeCertType((DERBitString)ASN1Primitive.fromByteArray(byArray)).intValue();
        StringBuilder stringBuilder = new StringBuilder();
        for (int n2 : NETSCAPE_CERT_TYPES) {
            if ((n & n2) != n2) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append("<br><br>");
            }
            stringBuilder.append(FPortecle.RB.getString("NetscapeCertificateType." + n2));
        }
        return stringBuilder.toString();
    }

    private String getNetscapeExtensionURLValue(byte[] byArray, LinkClass linkClass) throws IOException {
        String string = ASN1Primitive.fromByteArray(byArray).toString();
        return X509Ext.getLink(string, X509Ext.escapeHtml(string), linkClass).toString();
    }

    private String getCrlDistributionPointsStringValue(byte[] byArray) throws IOException {
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance(byArray);
        DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>");
        for (DistributionPoint distributionPoint : distributionPointArray) {
            GeneralNames generalNames;
            ReasonFlags reasonFlags;
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName != null) {
                stringBuilder.append("<li>");
                switch (distributionPointName.getType()) {
                    case 0: {
                        stringBuilder.append(FPortecle.RB.getString("CrlDistributionPoint.0.0"));
                        stringBuilder.append(": ");
                        stringBuilder.append(this.getGeneralNamesString((GeneralNames)distributionPointName.getName(), LinkClass.CRL));
                        break;
                    }
                    case 1: {
                        stringBuilder.append(FPortecle.RB.getString("CrlDistributionPoint.0.1"));
                        stringBuilder.append(": ");
                        stringBuilder.append(X509Ext.stringify(distributionPointName.getName()));
                        break;
                    }
                    default: {
                        stringBuilder.append(FPortecle.RB.getString("UnknownCrlDistributionPointName"));
                        stringBuilder.append(": ");
                        stringBuilder.append(X509Ext.stringify(distributionPointName.getName()));
                    }
                }
                stringBuilder.append("</li>");
            }
            if ((reasonFlags = distributionPoint.getReasons()) != null) {
                stringBuilder.append("<li>");
                stringBuilder.append(FPortecle.RB.getString("CrlDistributionPoint.1"));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.stringify(reasonFlags));
                stringBuilder.append("</li>");
            }
            if ((generalNames = distributionPoint.getCRLIssuer()) == null) continue;
            stringBuilder.append("<li>");
            stringBuilder.append(FPortecle.RB.getString("CrlDistributionPoint.2"));
            stringBuilder.append(": ");
            stringBuilder.append(this.getGeneralNamesString(generalNames, LinkClass.CRL));
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private String getCertificatePoliciesStringValue(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        int n = aSN1Sequence.size();
        for (int i = 0; i < n; ++i) {
            PolicyInformation policyInformation = PolicyInformation.getInstance(aSN1Sequence.getObjectAt(i));
            String string = policyInformation.getPolicyIdentifier().getId();
            stringBuilder.append("<ul><li>");
            stringBuilder.append(FPortecle.RB.getString("PolicyIdentifier"));
            stringBuilder.append(": ");
            stringBuilder.append(MessageFormat.format(X509Ext.getRes(string, "UnrecognisedPolicyIdentifier"), string));
            ASN1Sequence aSN1Sequence2 = policyInformation.getPolicyQualifiers();
            if (aSN1Sequence2 != null) {
                stringBuilder.append("<ul>");
                int n2 = aSN1Sequence2.size();
                for (int j = 0; j < n2; ++j) {
                    Object object;
                    ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence2.getObjectAt(j);
                    ASN1Encodable aSN1Encodable = aSN1Sequence3.getObjectAt(0);
                    String string2 = aSN1Encodable.toString();
                    stringBuilder.append("<li>");
                    stringBuilder.append(MessageFormat.format(X509Ext.getRes(string2, "UnrecognisedPolicyQualifier"), string2));
                    stringBuilder.append(": ");
                    ASN1Encodable aSN1Encodable2 = aSN1Sequence3.getObjectAt(1);
                    stringBuilder.append("<ul>");
                    if (aSN1Encodable.equals(PolicyQualifierId.id_qt_cps)) {
                        object = ((ASN1String)((Object)aSN1Encodable2)).getString();
                        stringBuilder.append("<li>");
                        stringBuilder.append(FPortecle.RB.getString("CpsUri"));
                        stringBuilder.append(": ");
                        stringBuilder.append(X509Ext.getLink((String)object, X509Ext.escapeHtml(object), LinkClass.BROWSER));
                        stringBuilder.append("</li>");
                    } else if (aSN1Encodable.equals(PolicyQualifierId.id_qt_unotice)) {
                        object = (ASN1Sequence)aSN1Encodable2;
                        int n3 = ((ASN1Sequence)object).size();
                        for (int k = 0; k < n3; ++k) {
                            ASN1Encodable aSN1Encodable3 = ((ASN1Sequence)object).getObjectAt(k);
                            if (aSN1Encodable3 instanceof ASN1String) {
                                stringBuilder.append("<li>");
                                stringBuilder.append(FPortecle.RB.getString("ExplicitText"));
                                stringBuilder.append(": ");
                                stringBuilder.append(X509Ext.stringify(aSN1Encodable3));
                                stringBuilder.append("</li>");
                                continue;
                            }
                            if (!(aSN1Encodable3 instanceof ASN1Sequence)) continue;
                            ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Encodable3;
                            String string3 = X509Ext.stringify(aSN1Sequence4.getObjectAt(0));
                            ASN1Sequence aSN1Sequence5 = (ASN1Sequence)aSN1Sequence4.getObjectAt(1);
                            StringBuilder stringBuilder2 = new StringBuilder();
                            int n4 = aSN1Sequence5.size();
                            for (int i2 = 0; i2 < n4; ++i2) {
                                stringBuilder2.append(X509Ext.stringify(aSN1Sequence5.getObjectAt(i2)));
                                if (i2 == n4 - 1) continue;
                                stringBuilder2.append(", ");
                            }
                            stringBuilder.append("<li>");
                            stringBuilder.append(FPortecle.RB.getString("NoticeRef"));
                            stringBuilder.append(": ");
                            stringBuilder.append(FPortecle.RB.getString("NoticeRefOrganization"));
                            stringBuilder.append(": ");
                            stringBuilder.append(string3);
                            if (stringBuilder2.length() != 0) {
                                stringBuilder.append(", ");
                                stringBuilder.append(FPortecle.RB.getString("NoticeRefNumber"));
                                stringBuilder.append(": ");
                                stringBuilder.append((CharSequence)stringBuilder2);
                            }
                            stringBuilder.append("</li>");
                        }
                    } else {
                        stringBuilder.append(X509Ext.stringify(aSN1Encodable2));
                    }
                    stringBuilder.append("</ul></li>");
                }
                stringBuilder.append("</ul></li>");
            }
            stringBuilder.append("</ul>");
            if (i == n - 1) continue;
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    private String getGeneralNameString(GeneralName generalName, LinkClass linkClass) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = generalName.getTagNo();
        switch (n) {
            case 0: {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)generalName.getName();
                String string = ((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId();
                String string2 = X509Ext.stringify(aSN1Sequence.getObjectAt(1));
                try {
                    stringBuilder.append(FPortecle.RB.getString(string));
                }
                catch (MissingResourceException missingResourceException) {
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("GeneralName." + n), string));
                }
                stringBuilder.append(": ");
                stringBuilder.append(string2);
                break;
            }
            case 1: {
                String string = generalName.getName().toString();
                String string3 = URLEncoder.encode(string, StandardCharsets.UTF_8.name());
                stringBuilder.append(FPortecle.RB.getString("GeneralName." + n));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.getLink("mailto:" + string3, X509Ext.escapeHtml(string), null));
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                stringBuilder.append(FPortecle.RB.getString("GeneralName." + n));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.escapeHtml(generalName.getName()));
                break;
            }
            case 4: {
                ASN1Encodable aSN1Encodable = generalName.getName();
                stringBuilder.append(FPortecle.RB.getString("GeneralName." + n));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.escapeHtml(aSN1Encodable));
                break;
            }
            case 6: {
                String string = generalName.getName().toString();
                stringBuilder.append(FPortecle.RB.getString("GeneralName." + n));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.getLink(string, X509Ext.escapeHtml(string), linkClass));
                break;
            }
            case 7: {
                ASN1OctetString aSN1OctetString = (ASN1OctetString)generalName.getName();
                byte[] byArray = aSN1OctetString.getOctets();
                StringBuilder stringBuilder2 = new StringBuilder();
                int n2 = byArray.length;
                for (int i = 0; i < n2; ++i) {
                    stringBuilder2.append(byArray[i] & 0xFF);
                    if (i + 1 >= byArray.length) continue;
                    stringBuilder2.append('.');
                }
                stringBuilder.append(FPortecle.RB.getString("GeneralName." + n));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.escapeHtml(stringBuilder2));
                break;
            }
            default: {
                stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("UnrecognizedGeneralNameType"), generalName.getTagNo()));
                stringBuilder.append(": ");
                stringBuilder.append(X509Ext.escapeHtml(generalName.getName()));
            }
        }
        return stringBuilder.toString();
    }

    private String getGeneralNamesString(GeneralNames generalNames, LinkClass linkClass) throws IOException {
        GeneralName[] generalNameArray = generalNames.getNames();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<ul>");
        for (GeneralName generalName : generalNameArray) {
            stringBuilder.append("<li>");
            stringBuilder.append(this.getGeneralNameString(generalName, linkClass));
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }

    private String getASN1ObjectString(byte[] byArray) throws IOException {
        return X509Ext.escapeHtml(ASN1Primitive.fromByteArray(byArray));
    }

    private String formatGeneralizedTime(ASN1GeneralizedTime aSN1GeneralizedTime) throws ParseException {
        String string = aSN1GeneralizedTime.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        Date date = simpleDateFormat.parse(string);
        string = DateFormat.getDateTimeInstance(2, 1).format(date);
        return X509Ext.escapeHtml(string);
    }

    private String getHexClearDump(byte[] byArray, int n) {
        int n2;
        int n3;
        Object object;
        StringBuilder stringBuilder;
        if (n == byArray.length) {
            stringBuilder = StringUtil.toHex(byArray, 2, " ");
        } else {
            object = Arrays.copyOfRange(byArray, 0, n);
            stringBuilder = StringUtil.toHex(object, 2, " ");
        }
        object = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            n3 = byArray[i] & 0xFF;
            n2 = n3;
            if (Character.isISOControl((char)n2) || !Character.isDefined((char)n2)) {
                n2 = 46;
            }
            ((StringBuilder)object).append((char)n2);
        }
        StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length() + ((StringBuilder)object).length() + 4);
        stringBuilder2.append((CharSequence)stringBuilder);
        n3 = byArray.length - n;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder2.append("   ");
        }
        stringBuilder2.append("   ");
        stringBuilder2.append((CharSequence)object);
        stringBuilder2.append('\n');
        return stringBuilder2.toString();
    }

    private static String convertToHexString(Object object) {
        StringBuilder stringBuilder = StringUtil.toHex(object, 4, " ");
        stringBuilder.insert(0, "<tt>");
        stringBuilder.append("</tt>");
        return stringBuilder.toString();
    }

    private static String stringify(Object object) {
        if (object instanceof ASN1String) {
            return X509Ext.escapeHtml(((ASN1String)object).getString());
        }
        if (object instanceof ASN1Integer || object instanceof byte[]) {
            return X509Ext.convertToHexString(object);
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            return "[" + aSN1TaggedObject.getTagNo() + "] " + X509Ext.stringify(aSN1TaggedObject.getObject());
        }
        if (object instanceof ASN1Sequence) {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)object;
            StringBuilder stringBuilder = new StringBuilder("[");
            int n = aSN1Sequence.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(X509Ext.stringify(aSN1Sequence.getObjectAt(i)));
                if (i == n - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.append("]").toString();
        }
        String string = null;
        try {
            Method method = object.getClass().getMethod("getOctets", null);
            string = X509Ext.convertToHexString(method.invoke(object, (Object[])null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && object != null) {
            string = X509Ext.escapeHtml(object.toString());
        }
        return string;
    }

    private static String getRes(String string, String string2) {
        try {
            return FPortecle.RB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return FPortecle.RB.getString(string2);
        }
    }

    private static String escapeHtml(Object object) {
        if (object == null) {
            return "";
        }
        String string = object.toString();
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string.replace("\"", "&quot;");
    }

    private static CharSequence getLink(String string, String string2, LinkClass linkClass) {
        StringBuilder stringBuilder = new StringBuilder("<a href=\"");
        stringBuilder.append(X509Ext.escapeHtml(string));
        stringBuilder.append("\"");
        if (linkClass != null) {
            stringBuilder.append(" class=\"");
            stringBuilder.append((Object)linkClass);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        stringBuilder.append(string2);
        stringBuilder.append("</a>");
        return stringBuilder;
    }

    public static enum LinkClass {
        BROWSER,
        OCSP,
        CRL,
        CERTIFICATE;

    }
}

