/*
 *  L3Stat.cpp, part of the L3 project for handling LDraw *.dat files
 *  Copyright (C) 1999  Lars C. Hassing
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*****************************************************************************
  Please do not edit this file. In stead contact Lars C. Hassing (lch@cci.dk)
  to get your changes integrated and you will receive an up-to-date version.
*****************************************************************************/

/* L3Stat.cpp  Statistics routines for L3 program */
/*
990128 lch First version, both for TurboC 2.0 and Visual C++ 5.0
*/

#ifdef USE_OPENGL
// Gotta prepare for case sensitive file systems.
#include "StdAfx.h"
#else
#include "stdafx.h"
#endif

#include "L3Def.h"
#include "time.h"               /* clock */
#include <stdarg.h>
#include "mmsystem.h"           /* timeGetTime + link with winmm.lib */

/* Return milliseconds */
L3Time_t L3GetTime(void)
{
#ifdef _TURBOC_
   return (L3Time_t) clock();
#else
   return (L3Time_t) timeGetTime();
#endif
}

