/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.javacc.parser.Action;
import org.javacc.parser.Choice;
import org.javacc.parser.Expansion;
import org.javacc.parser.ExpansionTreeWalker;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Lookahead;
import org.javacc.parser.LookaheadCalc;
import org.javacc.parser.MetaParseException;
import org.javacc.parser.NonTerminal;
import org.javacc.parser.NormalProduction;
import org.javacc.parser.OneOrMore;
import org.javacc.parser.Options;
import org.javacc.parser.RChoice;
import org.javacc.parser.REndOfFile;
import org.javacc.parser.RJustName;
import org.javacc.parser.ROneOrMore;
import org.javacc.parser.RRepetitionRange;
import org.javacc.parser.RSequence;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RZeroOrMore;
import org.javacc.parser.RZeroOrOne;
import org.javacc.parser.RegExprSpec;
import org.javacc.parser.RegularExpression;
import org.javacc.parser.Sequence;
import org.javacc.parser.TokenProduction;
import org.javacc.parser.TreeWalkerOp;
import org.javacc.parser.TryBlock;
import org.javacc.parser.ZeroOrMore;
import org.javacc.parser.ZeroOrOne;

public class Semanticize
extends JavaCCGlobals {
    static List removeList = new ArrayList();
    static List itemList = new ArrayList();
    public static RegularExpression other;
    private static String loopString;

    static void prepareToRemove(List vec, Object item) {
        removeList.add(vec);
        itemList.add(item);
    }

    static void removePreparedItems() {
        for (int i = 0; i < removeList.size(); ++i) {
            List list = (List)removeList.get(i);
            list.remove(itemList.get(i));
        }
        removeList.clear();
        itemList.clear();
    }

    public static void start() throws MetaParseException {
        RegularExpression rexp;
        List<RegExprSpec> respecs;
        List<RegExprSpec> respecs2;
        if (JavaCCErrors.get_error_count() != 0) {
            throw new MetaParseException();
        }
        if (Options.getLookahead() > 1 && !Options.getForceLaCheck() && Options.getSanityCheck()) {
            JavaCCErrors.warning("Lookahead adequacy checking not being performed since option LOOKAHEAD is more than 1.  Set option FORCE_LA_CHECK to true to force checking.");
        }
        Iterator it = bnfproductions.iterator();
        while (it.hasNext()) {
            ExpansionTreeWalker.postOrderWalk(((NormalProduction)it.next()).getExpansion(), new LookaheadFixer());
        }
        for (NormalProduction p : bnfproductions) {
            if (production_table.put(p.getLhs(), p) == null) continue;
            JavaCCErrors.semantic_error(p, p.getLhs() + " occurs on the left hand side of more than one production.");
        }
        it = bnfproductions.iterator();
        while (it.hasNext()) {
            ExpansionTreeWalker.preOrderWalk(((NormalProduction)it.next()).getExpansion(), new ProductionDefinedChecker());
        }
        for (TokenProduction tp : rexprlist) {
            respecs2 = tp.respecs;
            for (RegExprSpec res : respecs2) {
                if (res.nextState != null && lexstate_S2I.get(res.nextState) == null) {
                    JavaCCErrors.semantic_error(res.nsTok, "Lexical state \"" + res.nextState + "\" has not been defined.");
                }
                if (res.rexp instanceof REndOfFile) {
                    if (tp.lexStates != null) {
                        JavaCCErrors.semantic_error(res.rexp, "EOF action/state change must be specified for all states, i.e., <*>TOKEN:.");
                    }
                    if (tp.kind != 0) {
                        JavaCCErrors.semantic_error(res.rexp, "EOF action/state change can be specified only in a TOKEN specification.");
                    }
                    if (nextStateForEof != null || actForEof != null) {
                        JavaCCErrors.semantic_error(res.rexp, "Duplicate action/state change specification for <EOF>.");
                    }
                    actForEof = res.act;
                    nextStateForEof = res.nextState;
                    Semanticize.prepareToRemove(respecs2, res);
                    continue;
                }
                if (tp.isExplicit && Options.getUserTokenManager()) {
                    JavaCCErrors.warning(res.rexp, "Ignoring regular expression specification since option USER_TOKEN_MANAGER has been set to true.");
                    continue;
                }
                if (tp.isExplicit && !Options.getUserTokenManager() && res.rexp instanceof RJustName) {
                    JavaCCErrors.warning(res.rexp, "Ignoring free-standing regular expression reference.  If you really want this, you must give it a different label as <NEWLABEL:<" + res.rexp.label + ">>.");
                    Semanticize.prepareToRemove(respecs2, res);
                    continue;
                }
                if (tp.isExplicit || !res.rexp.private_rexp) continue;
                JavaCCErrors.semantic_error(res.rexp, "Private (#) regular expression cannot be defined within grammar productions.");
            }
        }
        Semanticize.removePreparedItems();
        for (TokenProduction tp : rexprlist) {
            respecs2 = tp.respecs;
            for (RegExprSpec res : respecs2) {
                if (res.rexp instanceof RJustName || res.rexp.label.equals("")) continue;
                String s = res.rexp.label;
                RegularExpression obj = named_tokens_table.put(s, res.rexp);
                if (obj != null) {
                    JavaCCErrors.semantic_error(res.rexp, "Multiply defined lexical token name \"" + s + "\".");
                } else {
                    ordered_named_tokens.add(res.rexp);
                }
                if (lexstate_S2I.get(s) == null) continue;
                JavaCCErrors.semantic_error(res.rexp, "Lexical token name \"" + s + "\" is the same as that of a lexical state.");
            }
        }
        tokenCount = 1;
        for (TokenProduction tp : rexprlist) {
            respecs2 = tp.respecs;
            if (tp.lexStates == null) {
                tp.lexStates = new String[lexstate_I2S.size()];
                int i = 0;
                Enumeration enum1 = lexstate_I2S.elements();
                while (enum1.hasMoreElements()) {
                    tp.lexStates[i++] = (String)enum1.nextElement();
                }
            }
            Hashtable[] table = new Hashtable[tp.lexStates.length];
            for (int i = 0; i < tp.lexStates.length; ++i) {
                table[i] = (Hashtable)simple_tokens_table.get(tp.lexStates[i]);
            }
            for (RegExprSpec res : respecs2) {
                if (res.rexp instanceof RStringLiteral) {
                    RStringLiteral sl = (RStringLiteral)res.rexp;
                    for (int i = 0; i < table.length; ++i) {
                        Hashtable<String, RStringLiteral> table2 = (Hashtable<String, RStringLiteral>)table[i].get(sl.image.toUpperCase());
                        if (table2 == null) {
                            if (sl.ordinal == 0) {
                                ++tokenCount;
                                sl.ordinal = sl.ordinal;
                            }
                            table2 = new Hashtable<String, RStringLiteral>();
                            table2.put(sl.image, sl);
                            table[i].put(sl.image.toUpperCase(), table2);
                            continue;
                        }
                        if (Semanticize.hasIgnoreCase((Hashtable<String, RegularExpression>)table2, sl.image)) {
                            if (!sl.tpContext.isExplicit) {
                                JavaCCErrors.semantic_error(sl, "String \"" + sl.image + "\" can never be matched due to presence of more general (IGNORE_CASE) regular expression at line " + other.getLine() + ", column " + other.getColumn() + ".");
                                continue;
                            }
                            JavaCCErrors.semantic_error(sl, "Duplicate definition of string token \"" + sl.image + "\" can never be matched.");
                            continue;
                        }
                        if (sl.tpContext.ignoreCase) {
                            String pos = "";
                            int count = 0;
                            Enumeration enum2 = table2.elements();
                            while (enum2.hasMoreElements()) {
                                RegularExpression rexp2 = (RegularExpression)enum2.nextElement();
                                if (count != 0) {
                                    pos = pos + ",";
                                }
                                pos = pos + " line " + rexp2.getLine();
                                ++count;
                            }
                            if (count == 1) {
                                JavaCCErrors.warning(sl, "String with IGNORE_CASE is partially superseded by string at" + pos + ".");
                            } else {
                                JavaCCErrors.warning(sl, "String with IGNORE_CASE is partially superseded by strings at" + pos + ".");
                            }
                            if (sl.ordinal == 0) {
                                ++tokenCount;
                                sl.ordinal = sl.ordinal;
                            }
                            table2.put(sl.image, sl);
                            continue;
                        }
                        RegularExpression re = (RegularExpression)table2.get(sl.image);
                        if (re == null) {
                            if (sl.ordinal == 0) {
                                ++tokenCount;
                                sl.ordinal = sl.ordinal;
                            }
                            table2.put(sl.image, sl);
                            continue;
                        }
                        if (tp.isExplicit) {
                            if (tp.lexStates[i].equals("DEFAULT")) {
                                JavaCCErrors.semantic_error(sl, "Duplicate definition of string token \"" + sl.image + "\".");
                                continue;
                            }
                            JavaCCErrors.semantic_error(sl, "Duplicate definition of string token \"" + sl.image + "\" in lexical state \"" + tp.lexStates[i] + "\".");
                            continue;
                        }
                        if (re.tpContext.kind != 0) {
                            JavaCCErrors.semantic_error(sl, "String token \"" + sl.image + "\" has been defined as a \"" + TokenProduction.kindImage[re.tpContext.kind] + "\" token.");
                            continue;
                        }
                        if (re.private_rexp) {
                            JavaCCErrors.semantic_error(sl, "String token \"" + sl.image + "\" has been defined as a private regular expression.");
                            continue;
                        }
                        sl.ordinal = re.ordinal;
                        Semanticize.prepareToRemove(respecs2, res);
                    }
                } else if (!(res.rexp instanceof RJustName)) {
                    ++tokenCount;
                    res.rexp.ordinal = res.rexp.ordinal;
                }
                if (!(res.rexp instanceof RJustName) && !res.rexp.label.equals("")) {
                    names_of_tokens.put(new Integer(res.rexp.ordinal), res.rexp.label);
                }
                if (res.rexp instanceof RJustName) continue;
                rexps_of_tokens.put(new Integer(res.rexp.ordinal), res.rexp);
            }
        }
        Semanticize.removePreparedItems();
        if (!Options.getUserTokenManager()) {
            FixRJustNames frjn = new FixRJustNames();
            for (TokenProduction tp : rexprlist) {
                respecs = tp.respecs;
                for (RegExprSpec res : respecs) {
                    frjn.root = res.rexp;
                    ExpansionTreeWalker.preOrderWalk(res.rexp, frjn);
                    if (!(res.rexp instanceof RJustName)) continue;
                    Semanticize.prepareToRemove(respecs, res);
                }
            }
        }
        Semanticize.removePreparedItems();
        if (Options.getUserTokenManager()) {
            for (TokenProduction tp : rexprlist) {
                respecs2 = tp.respecs;
                for (RegExprSpec res : respecs2) {
                    if (!(res.rexp instanceof RJustName)) continue;
                    RJustName jn = (RJustName)res.rexp;
                    rexp = (RegularExpression)named_tokens_table.get(jn.label);
                    if (rexp == null) {
                        ++tokenCount;
                        jn.ordinal = jn.ordinal;
                        named_tokens_table.put(jn.label, jn);
                        ordered_named_tokens.add(jn);
                        names_of_tokens.put(new Integer(jn.ordinal), jn.label);
                        continue;
                    }
                    jn.ordinal = rexp.ordinal;
                    Semanticize.prepareToRemove(respecs2, res);
                }
            }
        }
        Semanticize.removePreparedItems();
        if (Options.getUserTokenManager()) {
            for (TokenProduction tp : rexprlist) {
                respecs2 = tp.respecs;
                for (RegExprSpec res : respecs2) {
                    Integer ii = new Integer(res.rexp.ordinal);
                    if (names_of_tokens.get(ii) != null) continue;
                    JavaCCErrors.warning(res.rexp, "Unlabeled regular expression cannot be referred to by user generated token manager.");
                }
            }
        }
        if (JavaCCErrors.get_error_count() != 0) {
            throw new MetaParseException();
        }
        boolean emptyUpdate = true;
        while (emptyUpdate) {
            emptyUpdate = false;
            for (NormalProduction prod : bnfproductions) {
                if (!Semanticize.emptyExpansionExists(prod.getExpansion()) || prod.isEmptyPossible()) continue;
                emptyUpdate = prod.setEmptyPossible(true);
            }
        }
        if (Options.getSanityCheck() && JavaCCErrors.get_error_count() == 0) {
            Iterator it2 = bnfproductions.iterator();
            while (it2.hasNext()) {
                ExpansionTreeWalker.preOrderWalk(((NormalProduction)it2.next()).getExpansion(), new EmptyChecker());
            }
            for (NormalProduction prod : bnfproductions) {
                Semanticize.addLeftMost(prod, prod.getExpansion());
            }
            for (NormalProduction prod : bnfproductions) {
                if (prod.getWalkStatus() != 0) continue;
                Semanticize.prodWalk(prod);
            }
            if (!Options.getUserTokenManager()) {
                for (TokenProduction tp : rexprlist) {
                    respecs = tp.respecs;
                    for (RegExprSpec res : respecs) {
                        rexp = res.rexp;
                        if (rexp.walkStatus != 0) continue;
                        rexp.walkStatus = -1;
                        if (Semanticize.rexpWalk(rexp)) {
                            loopString = "..." + rexp.label + "... --> " + loopString;
                            JavaCCErrors.semantic_error(rexp, "Loop in regular expression detected: \"" + loopString + "\"");
                        }
                        rexp.walkStatus = 1;
                    }
                }
            }
            if (JavaCCErrors.get_error_count() == 0) {
                it2 = bnfproductions.iterator();
                while (it2.hasNext()) {
                    ExpansionTreeWalker.preOrderWalk(((NormalProduction)it2.next()).getExpansion(), new LookaheadChecker());
                }
            }
        }
        if (JavaCCErrors.get_error_count() != 0) {
            throw new MetaParseException();
        }
    }

    public static boolean hasIgnoreCase(Hashtable<String, RegularExpression> table, String str) {
        RegularExpression rexp = table.get(str);
        if (rexp != null && !rexp.tpContext.ignoreCase) {
            return false;
        }
        Enumeration<RegularExpression> enumeration = table.elements();
        while (enumeration.hasMoreElements()) {
            rexp = enumeration.nextElement();
            if (!rexp.tpContext.ignoreCase) continue;
            other = rexp;
            return true;
        }
        return false;
    }

    public static boolean emptyExpansionExists(Expansion exp) {
        if (exp instanceof NonTerminal) {
            return ((NonTerminal)exp).getProd().isEmptyPossible();
        }
        if (exp instanceof Action) {
            return true;
        }
        if (exp instanceof RegularExpression) {
            return false;
        }
        if (exp instanceof OneOrMore) {
            return Semanticize.emptyExpansionExists(((OneOrMore)exp).expansion);
        }
        if (exp instanceof ZeroOrMore || exp instanceof ZeroOrOne) {
            return true;
        }
        if (exp instanceof Lookahead) {
            return true;
        }
        if (exp instanceof Choice) {
            Iterator<? super Object> it = ((Choice)exp).getChoices().iterator();
            while (it.hasNext()) {
                if (!Semanticize.emptyExpansionExists((Expansion)it.next())) continue;
                return true;
            }
            return false;
        }
        if (exp instanceof Sequence) {
            Iterator<? super Object> it = ((Sequence)exp).units.iterator();
            while (it.hasNext()) {
                if (Semanticize.emptyExpansionExists((Expansion)it.next())) continue;
                return false;
            }
            return true;
        }
        if (exp instanceof TryBlock) {
            return Semanticize.emptyExpansionExists(((TryBlock)exp).exp);
        }
        return false;
    }

    private static void addLeftMost(NormalProduction prod, Expansion exp) {
        if (exp instanceof NonTerminal) {
            for (int i = 0; i < prod.leIndex; ++i) {
                if (prod.getLeftExpansions()[i] != ((NonTerminal)exp).getProd()) continue;
                return;
            }
            if (prod.leIndex == prod.getLeftExpansions().length) {
                NormalProduction[] newle = new NormalProduction[prod.leIndex * 2];
                System.arraycopy(prod.getLeftExpansions(), 0, newle, 0, prod.leIndex);
                prod.setLeftExpansions(newle);
            }
            prod.getLeftExpansions()[prod.leIndex++] = ((NonTerminal)exp).getProd();
        } else if (exp instanceof OneOrMore) {
            Semanticize.addLeftMost(prod, ((OneOrMore)exp).expansion);
        } else if (exp instanceof ZeroOrMore) {
            Semanticize.addLeftMost(prod, ((ZeroOrMore)exp).expansion);
        } else if (exp instanceof ZeroOrOne) {
            Semanticize.addLeftMost(prod, ((ZeroOrOne)exp).expansion);
        } else if (exp instanceof Choice) {
            Iterator<? super Object> it = ((Choice)exp).getChoices().iterator();
            while (it.hasNext()) {
                Semanticize.addLeftMost(prod, (Expansion)it.next());
            }
        } else if (exp instanceof Sequence) {
            for (Expansion expansion : ((Sequence)exp).units) {
                Semanticize.addLeftMost(prod, expansion);
                if (Semanticize.emptyExpansionExists(expansion)) continue;
                break;
            }
        } else if (exp instanceof TryBlock) {
            Semanticize.addLeftMost(prod, ((TryBlock)exp).exp);
        }
    }

    private static boolean prodWalk(NormalProduction prod) {
        prod.setWalkStatus(-1);
        for (int i = 0; i < prod.leIndex; ++i) {
            if (prod.getLeftExpansions()[i].getWalkStatus() == -1) {
                prod.getLeftExpansions()[i].setWalkStatus(-2);
                loopString = prod.getLhs() + "... --> " + prod.getLeftExpansions()[i].getLhs() + "...";
                if (prod.getWalkStatus() == -2) {
                    prod.setWalkStatus(1);
                    JavaCCErrors.semantic_error(prod, "Left recursion detected: \"" + loopString + "\"");
                    return false;
                }
                prod.setWalkStatus(1);
                return true;
            }
            if (prod.getLeftExpansions()[i].getWalkStatus() != 0 || !Semanticize.prodWalk(prod.getLeftExpansions()[i])) continue;
            loopString = prod.getLhs() + "... --> " + loopString;
            if (prod.getWalkStatus() == -2) {
                prod.setWalkStatus(1);
                JavaCCErrors.semantic_error(prod, "Left recursion detected: \"" + loopString + "\"");
                return false;
            }
            prod.setWalkStatus(1);
            return true;
        }
        prod.setWalkStatus(1);
        return false;
    }

    private static boolean rexpWalk(RegularExpression rexp) {
        if (rexp instanceof RJustName) {
            RJustName jn = (RJustName)rexp;
            if (jn.regexpr.walkStatus == -1) {
                jn.regexpr.walkStatus = -2;
                loopString = "..." + jn.regexpr.label + "...";
                return true;
            }
            if (jn.regexpr.walkStatus == 0) {
                jn.regexpr.walkStatus = -1;
                if (Semanticize.rexpWalk(jn.regexpr)) {
                    loopString = "..." + jn.regexpr.label + "... --> " + loopString;
                    if (jn.regexpr.walkStatus == -2) {
                        jn.regexpr.walkStatus = 1;
                        JavaCCErrors.semantic_error(jn.regexpr, "Loop in regular expression detected: \"" + loopString + "\"");
                        return false;
                    }
                    jn.regexpr.walkStatus = 1;
                    return true;
                }
                jn.regexpr.walkStatus = 1;
                return false;
            }
        } else {
            if (rexp instanceof RChoice) {
                Iterator it = ((RChoice)rexp).getChoices().iterator();
                while (it.hasNext()) {
                    if (!Semanticize.rexpWalk((RegularExpression)it.next())) continue;
                    return true;
                }
                return false;
            }
            if (rexp instanceof RSequence) {
                Iterator<? super Object> it = ((RSequence)rexp).units.iterator();
                while (it.hasNext()) {
                    if (!Semanticize.rexpWalk((RegularExpression)it.next())) continue;
                    return true;
                }
                return false;
            }
            if (rexp instanceof ROneOrMore) {
                return Semanticize.rexpWalk(((ROneOrMore)rexp).regexpr);
            }
            if (rexp instanceof RZeroOrMore) {
                return Semanticize.rexpWalk(((RZeroOrMore)rexp).regexpr);
            }
            if (rexp instanceof RZeroOrOne) {
                return Semanticize.rexpWalk(((RZeroOrOne)rexp).regexpr);
            }
            if (rexp instanceof RRepetitionRange) {
                return Semanticize.rexpWalk(((RRepetitionRange)rexp).regexpr);
            }
        }
        return false;
    }

    public static void reInit() {
        removeList = new ArrayList();
        itemList = new ArrayList();
        other = null;
        loopString = null;
    }

    static class LookaheadChecker
    extends JavaCCGlobals
    implements TreeWalkerOp {
        LookaheadChecker() {
        }

        @Override
        public boolean goDeeper(Expansion e) {
            if (e instanceof RegularExpression) {
                return false;
            }
            return !(e instanceof Lookahead);
        }

        @Override
        public void action(Expansion e) {
            if (e instanceof Choice) {
                if (Options.getLookahead() == 1 || Options.getForceLaCheck()) {
                    LookaheadCalc.choiceCalc((Choice)e);
                }
            } else if (e instanceof OneOrMore) {
                OneOrMore exp = (OneOrMore)e;
                if (Options.getForceLaCheck() || LookaheadChecker.implicitLA(exp.expansion) && Options.getLookahead() == 1) {
                    LookaheadCalc.ebnfCalc(exp, exp.expansion);
                }
            } else if (e instanceof ZeroOrMore) {
                ZeroOrMore exp = (ZeroOrMore)e;
                if (Options.getForceLaCheck() || LookaheadChecker.implicitLA(exp.expansion) && Options.getLookahead() == 1) {
                    LookaheadCalc.ebnfCalc(exp, exp.expansion);
                }
            } else if (e instanceof ZeroOrOne) {
                ZeroOrOne exp = (ZeroOrOne)e;
                if (Options.getForceLaCheck() || LookaheadChecker.implicitLA(exp.expansion) && Options.getLookahead() == 1) {
                    LookaheadCalc.ebnfCalc(exp, exp.expansion);
                }
            }
        }

        static boolean implicitLA(Expansion exp) {
            if (!(exp instanceof Sequence)) {
                return true;
            }
            Sequence seq = (Sequence)exp;
            Object obj = seq.units.get(0);
            if (!(obj instanceof Lookahead)) {
                return true;
            }
            Lookahead la = (Lookahead)obj;
            return !la.isExplicit();
        }
    }

    static class EmptyChecker
    extends JavaCCGlobals
    implements TreeWalkerOp {
        EmptyChecker() {
        }

        @Override
        public boolean goDeeper(Expansion e) {
            return !(e instanceof RegularExpression);
        }

        @Override
        public void action(Expansion e) {
            if (e instanceof OneOrMore) {
                if (Semanticize.emptyExpansionExists(((OneOrMore)e).expansion)) {
                    JavaCCErrors.semantic_error(e, "Expansion within \"(...)+\" can be matched by empty string.");
                }
            } else if (e instanceof ZeroOrMore) {
                if (Semanticize.emptyExpansionExists(((ZeroOrMore)e).expansion)) {
                    JavaCCErrors.semantic_error(e, "Expansion within \"(...)*\" can be matched by empty string.");
                }
            } else if (e instanceof ZeroOrOne && Semanticize.emptyExpansionExists(((ZeroOrOne)e).expansion)) {
                JavaCCErrors.semantic_error(e, "Expansion within \"(...)?\" can be matched by empty string.");
            }
        }
    }

    static class ProductionDefinedChecker
    extends JavaCCGlobals
    implements TreeWalkerOp {
        ProductionDefinedChecker() {
        }

        @Override
        public boolean goDeeper(Expansion e) {
            return !(e instanceof RegularExpression);
        }

        @Override
        public void action(Expansion e) {
            if (e instanceof NonTerminal) {
                NonTerminal nt = (NonTerminal)e;
                if (nt.setProd((NormalProduction)production_table.get(nt.getName())) == null) {
                    JavaCCErrors.semantic_error(e, "Non-terminal " + nt.getName() + " has not been defined.");
                } else {
                    nt.getProd().getParents().add(nt);
                }
            }
        }
    }

    static class LookaheadFixer
    extends JavaCCGlobals
    implements TreeWalkerOp {
        LookaheadFixer() {
        }

        @Override
        public boolean goDeeper(Expansion e) {
            return !(e instanceof RegularExpression);
        }

        @Override
        public void action(Expansion e) {
            if (e instanceof Sequence) {
                if (e.parent instanceof Choice || e.parent instanceof ZeroOrMore || e.parent instanceof OneOrMore || e.parent instanceof ZeroOrOne) {
                    return;
                }
                Sequence seq = (Sequence)e;
                Lookahead la = (Lookahead)seq.units.get(0);
                if (!la.isExplicit()) {
                    return;
                }
                Choice ch = new Choice();
                ch.setLine(la.getLine());
                ch.setColumn(la.getColumn());
                ch.parent = seq;
                Sequence seq1 = new Sequence();
                seq1.setLine(la.getLine());
                seq1.setColumn(la.getColumn());
                seq1.parent = ch;
                seq1.units.add(la);
                la.parent = seq1;
                Action act = new Action();
                act.setLine(la.getLine());
                act.setColumn(la.getColumn());
                act.parent = seq1;
                seq1.units.add(act);
                ch.getChoices().add(seq1);
                if (la.getAmount() != 0) {
                    if (la.getActionTokens().size() != 0) {
                        JavaCCErrors.warning(la, "Encountered LOOKAHEAD(...) at a non-choice location.  Only semantic lookahead will be considered here.");
                    } else {
                        JavaCCErrors.warning(la, "Encountered LOOKAHEAD(...) at a non-choice location.  This will be ignored.");
                    }
                }
                Lookahead la1 = new Lookahead();
                la1.setExplicit(false);
                la1.setLine(la.getLine());
                la1.setColumn(la.getColumn());
                la1.parent = seq;
                la.setLaExpansion(new REndOfFile());
                la1.setLaExpansion(new REndOfFile());
                seq.units.set(0, la1);
                seq.units.add(1, ch);
            }
        }
    }

    static class FixRJustNames
    extends JavaCCGlobals
    implements TreeWalkerOp {
        public RegularExpression root;

        FixRJustNames() {
        }

        @Override
        public boolean goDeeper(Expansion e) {
            return true;
        }

        @Override
        public void action(Expansion e) {
            if (e instanceof RJustName) {
                RJustName jn = (RJustName)e;
                RegularExpression rexp = (RegularExpression)named_tokens_table.get(jn.label);
                if (rexp == null) {
                    JavaCCErrors.semantic_error(e, "Undefined lexical token name \"" + jn.label + "\".");
                } else if (jn == this.root && !jn.tpContext.isExplicit && rexp.private_rexp) {
                    JavaCCErrors.semantic_error(e, "Token name \"" + jn.label + "\" refers to a private (with a #) regular expression.");
                } else if (jn == this.root && !jn.tpContext.isExplicit && rexp.tpContext.kind != 0) {
                    JavaCCErrors.semantic_error(e, "Token name \"" + jn.label + "\" refers to a non-token (SKIP, MORE, IGNORE_IN_BNF) regular expression.");
                } else {
                    jn.ordinal = rexp.ordinal;
                    jn.regexpr = rexp;
                }
            }
        }
    }
}

