/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.SaveState;

public class AddressFieldOptionsWrappedOption
implements CustomOption {
    private static final String PAD_WITH_ZEROS = "PadWithZeros";
    private static final String MIN_HEXL_DIGITS = "MinHexDigits";
    private static final String RIGHT_JUSTIFY = "RightJustify";
    private static final String SHOW_BLOCK_NAME = "ShowBlockName";
    private static final boolean DEFAULT_PAD_WITH_ZEROS = false;
    private static final boolean DEFAULT_SHOW_BLOCK_NAME = false;
    private static final boolean DEFAULT_RIGHT_JUSTIFY = true;
    private static final int DEFAULT_MIN_HEX_DIGITS = 8;
    private boolean padWithZeros = false;
    private boolean showBlockName = false;
    private boolean rightJustify = true;
    private int minHexDigits = 8;

    public boolean padWithZeros() {
        return this.padWithZeros;
    }

    public int getMinimumHexDigits() {
        return this.minHexDigits;
    }

    public boolean rightJustify() {
        return this.rightJustify;
    }

    public boolean showBlockName() {
        return this.showBlockName;
    }

    public void setPadWithZeros(boolean padWithZeros) {
        this.padWithZeros = padWithZeros;
    }

    public void setMinimumHexDigits(int numDigits) {
        this.minHexDigits = numDigits;
    }

    public void setShowBlockName(boolean b) {
        this.showBlockName = b;
    }

    public void setRightJustify(boolean b) {
        this.rightJustify = b;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddressFieldOptionsWrappedOption)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AddressFieldOptionsWrappedOption otherOption = (AddressFieldOptionsWrappedOption)obj;
        return this.padWithZeros == otherOption.padWithZeros && this.minHexDigits == otherOption.minHexDigits && this.rightJustify == otherOption.rightJustify && this.showBlockName == otherOption.showBlockName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.padWithZeros ? 1 : 0);
        result = prime * result + (this.rightJustify ? 1 : 0);
        result = prime * result + (this.showBlockName ? 1 : 0);
        result = prime * result + this.minHexDigits;
        return result;
    }

    public void readState(SaveState saveState) {
        this.padWithZeros = saveState.getBoolean(PAD_WITH_ZEROS, this.padWithZeros);
        this.minHexDigits = saveState.getInt(MIN_HEXL_DIGITS, this.minHexDigits);
        this.rightJustify = saveState.getBoolean(RIGHT_JUSTIFY, this.rightJustify);
        this.showBlockName = saveState.getBoolean(SHOW_BLOCK_NAME, this.showBlockName);
    }

    public void writeState(SaveState saveState) {
        saveState.putBoolean(PAD_WITH_ZEROS, this.padWithZeros);
        saveState.putInt(MIN_HEXL_DIGITS, this.minHexDigits);
        saveState.putBoolean(RIGHT_JUSTIFY, this.rightJustify);
        saveState.putBoolean(SHOW_BLOCK_NAME, this.showBlockName);
    }
}

