/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.NotFoundException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class ElfRelocationHandler
implements ExtensionPoint {
    public abstract boolean canRelocate(ElfHeader var1);

    public int getRelrRelocationType() {
        return 0;
    }

    public ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
        return null;
    }

    public abstract void relocate(ElfRelocationContext var1, ElfRelocation var2, Address var3) throws MemoryAccessException, NotFoundException;

    public static boolean isUnsupportedExternalRelocation(Program program, Address relocationAddress, Address symbolAddr, String symbolName, long adjustment, MessageLog log) {
        if (symbolAddr == null) {
            return false;
        }
        MemoryBlock block = program.getMemory().getBlock(symbolAddr);
        if (block == null || !"EXTERNAL".equals(block.getName())) {
            return false;
        }
        String sign = "+";
        if (adjustment < 0L) {
            adjustment = -adjustment;
            sign = "-";
        }
        String adjStr = sign + "0x" + Long.toHexString(adjustment);
        symbolName = symbolName == null ? "<no name>" : symbolName;
        log.appendMsg("Unsupported EXTERNAL Data Elf Relocation: at " + relocationAddress + " (External Location = " + symbolName + adjStr + ")");
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "EXTERNAL Relocation", "Unsupported EXTERNAL Data Elf Relocation: External Location = " + symbolName + adjStr);
        return true;
    }

    public static void markAsUnhandled(Program program, Address relocationAddress, long type, long symbolIndex, String symbolName, MessageLog log) {
        symbolName = StringUtils.isEmpty((CharSequence)symbolName) ? "<no name>" : symbolName;
        log.appendMsg("Unhandled Elf Relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") at " + relocationAddress + " (Symbol = " + symbolName + ")");
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation Type " + type, "Unhandled Elf Relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") Symbol = " + symbolName + " (0x" + Long.toHexString(symbolIndex) + ").");
    }

    public static void markAsUnsupportedRelr(Program program, Address relocationAddress) {
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Unsupported RELR Relocation", "ELF Extension does not specify type");
    }

    public static void markAsUninitializedMemory(Program program, Address relocationAddress, long type, long symbolIndex, String symbolName, MessageLog log) {
        symbolName = symbolName == null ? "<no name>" : symbolName;
        log.appendMsg("Unable to perform relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") at " + relocationAddress + " (Symbol = " + symbolName + ") - uninitialized memory");
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation_Type_" + type, "Unable to perform relocation: Type = " + type + " (0x" + Long.toHexString(type) + ") Symbol = " + symbolName + " (0x" + Long.toHexString(symbolIndex) + ") - uninitialized memory.");
    }

    public static void markAsError(Program program, Address relocationAddress, long type, String symbolName, String msg, MessageLog log) {
        ElfRelocationHandler.markAsError(program, relocationAddress, type + " (0x" + Long.toHexString(type) + ")", symbolName, msg, log);
    }

    public static void markAsError(Program program, Address relocationAddress, String type, String symbolName, String msg, MessageLog log) {
        symbolName = symbolName == null ? "<no name>" : symbolName;
        log.appendMsg("Elf Relocation Error: Type = " + type + " at " + relocationAddress + ", Symbol = " + symbolName + ": " + msg);
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Error", "Relocation_" + type, "Elf Relocation Error: Symbol = " + symbolName + ": " + msg);
    }

    public static void markAsWarning(Program program, Address relocationAddress, String type, String msg, MessageLog log) {
        ElfRelocationHandler.markAsWarning(program, relocationAddress, type, null, 0L, msg, log);
    }

    public static void markAsWarning(Program program, Address relocationAddress, String type, String symbolName, long symbolIndex, String msg, MessageLog log) {
        symbolName = symbolName == null ? "<no name>" : symbolName;
        log.appendMsg("Elf Relocation Warning: Type = " + type + " at " + relocationAddress + ", Symbol = " + symbolName + ": " + msg);
        BookmarkManager bookmarkManager = program.getBookmarkManager();
        bookmarkManager.setBookmark(relocationAddress, "Warning", "Relocation_Type_" + type, "Unhandled Elf relocation (" + type + ") at address: " + relocationAddress + ". Symbol = " + symbolName + " (" + Long.toHexString(symbolIndex) + "). " + msg);
    }
}

