/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionReturnTypeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;

public class FunctionReturnTypeLocationDescriptor
extends DataTypeLocationDescriptor {
    FunctionReturnTypeLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (!(location instanceof FunctionReturnTypeFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
    }

    @Override
    protected String generateLabel() {
        return this.getDataTypeName();
    }

    @Override
    protected String getDataTypeName() {
        FunctionReturnTypeFieldLocation returnTypeLocation = (FunctionReturnTypeFieldLocation)this.getLocation();
        return returnTypeLocation.getReturnType();
    }

    @Override
    protected DataType getSourceDataType() {
        FunctionManager functionManager = this.program.getFunctionManager();
        FunctionReturnTypeFieldLocation location = (FunctionReturnTypeFieldLocation)this.getLocation();
        Function function = functionManager.getFunctionContaining(location.getFunctionAddress());
        return function.getReturnType();
    }
}

