/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveFileChooser;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.File;

public class CreateArchiveAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public CreateArchiveAction(DataTypeManagerPlugin plugin) {
        super("New File Data Type Archive", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"New File Archive..."}, null, "Archive"));
        this.setDescription("Creates a new data type archive in this data type manager.");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionContext context) {
        Archive newArchive;
        DataTypeArchiveGTree gTree = this.plugin.getProvider().getGTree();
        ArchiveFileChooser fileChooser = new ArchiveFileChooser((Component)((Object)gTree));
        fileChooser.setApproveButtonText("Create Archive");
        fileChooser.setApproveButtonToolTipText("Create Archive");
        fileChooser.setTitle("Create Archive");
        Msg.trace((Object)((Object)this), (Object)"Showing filechooser to get new archive name...");
        File file = fileChooser.promptUserForFile("New_Archive");
        if (file == null) {
            Msg.trace((Object)((Object)this), (Object)"No new archive filename chosen by user - not performing action");
            return;
        }
        Msg.trace((Object)((Object)this), (Object)("User picked file: " + file.getAbsolutePath()));
        if (file.exists()) {
            Msg.trace((Object)((Object)this), (Object)"Need to overwrite--showing dialog");
            if (OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)((Object)gTree), (String)"Overwrite Existing File?", (String)("Do you want to overwrite existing file\n" + file.getAbsolutePath())) != 1) {
                Msg.trace((Object)((Object)this), (Object)"\tdo not overwrite was chosen");
                return;
            }
            Msg.trace((Object)((Object)this), (Object)"\toverwriting file!");
            file.delete();
        }
        if ((newArchive = this.plugin.getDataTypeManagerHandler().createArchive(file)) != null) {
            Msg.trace((Object)((Object)this), (Object)("Created new archive: " + newArchive.getName()));
            this.selectNewArchive(newArchive, gTree);
        }
    }

    private void selectNewArchive(Archive archive, DataTypeArchiveGTree gTree) {
        GTreeNode rootNode = gTree.getModelRoot();
        gTree.setSelectedNodeByNamePath(new String[]{rootNode.getName(), archive.getName()});
    }
}

