/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncListener;
import ghidra.app.plugin.core.datamgr.DataTypeSyncTableModel;
import ghidra.app.plugin.core.datamgr.RowData;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class DataTypeSyncPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DataTypeSyncTableModel tableModel;
    private GhidraTable syncTable;
    private DataTypeSyncListener listener;
    private GhidraTableFilterPanel<RowData> tableFilterPanel;

    DataTypeSyncPanel(List<DataTypeSyncInfo> list, Set<DataTypeSyncInfo> preselectedInfos, DataTypeSyncListener listener) {
        super(new BorderLayout());
        this.listener = listener;
        this.create(list, preselectedInfos);
    }

    void dispose() {
        this.tableFilterPanel.dispose();
        this.syncTable.dispose();
    }

    private void create(List<DataTypeSyncInfo> list, Set<DataTypeSyncInfo> preselectedInfos) {
        this.tableModel = new DataTypeSyncTableModel(list, preselectedInfos, true);
        this.syncTable = new GhidraTable((TableModel)((Object)this.tableModel));
        this.syncTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new DataTypeSyncBooleanRenderer()));
        JScrollPane sp = new JScrollPane((Component)((Object)this.syncTable));
        Dimension d = new Dimension(940, 200);
        this.syncTable.setPreferredScrollableViewportSize(d);
        this.syncTable.setSelectionMode(0);
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.syncTable), this.tableModel);
        this.add((Component)sp, "Center");
        this.add((Component)((Object)this.tableFilterPanel), "South");
        this.tableModel.fireTableDataChanged();
        TableColumnModel columnModel = this.syncTable.getColumnModel();
        block6: for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            int modelIndex = column.getModelIndex();
            switch (modelIndex) {
                case 0: {
                    column.setPreferredWidth(60);
                    column.setMinWidth(60);
                    column.setMaxWidth(60);
                    column.setResizable(false);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(70);
                    column.setMinWidth(70);
                    column.setMaxWidth(70);
                    column.setResizable(false);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(200);
                    continue block6;
                }
                case 2: 
                case 4: {
                    column.setPreferredWidth(140);
                }
            }
        }
        ListSelectionModel selectionModel = this.syncTable.getSelectionModel();
        selectionModel.addListSelectionListener(e -> {
            int selectedIndex = this.tableFilterPanel.getModelRow(this.syncTable.getSelectedRow());
            if (selectedIndex >= 0) {
                this.listener.dataTypeSelected(this.tableModel.getSyncInfo(selectedIndex));
            } else {
                this.listener.dataTypeSelected(null);
            }
        });
    }

    public boolean hasUnresolvedDataTypes() {
        return this.tableModel.hasUnresolvedDataTypes();
    }

    public List<DataTypeSyncInfo> getSelectedInfos() {
        return this.tableModel.getSelectedItems();
    }

    public void selectAll() {
        this.tableModel.selectAll();
    }

    public void deselectAll() {
        this.tableModel.deselectAll();
    }

    static class DataTypeSyncBooleanRenderer
    extends GBooleanCellRenderer {
        DataTypeSyncBooleanRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component c = super.getTableCellRendererComponent(data);
            JTable table = data.getTable();
            int row = data.getRowViewIndex();
            int column = data.getColumnViewIndex();
            TableModel model = table.getModel();
            this.cb.setEnabled(model.isCellEditable(row, column));
            return c;
        }
    }
}

