/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableSortState;
import ghidra.app.plugin.core.analysis.AnalysisPanel;
import ghidra.app.plugin.core.analysis.AnalyzerEnablementState;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.ColorUtils;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;

public class AnalysisEnablementTableModel
extends GDynamicColumnTableModel<AnalyzerEnablementState, Object> {
    private static Color BG_COLOR_NOT_DEFAULT_ENABLEMENT = new Color(255, 255, 200);
    private static Color BG_COLOR_NOT_DEFAULT_ENABLEMENT_SELECTED = new Color(177, 212, 236);
    private List<AnalyzerEnablementState> analyzerStates;
    private AnalysisPanel panel;

    public AnalysisEnablementTableModel(AnalysisPanel panel, List<AnalyzerEnablementState> analyzerStates) {
        super((ServiceProvider)new ServiceProviderStub());
        this.panel = panel;
        this.analyzerStates = analyzerStates;
        this.setDefaultTableSortState(TableSortState.createUnsortedSortState());
    }

    public void setData(List<AnalyzerEnablementState> analyzerStates) {
        this.analyzerStates = analyzerStates;
        this.fireTableDataChanged();
    }

    public String getName() {
        return "Analysis Enablement";
    }

    public List<AnalyzerEnablementState> getModelData() {
        return this.analyzerStates;
    }

    protected TableColumnDescriptor<AnalyzerEnablementState> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new AnalyzerEnabledColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AnalyzerNameColumn());
        return descriptor;
    }

    public Object getDataSource() {
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Boolean enabled = (Boolean)value;
            this.analyzerStates.get(rowIndex).setEnabled(enabled);
            String analyzerName = this.analyzerStates.get(rowIndex).getName();
            this.panel.setAnalyzerEnabled(analyzerName, enabled, true);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    public boolean isSortable(int columnIndex) {
        return false;
    }

    private void setToolTip(Component c, String text) {
        if (c instanceof JComponent) {
            ((JComponent)c).setToolTipText(text);
        }
    }

    private class AnalyzerNameTableCellRenderer
    extends AbstractGColumnRenderer<String> {
        private AnalyzerNameTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            AnalyzerEnablementState state;
            Component component = super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value == null) {
                return component;
            }
            String analyzerName = (String)value;
            if (analyzerName.endsWith(" (Prototype)")) {
                component.setForeground(ColorUtils.deriveForeground((Color)component.getBackground(), (float)0.0f));
            }
            if ((state = (AnalyzerEnablementState)data.getRowObject()).isDefaultEnablement()) {
                AnalysisEnablementTableModel.this.setToolTip(component, null);
                return component;
            }
            if (data.isSelected()) {
                component.setBackground(BG_COLOR_NOT_DEFAULT_ENABLEMENT_SELECTED);
                component.setForeground(Color.BLACK);
            } else {
                component.setBackground(BG_COLOR_NOT_DEFAULT_ENABLEMENT);
            }
            AnalysisEnablementTableModel.this.setToolTip(component, "This option differs from the default");
            return component;
        }

        public String getFilterString(String value, Settings settings) {
            return value;
        }
    }

    private class EnabledColumnTableCellRenderer
    implements GColumnRenderer<Boolean> {
        GBooleanCellRenderer booleanRenderer = new GBooleanCellRenderer();

        private EnabledColumnTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            AnalyzerEnablementState state = (AnalyzerEnablementState)AnalysisEnablementTableModel.this.getRowObject(row);
            if (state.isDefaultEnablement()) {
                AnalysisEnablementTableModel.this.setToolTip(component, null);
                return component;
            }
            if (isSelected) {
                component.setBackground(BG_COLOR_NOT_DEFAULT_ENABLEMENT_SELECTED);
            } else {
                component.setBackground(BG_COLOR_NOT_DEFAULT_ENABLEMENT);
            }
            AnalysisEnablementTableModel.this.setToolTip(component, "This option differs from the default");
            return component;
        }

        public String getFilterString(Boolean t, Settings settings) {
            return "";
        }
    }

    private class AnalyzerNameColumn
    extends AbstractDynamicTableColumn<AnalyzerEnablementState, String, Object> {
        AnalyzerNameTableCellRenderer renderer;

        private AnalyzerNameColumn() {
            this.renderer = new AnalyzerNameTableCellRenderer();
        }

        public String getColumnName() {
            return "Analyzer";
        }

        public String getValue(AnalyzerEnablementState state, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            Object value = state.getName();
            if (state.isPrototype()) {
                value = (String)value + " (Prototype)";
            }
            return value;
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class AnalyzerEnabledColumn
    extends AbstractDynamicTableColumn<AnalyzerEnablementState, Boolean, Object> {
        EnabledColumnTableCellRenderer renderer;

        private AnalyzerEnabledColumn() {
            this.renderer = new EnabledColumnTableCellRenderer();
        }

        public String getColumnName() {
            return "Enabled";
        }

        public Boolean getValue(AnalyzerEnablementState state, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return state.isEnabled();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.renderer;
        }
    }
}

