/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiff;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ReferenceMerger
extends AbstractListingMerger {
    static final String REFERENCES_PHASE = "References";
    private static final int TYPE_CONFLICT = 1;
    private static final int REMOVE_CONFLICT = 2;
    private static final int CHANGE_CONFLICT = 3;
    private static final int ADD_CONFLICT = 4;
    private static final int PRIMARY_CONFLICT = 5;
    VerticalChoicesPanel conflictPanel;
    Reference currentReference;
    int currentOpIndex;
    AddressSet currentBackgroundSet;
    ReferenceManager latestRefMgr;
    ReferenceManager myRefMgr;
    ReferenceManager originalRefMgr;
    ReferenceManager resultRefMgr;
    ProgramDiff latestMyDiff;
    ProgramDiff originalLatestDiff;
    ProgramDiff originalMyDiff;
    AddressSetView latestDetailSet;
    AddressSetView myDetailSet;
    Listing resultListing;
    Listing latestListing;
    Listing myListing;
    Listing originalListing;
    AddressSet conflictSet;
    HashMap<Address, ArrayList<Integer>> typeConflicts;
    HashMap<Address, ArrayList<Reference>> removeConflicts;
    HashMap<Address, ArrayList<Reference>> changeConflicts;
    HashMap<Address, ArrayList<Reference>> addConflicts;
    HashMap<Address, ArrayList<Integer>> primaryConflicts;
    LongLongHashtable origResolvedSymbols;
    LongLongHashtable latestResolvedSymbols;
    LongLongHashtable myResolvedSymbols;
    AddressSetView pickedLatestCodeUnits;
    AddressSetView pickedMyCodeUnits;
    AddressSetView pickedOriginalCodeUnits;
    private int currentConflictType;
    private int referenceChoice = 0;
    private int referenceTypeChoice = 0;
    private int primaryReferenceChoice = 0;

    ReferenceMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.latestRefMgr = this.latestPgm.getReferenceManager();
        this.myRefMgr = this.myPgm.getReferenceManager();
        this.originalRefMgr = this.originalPgm.getReferenceManager();
        this.resultRefMgr = this.resultPgm.getReferenceManager();
        this.resultListing = this.resultPgm.getListing();
        this.latestListing = this.latestPgm.getListing();
        this.myListing = this.myPgm.getListing();
        this.originalListing = this.originalPgm.getListing();
        this.diffLatestMy = this.listingMergeMgr.diffLatestMy;
        this.diffOriginalLatest = this.listingMergeMgr.diffOriginalLatest;
        this.diffOriginalMy = this.listingMergeMgr.diffOriginalMy;
        this.origResolvedSymbols = new LongLongHashtable();
        this.latestResolvedSymbols = new LongLongHashtable();
        this.myResolvedSymbols = new LongLongHashtable();
        this.pickedLatestCodeUnits = new AddressSet();
        this.pickedMyCodeUnits = new AddressSet();
        this.pickedOriginalCodeUnits = new AddressSet();
        this.latestDetailSet = new AddressSet();
        this.myDetailSet = new AddressSet();
        this.conflictSet = new AddressSet();
        this.typeConflicts = new HashMap();
        this.removeConflicts = new HashMap();
        this.changeConflicts = new HashMap();
        this.addConflicts = new HashMap();
        this.primaryConflicts = new HashMap();
    }

    @Override
    public String getConflictType() {
        return "Reference";
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.setChoiceForConflictType(this.currentConflictType, this.conflictOption);
        }
        return super.apply();
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging References and determining conflicts.", progressMin, progressMax, monitor);
        this.totalChanges = 7L;
        if (this.mergeManager != null) {
            this.latestResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedLatestSymbols");
            this.myResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedMySymbols");
            this.origResolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation("ResolvedOriginalSymbols");
            this.pickedLatestCodeUnits = (AddressSetView)this.mergeManager.getResolveInformation("PickedLatestCodeUnits");
            this.pickedMyCodeUnits = (AddressSetView)this.mergeManager.getResolveInformation("PickedMyCodeUnits");
            this.pickedOriginalCodeUnits = (AddressSetView)this.mergeManager.getResolveInformation("PickedOriginalCodeUnits");
        }
        this.updateProgressMessage("Setting references where code units were merged...");
        this.autoMergeWhereCodeUnitsMerged(monitor);
        this.incrementProgress(1);
        ProgramDiffFilter filter = new ProgramDiffFilter(256);
        this.latestDetailSet = this.listingMergeMgr.diffOriginalLatest.getDifferences(filter, monitor);
        this.myDetailSet = this.listingMergeMgr.diffOriginalMy.getDifferences(filter, monitor);
        AddressSet tmpAutoSet = new AddressSet();
        AddressSet possibleConflicts = new AddressSet();
        MergeUtilities.adjustSets(this.latestDetailSet, this.myDetailSet, tmpAutoSet, possibleConflicts);
        AddressSet mergedCodeUnits = this.listingMergeMgr.getMergedCodeUnits();
        tmpAutoSet.delete((AddressSetView)mergedCodeUnits);
        possibleConflicts.delete((AddressSetView)mergedCodeUnits);
        this.updateProgressMessage("Auto-merging references...");
        this.replaceReferences((AddressSetView)tmpAutoSet, 4, monitor);
        this.incrementProgress(1);
        this.updateProgressMessage("Finding reference conflicts...");
        this.determineChanges(possibleConflicts, monitor);
        this.incrementProgress(1);
    }

    private void clearFallThroughOverride(Program program, Address address) {
        Instruction instruction = program.getListing().getInstructionAt(address);
        if (instruction != null) {
            instruction.clearFallThroughOverride();
        }
    }

    private void autoMergeWhereCodeUnitsMerged(TaskMonitor monitor) throws CancelledException {
        this.replaceReferences(this.pickedLatestCodeUnits, 2, monitor);
        this.replaceReferences(this.pickedMyCodeUnits, 4, monitor);
        this.replaceReferences(this.pickedOriginalCodeUnits, 1, monitor);
    }

    private void determineChanges(AddressSet possibleConflicts, TaskMonitor monitor) {
        monitor.setMessage("Determining reference changes.");
        CodeUnitIterator iter = this.resultPgm.getListing().getCodeUnits((AddressSetView)possibleConflicts, true);
        while (iter.hasNext()) {
            CodeUnit resultCU = iter.next();
            int numOps = resultCU.getNumOperands();
            Address address = resultCU.getMinAddress();
            for (int opIndex = -1; opIndex < numOps; ++opIndex) {
                this.processOperandRefs(address, opIndex);
            }
        }
    }

    private void processOperandRefs(Address address, int opIndex) {
        Object[] latestRefs = this.latestRefMgr.getReferencesFrom(address, opIndex);
        Object[] myRefs = this.myRefMgr.getReferencesFrom(address, opIndex);
        Object[] originalRefs = this.originalRefMgr.getReferencesFrom(address, opIndex);
        latestRefs = ProgramDiff.getDiffRefs((Reference[])latestRefs);
        myRefs = ProgramDiff.getDiffRefs((Reference[])myRefs);
        originalRefs = ProgramDiff.getDiffRefs((Reference[])originalRefs);
        Arrays.sort(latestRefs);
        Arrays.sort(myRefs);
        Arrays.sort(originalRefs);
        if (this.equalRefArrays(this.listingMergeMgr.diffLatestMy, (Reference[])latestRefs, (Reference[])myRefs)) {
            return;
        }
        if (this.equalRefArrays(this.listingMergeMgr.diffOriginalMy, (Reference[])originalRefs, (Reference[])myRefs)) {
            return;
        }
        if (this.equalRefArrays(this.listingMergeMgr.diffOriginalLatest, (Reference[])originalRefs, (Reference[])latestRefs)) {
            this.listingMergeMgr.mergeMy.replaceReferences(address, opIndex);
            return;
        }
        if (!this.compatibleRefs((Reference[])myRefs, (Reference[])latestRefs)) {
            this.saveTypeConflict(address, opIndex);
            return;
        }
        Reference someRef = this.getSomeRef((Reference[])myRefs, (Reference[])latestRefs);
        if (someRef.isMemoryReference()) {
            this.processMemoryRefs(address, opIndex, (Reference[])latestRefs, (Reference[])myRefs, (Reference[])originalRefs);
        } else {
            this.processSingleRefs(address, opIndex, (Reference[])latestRefs, (Reference[])myRefs, (Reference[])originalRefs);
        }
    }

    private boolean equalRefArrays(ProgramDiff programDiff, Reference[] refs1, Reference[] refs2) {
        if (refs1 == refs2) {
            return true;
        }
        if (refs1 == null || refs2 == null) {
            return false;
        }
        int length = refs1.length;
        if (refs2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Reference ref1 = refs1[i];
            Reference ref2 = refs2[i];
            if (ref1.isExternalReference() && ref2.isExternalReference()) {
                if (!ref1.getReferenceType().equals((Object)ref2.getReferenceType())) {
                    return false;
                }
                Program programOne = programDiff.getProgramOne();
                Program programTwo = programDiff.getProgramTwo();
                Address toAddress1 = ref1.getToAddress();
                Address toAddress2 = ref2.getToAddress();
                Symbol symbol1 = programOne.getSymbolTable().getPrimarySymbol(toAddress1);
                Symbol symbol2 = programTwo.getSymbolTable().getPrimarySymbol(toAddress2);
                long id1 = symbol1 != null ? symbol1.getID() : -1L;
                long id2 = symbol2 != null ? symbol2.getID() : -1L;
                try {
                    long resultID1 = this.getResultID(programOne, id1);
                    long resultID2 = this.getResultID(programTwo, id2);
                    if (resultID1 != resultID2) {
                        return false;
                    }
                    Msg.trace((Object)this, (Object)"!!! Both references resolved to the same external. !!!");
                    continue;
                }
                catch (NoValueException e) {
                    return false;
                }
            }
            if (programDiff.equalRefs(ref1, ref2)) continue;
            return false;
        }
        return true;
    }

    private long getResultID(Program program, long id1) throws NoValueException {
        if (this.latestPgm == program) {
            return this.getExternalResultIDFromLatestID(id1);
        }
        if (this.myPgm == program) {
            return this.getExternalResultIDFromMyID(id1);
        }
        if (this.originalPgm == program) {
            return this.getExternalResultIDFromOriginalID(id1);
        }
        return id1;
    }

    private void processMemoryRefs(Address address, int opIndex, Reference[] latestRefs, Reference[] myRefs, Reference[] originalRefs) {
        this.processOriginalRefs(originalRefs);
        this.processMyRefsAdded(myRefs);
        this.getPrimaryConflicts(address, opIndex);
    }

    private void processOriginalRefs(Reference[] originalRefs) {
        for (int origIndex = 0; origIndex < originalRefs.length; ++origIndex) {
            boolean changedMy;
            Reference originalRef = originalRefs[origIndex];
            Reference myRef = DiffUtility.getReference(this.originalPgm, originalRef, this.myPgm);
            Reference latestRef = DiffUtility.getReference(this.originalPgm, originalRef, this.latestPgm);
            if (myRef == null) {
                if (!this.diffOriginalLatest.equalRefs(originalRef, latestRef)) {
                    this.saveRemoveConflict(originalRef);
                    continue;
                }
                Reference resultRef = DiffUtility.getReference(this.originalPgm, originalRef, this.resultPgm);
                if (resultRef == null) continue;
                this.resultRefMgr.delete(resultRef);
                continue;
            }
            if (latestRef == null) {
                if (this.diffOriginalMy.equalRefs(originalRef, myRef)) continue;
                this.saveRemoveConflict(originalRef);
                continue;
            }
            if (this.diffLatestMy.equalRefs(latestRef, myRef)) continue;
            boolean changedLatest = !this.diffOriginalLatest.equalRefs(originalRef, latestRef);
            boolean bl = changedMy = !this.diffOriginalMy.equalRefs(originalRef, myRef);
            if (!changedMy) continue;
            if (changedLatest) {
                this.saveChangeConflict(myRef);
                continue;
            }
            DiffUtility.createReference(this.myPgm, myRef, this.resultPgm);
        }
    }

    private void processMyRefsAdded(Reference[] myRefs) {
        for (int myIndex = 0; myIndex < myRefs.length; ++myIndex) {
            Reference myRef = myRefs[myIndex];
            Reference originalRef = DiffUtility.getReference(this.myPgm, myRef, this.originalPgm);
            if (originalRef != null) continue;
            Reference latestRef = DiffUtility.getReference(this.myPgm, myRef, this.latestPgm);
            if (latestRef == null) {
                DiffUtility.createReference(this.myPgm, myRef, this.resultPgm);
                continue;
            }
            if (this.diffLatestMy.equalRefs(latestRef, myRef)) continue;
            this.saveAddConflict(myRef);
        }
    }

    private Reference getFallThroughReference(Program program, Address fromAddress, int operandIndex) {
        Reference[] otherRefs;
        for (Reference reference : otherRefs = program.getReferenceManager().getReferencesFrom(fromAddress, operandIndex)) {
            if (!reference.getReferenceType().isFallthrough()) continue;
            return reference;
        }
        return null;
    }

    private void getPrimaryConflicts(Address address, int opIndex) {
        Reference latestPrimary = this.latestRefMgr.getPrimaryReferenceFrom(address, opIndex);
        Reference myPrimary = this.myRefMgr.getPrimaryReferenceFrom(address, opIndex);
        if (latestPrimary != null && myPrimary != null && latestPrimary.compareTo((Object)myPrimary) != 0) {
            Reference origForLatest = DiffUtility.getReference(this.latestPgm, latestPrimary, this.originalPgm);
            if (origForLatest != null && this.diffOriginalLatest.equalRefs(origForLatest, latestPrimary)) {
                return;
            }
            Reference origForMy = DiffUtility.getReference(this.myPgm, myPrimary, this.originalPgm);
            if (origForMy != null && this.diffOriginalMy.equalRefs(origForMy, myPrimary)) {
                return;
            }
            this.savePrimaryConflict(address, opIndex);
        }
    }

    private void processSingleRefs(Address address, int opIndex, Reference[] latestRefs, Reference[] myRefs, Reference[] originalRefs) {
        boolean hasRefTypeConflict = this.hasRefTypeConflict(latestRefs, myRefs, originalRefs);
        if (originalRefs.length > 0) {
            if (myRefs.length == 0 || latestRefs.length == 0) {
                if (hasRefTypeConflict) {
                    this.saveRemoveConflict(originalRefs[0]);
                } else if (myRefs.length != 0) {
                    this.listingMergeMgr.mergeMy.replaceReferences(address, opIndex);
                }
            } else if (!this.diffOriginalMy.equalRefs(originalRefs[0], myRefs[0])) {
                this.saveChangeConflict(myRefs[0]);
            }
        } else if (!this.diffLatestMy.equalRefs(latestRefs[0], myRefs[0])) {
            this.saveAddConflict(myRefs[0]);
        }
    }

    private boolean hasRefTypeConflict(Reference[] latestRefs, Reference[] myRefs, Reference[] originalRefs) {
        if (originalRefs.length > 0) {
            return this.compatibleRefs(originalRefs[0], latestRefs) && this.compatibleRefs(originalRefs[0], myRefs);
        }
        if (latestRefs.length > 0) {
            return this.compatibleRefs(latestRefs[0], myRefs);
        }
        return true;
    }

    private void addToRefsHash(Address address, Reference ref, HashMap<Address, ArrayList<Reference>> refsHash) {
        ArrayList<Object> refsList = refsHash.get(address);
        if (refsList == null) {
            refsList = new ArrayList();
            refsHash.put(address, refsList);
        }
        if (!refsList.contains(ref)) {
            refsList.add(ref);
        }
    }

    private boolean compatibleRefs(Reference[] myRefs, Reference[] latestRefs) {
        if (myRefs.length == 0 || latestRefs.length == 0) {
            return true;
        }
        return this.compatibleRefs(myRefs[0], latestRefs);
    }

    private Reference getSomeRef(Reference[] myRefs, Reference[] latestRefs) {
        if (myRefs.length > 0) {
            return myRefs[0];
        }
        if (latestRefs.length > 0) {
            return latestRefs[0];
        }
        return null;
    }

    private boolean compatibleRefs(Reference ref1, Reference[] refs) {
        Address toAddr = ref1.getToAddress();
        if (toAddr.isMemoryAddress()) {
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i].getToAddress().isMemoryAddress()) continue;
                return false;
            }
            return true;
        }
        if (toAddr.isExternalAddress()) {
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i].getToAddress().isExternalAddress()) continue;
                return false;
            }
            return true;
        }
        if (toAddr.isRegisterAddress()) {
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i].getToAddress().isRegisterAddress()) continue;
                return false;
            }
            return true;
        }
        if (toAddr.isStackAddress()) {
            for (int i = 0; i < refs.length; ++i) {
                if (refs[i].getToAddress().isStackAddress()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void saveTypeConflict(Address address, int opIndex) {
        ArrayList<Integer> opIndexes = this.typeConflicts.get(address);
        if (opIndexes == null) {
            opIndexes = new ArrayList();
            this.typeConflicts.put(address, opIndexes);
        }
        opIndexes.add(new Integer(opIndex));
        this.conflictSet.addRange(address, address);
    }

    private void saveAddConflict(Reference myRef) {
        Address address = myRef.getFromAddress();
        this.addToRefsHash(address, myRef, this.addConflicts);
        this.conflictSet.addRange(address, address);
    }

    private void saveChangeConflict(Reference myRef) {
        Address address = myRef.getFromAddress();
        this.addToRefsHash(address, myRef, this.changeConflicts);
        this.conflictSet.addRange(address, address);
    }

    private void saveRemoveConflict(Reference originalRef) {
        Address address = originalRef.getFromAddress();
        this.addToRefsHash(address, originalRef, this.removeConflicts);
        this.conflictSet.addRange(address, address);
    }

    private void savePrimaryConflict(Address address, int opIndex) {
        ArrayList<Integer> opIndexes = this.primaryConflicts.get(address);
        if (opIndexes == null) {
            opIndexes = new ArrayList();
            this.primaryConflicts.put(address, opIndexes);
        }
        opIndexes.add(new Integer(opIndex));
        this.conflictSet.addRange(address, address);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictSet.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        return this.getTypeConflictCount(addr) + this.getRemoveConflictCount(addr) + this.getChangeConflictCount(addr) + this.getAddConflictCount(addr) + this.getPrimaryConflictCount(addr);
    }

    private int getTypeConflictCount(Address addr) {
        ArrayList<Integer> opIndexList = this.typeConflicts.get(addr);
        return opIndexList != null ? opIndexList.size() : 0;
    }

    private int getRemoveConflictCount(Address addr) {
        ArrayList<Reference> refsList = this.removeConflicts.get(addr);
        if (refsList == null) {
            return 0;
        }
        return refsList.size();
    }

    private int getChangeConflictCount(Address addr) {
        ArrayList<Reference> refsList = this.changeConflicts.get(addr);
        if (refsList == null) {
            return 0;
        }
        return refsList.size();
    }

    private int getAddConflictCount(Address addr) {
        ArrayList<Reference> refsList = this.addConflicts.get(addr);
        if (refsList == null) {
            return 0;
        }
        return refsList.size();
    }

    private int getPrimaryConflictCount(Address addr) {
        ArrayList<Integer> opIndexList = this.primaryConflicts.get(addr);
        return opIndexList != null ? opIndexList.size() : 0;
    }

    private void replaceReferences(AddressSetView addressSet, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.replaceReferences(addressSet, monitor);
        } else if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.replaceReferences(addressSet, monitor);
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.replaceReferences(addressSet, monitor);
        }
    }

    private void replaceFallThroughs(AddressSetView addressSet, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        if ((chosenConflictOption & 1) != 0) {
            this.listingMergeMgr.mergeOriginal.replaceFallThroughs(addressSet, monitor);
        } else if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.replaceFallThroughs(addressSet, monitor);
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.replaceFallThroughs(addressSet, monitor);
        }
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (!this.hasConflict(addr)) {
            return;
        }
        monitor.setMessage("Merging conflicting References.");
        CodeUnit resultCU = this.resultPgm.getListing().getCodeUnitAt(addr);
        int numOps = resultCU.getNumOperands();
        for (int opIndex = -1; opIndex < numOps; ++opIndex) {
            this.mergeConflicts(listingPanel, addr, opIndex, chosenConflictOption, monitor);
        }
    }

    private void mergeConflicts(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, TaskMonitor monitor) throws CancelledException {
        boolean askUser = chosenConflictOption == 0;
        this.handleTypeConflict(listingPanel, addr, opIndex, chosenConflictOption, askUser, monitor);
        this.handleRemoveConflict(listingPanel, addr, opIndex, chosenConflictOption, askUser, monitor);
        this.handleChangeConflict(listingPanel, addr, opIndex, chosenConflictOption, askUser, monitor);
        this.handleAddConflict(listingPanel, addr, opIndex, chosenConflictOption, askUser, monitor);
        this.handlePrimaryConflict(listingPanel, addr, opIndex, chosenConflictOption, askUser, monitor);
    }

    private void handleTypeConflict(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, boolean askUser, TaskMonitor monitor) throws CancelledException {
        ArrayList<Integer> opIndexList = this.typeConflicts.get(addr);
        if (opIndexList == null || opIndexList.size() == 0) {
            return;
        }
        if (opIndexList.contains(new Integer(opIndex))) {
            this.currentReference = null;
            this.currentAddress = addr;
            this.currentOpIndex = opIndex;
            this.currentBackgroundSet = new AddressSet(addr, addr);
            this.currentConflictType = 1;
            if (this.referenceTypeChoice != 0) {
                this.resolveTypeConflict(addr, opIndex, this.referenceTypeChoice);
            } else if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 1);
                monitor.checkCanceled();
            } else {
                this.resolveTypeConflict(addr, opIndex, chosenConflictOption);
            }
        }
    }

    private void handleRemoveConflict(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, boolean askUser, TaskMonitor monitor) throws CancelledException {
        ArrayList<Reference> removeList = this.removeConflicts.get(addr);
        if (removeList == null || removeList.size() == 0) {
            return;
        }
        this.currentAddress = addr;
        this.currentOpIndex = opIndex;
        this.currentBackgroundSet = new AddressSet(addr, addr);
        this.currentConflictType = 2;
        Iterator<Reference> iter = removeList.iterator();
        while (iter.hasNext()) {
            Reference removeRef;
            this.currentReference = removeRef = iter.next();
            if (this.currentReference.getOperandIndex() != opIndex) continue;
            if (this.referenceChoice != 0) {
                this.resolveRemoveVsChange(this.currentReference, this.referenceChoice);
                continue;
            }
            if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 2);
                monitor.checkCanceled();
                continue;
            }
            this.resolveRemoveVsChange(this.currentReference, chosenConflictOption);
        }
    }

    private void handleChangeConflict(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, boolean askUser, TaskMonitor monitor) throws CancelledException {
        ArrayList<Reference> changeList = this.changeConflicts.get(addr);
        if (changeList == null || changeList.size() == 0) {
            return;
        }
        this.currentAddress = addr;
        this.currentOpIndex = opIndex;
        this.currentBackgroundSet = new AddressSet(addr, addr);
        this.currentConflictType = 3;
        Iterator<Reference> iter = changeList.iterator();
        while (iter.hasNext()) {
            Reference changeRef;
            this.currentReference = changeRef = iter.next();
            if (this.currentReference.getOperandIndex() != opIndex) continue;
            if (this.referenceChoice != 0) {
                this.resolveChangeConflict(this.currentReference, this.referenceChoice);
                continue;
            }
            if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 3);
                monitor.checkCanceled();
                continue;
            }
            this.resolveChangeConflict(this.currentReference, chosenConflictOption);
        }
    }

    private void handleAddConflict(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, boolean askUser, TaskMonitor monitor) throws CancelledException {
        ArrayList<Reference> addList = this.addConflicts.get(addr);
        if (addList == null || addList.size() == 0) {
            return;
        }
        this.currentAddress = addr;
        this.currentOpIndex = opIndex;
        this.currentBackgroundSet = new AddressSet(addr, addr);
        this.currentConflictType = 4;
        Iterator<Reference> iter = addList.iterator();
        while (iter.hasNext()) {
            Reference changeRef;
            this.currentReference = changeRef = iter.next();
            if (this.currentReference.getReferenceType().isFallthrough() || this.currentReference.getOperandIndex() != opIndex) continue;
            if (this.referenceChoice != 0) {
                this.resolveAddConflict(this.currentReference, this.referenceChoice);
                continue;
            }
            if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 4);
                monitor.checkCanceled();
                continue;
            }
            this.resolveAddConflict(this.currentReference, chosenConflictOption);
        }
    }

    private void handlePrimaryConflict(ListingMergePanel listingPanel, Address addr, int opIndex, int chosenConflictOption, boolean askUser, TaskMonitor monitor) throws CancelledException {
        ArrayList<Integer> opIndexList = this.primaryConflicts.get(addr);
        if (opIndexList == null || opIndexList.size() == 0) {
            return;
        }
        if (opIndexList.contains(new Integer(opIndex))) {
            if (!this.hasPrimaryConflict(addr, opIndex)) {
                return;
            }
            this.currentReference = null;
            this.currentAddress = addr;
            this.currentOpIndex = opIndex;
            this.currentBackgroundSet = new AddressSet(addr, addr);
            this.currentConflictType = 5;
            if (this.primaryReferenceChoice != 0) {
                this.resolvePrimaryConflict(addr, opIndex, this.primaryReferenceChoice);
            } else if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 5);
                monitor.checkCanceled();
            } else {
                this.resolvePrimaryConflict(addr, opIndex, chosenConflictOption);
            }
        }
    }

    private boolean hasPrimaryConflict(Address addr, int opIndex) {
        Reference resultForMy;
        Reference resultForLatest;
        Reference latestPrimary = this.latestRefMgr.getPrimaryReferenceFrom(addr, opIndex);
        Reference myPrimary = this.myRefMgr.getPrimaryReferenceFrom(addr, opIndex);
        return latestPrimary != null && myPrimary != null && (resultForLatest = DiffUtility.getReference(this.latestPgm, latestPrimary, this.resultPgm)) != null && (resultForMy = DiffUtility.getReference(this.myPgm, myPrimary, this.resultPgm)) != null && resultForLatest != resultForMy;
    }

    private boolean hasLatestFallThrough(Address fromAddress, int operandIndex) {
        Reference resultFallThrough = this.getFallThroughReference(this.resultPgm, fromAddress, operandIndex);
        Reference latestFallThrough = this.getFallThroughReference(this.resultPgm, fromAddress, operandIndex);
        if (latestFallThrough != null && resultFallThrough != null) {
            return latestFallThrough.equals(resultFallThrough);
        }
        return false;
    }

    private void showConflictPanel(final ListingMergePanel listingPanel, final int conflictType) {
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int chosenConflictOption = ReferenceMerger.this.conflictPanel.getSelectedOptions();
                    if (chosenConflictOption == 0) {
                        if (ReferenceMerger.this.mergeManager != null) {
                            ReferenceMerger.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (ReferenceMerger.this.mergeManager != null) {
                        ReferenceMerger.this.mergeManager.clearStatusText();
                    }
                    try {
                        ReferenceMerger.this.mergeConflict(conflictType, chosenConflictOption);
                        if (ReferenceMerger.this.mergeManager != null) {
                            ReferenceMerger.this.mergeManager.setApplyEnabled(true);
                        }
                    }
                    catch (Exception e1) {
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReferenceMerger.this.getConflictPanel(conflictType, changeListener);
                        int choice = ReferenceMerger.this.getChoiceForConflictType(conflictType);
                        boolean useForAll = choice != 0;
                        ReferenceMerger.this.conflictPanel.setUseForAll(useForAll);
                        ReferenceMerger.this.conflictPanel.setConflictType(ReferenceMerger.this.getConflictTypeText(conflictType));
                        listingPanel.setBottomComponent(ReferenceMerger.this.conflictPanel);
                    }
                    catch (Exception e) {
                        Msg.showError((Object)this, (Component)listingPanel, (String)"Error Merging References", (Object)"Error Getting Conflict Panel", (Throwable)e);
                    }
                }
            });
            SwingUtilities.invokeLater(() -> {
                listingPanel.clearAllBackgrounds();
                if (this.currentBackgroundSet != null) {
                    listingPanel.paintAllBackgrounds((AddressSetView)this.currentBackgroundSet);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (this.mergeManager != null && this.conflictPanel.hasChoice()) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    protected String getConflictTypeText(int conflictType) {
        switch (conflictType) {
            case 1: {
                return "Reference Type";
            }
            case 2: 
            case 3: 
            case 4: {
                return "Reference Add/Change/Remove";
            }
            case 5: {
                return "Primary Reference";
            }
        }
        return null;
    }

    protected VerticalChoicesPanel getConflictPanel(int conflictType, ChangeListener listener) {
        switch (conflictType) {
            case 1: {
                return this.getTypeConflictPanel(this.currentAddress, this.currentOpIndex, listener);
            }
            case 2: {
                return this.getRemoveConflictPanel(this.currentReference, listener);
            }
            case 3: {
                return this.getChangeConflictPanel(this.currentReference, listener);
            }
            case 4: {
                return this.getAddConflictPanel(this.currentReference, listener);
            }
            case 5: {
                return this.getPrimaryConflictPanel(this.currentAddress, this.currentOpIndex, listener);
            }
        }
        return null;
    }

    private void mergeConflict(int conflictType, int chosenConflictOption) {
        switch (conflictType) {
            case 1: {
                this.resolveTypeConflict(this.currentAddress, this.currentOpIndex, chosenConflictOption);
                break;
            }
            case 2: {
                this.resolveRemoveVsChange(this.currentReference, chosenConflictOption);
                break;
            }
            case 3: {
                this.resolveChangeConflict(this.currentReference, chosenConflictOption);
                break;
            }
            case 4: {
                this.resolveAddConflict(this.currentReference, chosenConflictOption);
                break;
            }
            case 5: {
                this.resolvePrimaryConflict(this.currentAddress, this.currentOpIndex, chosenConflictOption);
            }
        }
    }

    private VerticalChoicesPanel getVerticalConflictPanel() {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
            this.conflictPanel.setTitle("Reference");
        } else {
            this.conflictPanel.clear();
        }
        return this.conflictPanel;
    }

    protected VerticalChoicesPanel getTypeConflictPanel(Address fromAddress, int opIndex, ChangeListener listener) {
        int i;
        VerticalChoicesPanel panel = this.getVerticalConflictPanel();
        Reference[] originalRefs = this.originalRefMgr.getReferencesFrom(fromAddress, opIndex);
        Reference[] latestRefs = this.latestRefMgr.getReferencesFrom(fromAddress, opIndex);
        Reference[] myRefs = this.myRefMgr.getReferencesFrom(fromAddress, opIndex);
        panel.setTitle("Reference");
        String fromAddrStr = ConflictUtility.getAddressString(fromAddress);
        String text = " Conflicting reference types, " + this.getRefGroup(latestRefs[0]) + " & " + this.getRefGroup(myRefs[0]) + ", at '" + fromAddrStr + "' " + this.getOperandIndexString(opIndex) + ".";
        panel.setHeader(text);
        panel.setRowHeader(this.getReferenceInfo(null, null, null, null));
        String suffix = "' version";
        panel.addRadioButtonRow(this.getReferenceInfo(this.latestPgm, latestRefs.length == 1 ? latestRefs[0] : null, latestRefs.length == 1 ? "Use '" : "Use all in '", suffix), "LatestVersionRB", 2, listener);
        if (latestRefs.length > 1) {
            for (i = 0; i < latestRefs.length; ++i) {
                panel.addInfoRow(this.getReferenceInfo(this.latestPgm, latestRefs[i], "'", suffix));
            }
        }
        panel.addRadioButtonRow(this.getReferenceInfo(this.myPgm, myRefs.length == 1 ? myRefs[0] : null, myRefs.length == 1 ? "Use '" : "Use all in '", suffix), "CheckedOutVersionRB", 4, listener);
        if (myRefs.length > 1) {
            for (i = 0; i < myRefs.length; ++i) {
                panel.addInfoRow(this.getReferenceInfo(this.myPgm, myRefs[i], "'", suffix));
            }
        }
        panel.addInfoRow(this.getReferenceInfo(this.originalPgm, originalRefs.length > 0 ? originalRefs[0] : null, "'", suffix));
        for (i = 1; i < originalRefs.length; ++i) {
            panel.addInfoRow(this.getReferenceInfo(this.originalPgm, originalRefs[i], "'", suffix));
        }
        return panel;
    }

    protected VerticalChoicesPanel getRemoveConflictPanel(Reference ref, ChangeListener listener) {
        VerticalChoicesPanel panel = this.getVerticalConflictPanel();
        Reference originalRef = ref;
        Reference latestRef = DiffUtility.getReference(this.originalPgm, originalRef, this.latestPgm);
        Reference myRef = DiffUtility.getReference(this.originalPgm, originalRef, this.myPgm);
        if (originalRef.getReferenceType().isFallthrough()) {
            Address fromAddr = originalRef.getFromAddress();
            int opIndex = originalRef.getOperandIndex();
            Reference latestFallthrough = this.getFallThroughReference(this.latestPgm, fromAddr, opIndex);
            Reference myFallthrough = this.getFallThroughReference(this.myPgm, fromAddr, opIndex);
            latestRef = latestFallthrough;
            myRef = myFallthrough;
        }
        panel.setTitle("Reference");
        String fromAddrStr = ConflictUtility.getAddressString(ref.getFromAddress());
        String toAddrStr = ConflictUtility.colorString(ConflictUtility.ADDRESS_COLOR, DiffUtility.getUserToAddressString(this.resultPgm, ref.getToAddress()));
        String text = this.getRefGroup(ref) + " Reference from '" + fromAddrStr + "' " + this.getOperandIndexString(ref) + " to '" + toAddrStr + "' was removed in one version and changed in other.";
        panel.setHeader(text);
        panel.setRowHeader(this.getReferenceInfo(null, null, null, null));
        String latestPrefix = latestRef == null ? "Remove as in '" : "Change as in '";
        String myPrefix = myRef == null ? "Remove as in '" : "Change as in '";
        String suffix = "' version";
        String[] latestRefInfo = this.getReferenceInfo(this.latestPgm, latestRef, latestPrefix, suffix);
        String[] myRefInfo = this.getReferenceInfo(this.myPgm, myRef, myPrefix, suffix);
        panel.addRadioButtonRow(latestRefInfo, "LatestVersionRB", 2, listener);
        panel.addRadioButtonRow(myRefInfo, "CheckedOutVersionRB", 4, listener);
        panel.addInfoRow(this.getReferenceInfo(this.originalPgm, originalRef, "'", suffix));
        return panel;
    }

    protected VerticalChoicesPanel getChangeConflictPanel(Reference myRef, ChangeListener listener) {
        Reference originalRef;
        Reference latestRef;
        VerticalChoicesPanel panel = this.getVerticalConflictPanel();
        panel.setTitle("Reference");
        Address fromAddr = myRef.getFromAddress();
        int opIndex = myRef.getOperandIndex();
        String fromAddrStr = ConflictUtility.getAddressString(myRef.getFromAddress());
        String toAddrStr = ConflictUtility.colorString(ConflictUtility.ADDRESS_COLOR, DiffUtility.getUserToAddressString(this.resultPgm, myRef.getToAddress()));
        if (myRef.isMemoryReference()) {
            latestRef = DiffUtility.getReference(this.myPgm, myRef, this.latestPgm);
            originalRef = DiffUtility.getReference(this.myPgm, myRef, this.originalPgm);
        } else {
            Reference[] latestRefs = this.latestRefMgr.getReferencesFrom(fromAddr, opIndex);
            latestRef = latestRefs.length > 0 ? latestRefs[0] : null;
            Reference[] originalRefs = this.originalRefMgr.getReferencesFrom(fromAddr, opIndex);
            originalRef = originalRefs.length > 0 ? originalRefs[0] : null;
        }
        String text = myRef.isExternalReference() ? this.getRefGroup(myRef) + " Reference from '" + fromAddrStr + "' " + this.getOperandIndexString(myRef) + " was changed in both versions." : this.getRefGroup(myRef) + " Reference from '" + fromAddrStr + "' " + this.getOperandIndexString(myRef) + " to '" + toAddrStr + "' was changed in both versions.";
        panel.setHeader(text);
        panel.setRowHeader(this.getReferenceInfo(null, null, null, null));
        String latestPrefix = "Change as in '";
        String myPrefix = "Change as in '";
        String suffix = "' version";
        panel.addRadioButtonRow(this.getReferenceInfo(this.latestPgm, latestRef, latestPrefix, suffix), "LatestVersionRB", 2, listener);
        panel.addRadioButtonRow(this.getReferenceInfo(this.myPgm, myRef, myPrefix, suffix), "CheckedOutVersionRB", 4, listener);
        panel.addInfoRow(this.getReferenceInfo(this.originalPgm, originalRef, "'", suffix));
        return panel;
    }

    protected VerticalChoicesPanel getAddConflictPanel(Reference myReference, ChangeListener listener) {
        VerticalChoicesPanel panel = this.getVerticalConflictPanel();
        Reference myRef = myReference;
        Reference latestRef = DiffUtility.getReference(this.myPgm, myRef, this.latestPgm);
        Reference originalRef = DiffUtility.getReference(this.myPgm, myRef, this.originalPgm);
        if (latestRef == null) {
            Reference[] latestRefs = this.latestRefMgr.getReferencesFrom(myRef.getFromAddress(), myRef.getOperandIndex());
            Reference reference = latestRef = latestRefs.length > 0 ? latestRefs[0] : null;
        }
        if (originalRef == null) {
            Reference[] originalRefs = this.originalRefMgr.getReferencesFrom(myRef.getFromAddress(), myRef.getOperandIndex());
            originalRef = originalRefs.length > 0 ? originalRefs[0] : null;
        }
        panel.setTitle("Reference");
        String fromAddrStr = ConflictUtility.getAddressString(myRef.getFromAddress());
        String text = this.getRefGroup(myRef) + " Reference from '" + fromAddrStr + "' " + this.getOperandIndexString(myRef) + " was added in both versions.";
        panel.setHeader(text);
        panel.setRowHeader(this.getReferenceInfo(null, null, null, null));
        String latestPrefix = "Use '";
        String myPrefix = "Use '";
        String suffix = "' version";
        panel.addRadioButtonRow(this.getReferenceInfo(this.latestPgm, latestRef, latestPrefix, suffix), "LatestVersionRB", 2, listener);
        panel.addRadioButtonRow(this.getReferenceInfo(this.myPgm, myRef, myPrefix, suffix), "CheckedOutVersionRB", 4, listener);
        panel.addInfoRow(this.getReferenceInfo(this.originalPgm, originalRef, "'", suffix));
        return panel;
    }

    protected VerticalChoicesPanel getPrimaryConflictPanel(Address fromAddress, int opIndex, ChangeListener listener) {
        VerticalChoicesPanel panel = this.getVerticalConflictPanel();
        Reference latestPrimary = this.latestRefMgr.getPrimaryReferenceFrom(fromAddress, opIndex);
        Reference myPrimary = this.myRefMgr.getPrimaryReferenceFrom(fromAddress, opIndex);
        panel.setTitle("Reference");
        String fromAddrStr = ConflictUtility.getAddressString(fromAddress);
        String text = " Conflicting primary references at '" + fromAddrStr + "' " + this.getOperandIndexString(opIndex) + ".";
        panel.setHeader(text);
        panel.setRowHeader(this.getReferenceInfo(null, null, null, null));
        String prefix = "Set '";
        String suffix = "' version to primary";
        panel.addRadioButtonRow(this.getReferenceInfo(this.latestPgm, latestPrimary, prefix, suffix), "LatestVersionRB", 2, listener);
        panel.addRadioButtonRow(this.getReferenceInfo(this.myPgm, myPrimary, prefix, suffix), "CheckedOutVersionRB", 4, listener);
        return panel;
    }

    private String getRefGroup(Reference ref) {
        if (ref.isMemoryReference()) {
            return "Memory";
        }
        if (ref.isExternalReference()) {
            return "External";
        }
        if (ref.isStackReference()) {
            return "Stack";
        }
        if (ref.isRegisterReference()) {
            return "Register";
        }
        return "Unknown";
    }

    private String[] getReferenceInfo(Program pgm, Reference ref, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Type", "From", "Operand", "To", "Symbol", "Primary", "Source"};
        }
        String[] info = new String[]{"", "", "", "", "", "", "", ""};
        String version = "";
        if (pgm == this.originalPgm) {
            version = "Original";
        } else if (pgm == this.latestPgm) {
            version = "Latest";
        } else if (pgm == this.myPgm) {
            version = "Checked Out";
        } else if (pgm == this.resultPgm) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        if (ref != null) {
            ExternalReference extRef;
            ExternalLocation externalLocation;
            int opIndex = ref.getOperandIndex();
            info[1] = ref.getReferenceType().toString();
            info[2] = ref.getFromAddress().toString();
            info[3] = opIndex == -1 ? "mnemonic" : Integer.toString(opIndex);
            Address toAddress = ref.getToAddress();
            if (ref.isExternalReference() && (externalLocation = (extRef = (ExternalReference)ref).getExternalLocation()) != null) {
                toAddress = externalLocation.getAddress();
            }
            info[4] = DiffUtility.getUserToAddressString(pgm, toAddress);
            info[5] = DiffUtility.getUserToSymbolString(pgm, ref);
            info[6] = "" + ref.isPrimary();
            info[7] = ref.getSource().toString();
        }
        return info;
    }

    private String getOperandIndexString(Reference ref) {
        String opIndexStr = ConflictUtility.getNumberString(ref.getOperandIndex());
        return ref.isMnemonicReference() ? "mnemonic" : "operand " + opIndexStr;
    }

    private String getOperandIndexString(int opIndex) {
        String opIndexStr = ConflictUtility.getNumberString(opIndex);
        return opIndex == -1 ? "mnemonic" : "operand " + opIndexStr;
    }

    private void resolveTypeConflict(Address fromAddress, int opIndex, int chosenConflictOption) {
        if ((chosenConflictOption & 2) != 0) {
            this.listingMergeMgr.mergeLatest.replaceReferences(fromAddress, opIndex);
        } else if ((chosenConflictOption & 4) != 0) {
            this.listingMergeMgr.mergeMy.replaceReferences(fromAddress, opIndex);
        }
    }

    private void resolveRemoveVsChange(Reference ref, int chosenConflictOption) {
        Reference resultRef = DiffUtility.getReference(this.originalPgm, ref, this.resultPgm);
        long resultSymID = -1L;
        if ((chosenConflictOption & 2) != 0) {
            int opIndex;
            Address fromAddr22;
            Reference latestRef = DiffUtility.getReference(this.originalPgm, ref, this.latestPgm);
            if (ref != null && ref.getReferenceType().isFallthrough() && (latestRef = this.getFallThroughReference(this.latestPgm, fromAddr22 = ref.getFromAddress(), opIndex = ref.getOperandIndex())) == null) {
                Address fallthroughAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.originalPgm, (Address)fromAddr22, (Program)this.resultPgm);
                this.clearFallThroughOverride(this.resultPgm, fallthroughAddr);
                return;
            }
            resultSymID = latestRef != null ? latestRef.getSymbolID() : -1L;
            try {
                resultSymID = this.getResultIDFromLatestID(resultSymID);
            }
            catch (NoValueException fromAddr22) {
                // empty catch block
            }
            this.listingMergeMgr.mergeLatest.replaceReference(resultRef, latestRef, resultSymID);
        } else if ((chosenConflictOption & 4) != 0) {
            int opIndex;
            Address fromAddr;
            Reference myRef = DiffUtility.getReference(this.originalPgm, ref, this.myPgm);
            if (ref != null && ref.getReferenceType().isFallthrough() && (myRef = this.getFallThroughReference(this.myPgm, fromAddr = ref.getFromAddress(), opIndex = ref.getOperandIndex())) == null) {
                Address fallthroughAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.originalPgm, (Address)fromAddr, (Program)this.resultPgm);
                this.clearFallThroughOverride(this.resultPgm, fallthroughAddr);
                return;
            }
            resultSymID = myRef != null ? myRef.getSymbolID() : -1L;
            try {
                resultSymID = this.getResultIDFromMyID(resultSymID);
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            this.listingMergeMgr.mergeMy.replaceReference(resultRef, myRef, resultSymID);
        } else {
            return;
        }
    }

    private void resolveChangeConflict(Reference ref, int chosenConflictOption) {
        Reference resultRef = DiffUtility.getReference(this.originalPgm, ref, this.resultPgm);
        if ((chosenConflictOption & 2) != 0) {
            this.keepLatestRefForChangeConflict(ref, resultRef);
        } else if ((chosenConflictOption & 4) != 0) {
            this.keepMyRefForChangeConflict(ref, resultRef);
        } else {
            return;
        }
    }

    private void keepLatestRefForChangeConflict(Reference ref, Reference resultRef) {
        Reference[] latestRefs;
        Reference latestRef = ref.isMemoryReference() ? DiffUtility.getReference(this.originalPgm, ref, this.latestPgm) : ((latestRefs = this.latestRefMgr.getReferencesFrom(ref.getFromAddress(), ref.getOperandIndex())).length > 0 ? latestRefs[0] : null);
        long resultSymID = latestRef != null ? latestRef.getSymbolID() : -1L;
        try {
            resultSymID = this.getResultIDFromLatestID(resultSymID);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.listingMergeMgr.mergeLatest.replaceReference(resultRef, latestRef, resultSymID);
    }

    private void keepMyRefForChangeConflict(Reference ref, Reference resultRef) {
        Reference[] myRefs;
        Reference myRef = ref.isMemoryReference() ? DiffUtility.getReference(this.originalPgm, ref, this.myPgm) : ((myRefs = this.myRefMgr.getReferencesFrom(ref.getFromAddress(), ref.getOperandIndex())).length > 0 ? myRefs[0] : null);
        long resultSymID = myRef != null ? myRef.getSymbolID() : -1L;
        try {
            resultSymID = this.getResultIDFromMyID(resultSymID);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.listingMergeMgr.mergeMy.replaceReference(resultRef, myRef, resultSymID);
    }

    private Reference resolveAddConflict(Reference ref, int chosenConflictOption) {
        Reference myRef = ref;
        Reference resultRef = null;
        if ((chosenConflictOption & 2) != 0) {
            resultRef = this.keepLatestRefForAddConflict(ref, myRef, resultRef);
        } else if ((chosenConflictOption & 4) != 0) {
            resultRef = this.keepMyRefForAddConflict(ref, myRef, resultRef);
        }
        return resultRef;
    }

    private Reference keepLatestRefForAddConflict(Reference ref, Reference myRef, Reference resultRef) {
        Reference latestRef = DiffUtility.getReference(this.myPgm, myRef, this.latestPgm);
        if (ref.isMemoryReference()) {
            resultRef = DiffUtility.getReference(this.latestPgm, latestRef, this.resultPgm);
        } else {
            Reference[] latestRefs = this.latestRefMgr.getReferencesFrom(ref.getFromAddress(), ref.getOperandIndex());
            latestRef = latestRefs.length > 0 ? latestRefs[0] : null;
        }
        long resultSymID = latestRef != null ? latestRef.getSymbolID() : -1L;
        try {
            resultSymID = this.getResultIDFromLatestID(resultSymID);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        resultRef = resultRef == null ? this.listingMergeMgr.mergeLatest.addReference(latestRef, resultSymID, true) : this.listingMergeMgr.mergeMy.replaceReference(resultRef, latestRef);
        return resultRef;
    }

    private Reference keepMyRefForAddConflict(Reference ref, Reference myRef, Reference resultRef) {
        if (ref.isMemoryReference()) {
            resultRef = DiffUtility.getReference(this.myPgm, myRef, this.resultPgm);
        } else {
            Reference[] myRefs = this.myRefMgr.getReferencesFrom(ref.getFromAddress(), ref.getOperandIndex());
            myRef = myRefs.length > 0 ? myRefs[0] : null;
        }
        long resultSymID = myRef != null ? myRef.getSymbolID() : -1L;
        try {
            resultSymID = this.getResultIDFromMyID(resultSymID);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        resultRef = resultRef == null ? this.listingMergeMgr.mergeMy.addReference(myRef, resultSymID, true) : this.listingMergeMgr.mergeMy.replaceReference(resultRef, myRef);
        return resultRef;
    }

    private void resolvePrimaryConflict(Address fromAddress, int opIndex, int chosenConflictOption) {
        Reference my;
        Reference result;
        if ((chosenConflictOption & 2) != 0) {
            Reference latest = this.latestRefMgr.getPrimaryReferenceFrom(fromAddress, opIndex);
            Reference result2 = DiffUtility.getReference(this.latestPgm, latest, this.resultPgm);
            if (result2 != null) {
                this.resultRefMgr.setPrimary(result2, true);
            }
        } else if ((chosenConflictOption & 4) != 0 && (result = DiffUtility.getReference(this.myPgm, my = this.myRefMgr.getPrimaryReferenceFrom(fromAddress, opIndex), this.resultPgm)) != null) {
            this.resultRefMgr.setPrimary(result, true);
        }
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictSet;
    }

    private int getChoiceForConflictType(int programMergeCommentType) {
        switch (programMergeCommentType) {
            case 1: {
                return this.referenceTypeChoice;
            }
            case 5: {
                return this.primaryReferenceChoice;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.referenceChoice;
            }
        }
        return 0;
    }

    private void setChoiceForConflictType(int programMergeConflictType, int choiceForConflictType) {
        switch (programMergeConflictType) {
            case 1: {
                this.referenceTypeChoice = choiceForConflictType;
                break;
            }
            case 5: {
                this.primaryReferenceChoice = choiceForConflictType;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.referenceChoice = choiceForConflictType;
                break;
            }
            default: {
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"Unrecognized Reference Conflict Type", (Object)("Unrecognized indicator (" + programMergeConflictType + ") for reference conflict type to merge."));
            }
        }
    }

    private long getResultIDFromLatestID(long latestSymbolID) throws NoValueException {
        try {
            return this.latestResolvedSymbols.get(latestSymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            if (this.resultPgm.getSymbolTable().getSymbol(latestSymbolID) != null) {
                return latestSymbolID;
            }
            Symbol latestSymbol = this.latestPgm.getSymbolTable().getSymbol(latestSymbolID);
            if (latestSymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)latestSymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private long getResultIDFromMyID(long mySymbolID) throws NoValueException {
        try {
            return this.myResolvedSymbols.get(mySymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            Symbol originalSymbol = this.originalPgm.getSymbolTable().getSymbol(mySymbolID);
            if (originalSymbol == null) {
                throw e;
            }
            if (this.resultPgm.getSymbolTable().getSymbol(mySymbolID) != null) {
                return mySymbolID;
            }
            Symbol mySymbol = this.myPgm.getSymbolTable().getSymbol(mySymbolID);
            if (mySymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)mySymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private long getExternalResultIDFromLatestID(long latestSymbolID) throws NoValueException {
        try {
            return this.latestResolvedSymbols.get(latestSymbolID);
        }
        catch (NoValueException e) {
            if (this.resultPgm.getSymbolTable().getSymbol(latestSymbolID) != null) {
                return latestSymbolID;
            }
            throw e;
        }
    }

    private long getExternalResultIDFromMyID(long mySymbolID) throws NoValueException {
        try {
            return this.myResolvedSymbols.get(mySymbolID);
        }
        catch (NoValueException e) {
            if (this.resultPgm.getSymbolTable().getSymbol(mySymbolID) != null) {
                return mySymbolID;
            }
            throw e;
        }
    }

    private long getExternalResultIDFromOriginalID(long originalSymbolID) throws NoValueException {
        try {
            return this.origResolvedSymbols.get(originalSymbolID);
        }
        catch (NoValueException e) {
            if (this.resultPgm.getSymbolTable().getSymbol(originalSymbolID) != null) {
                return originalSymbolID;
            }
            throw e;
        }
    }
}

